/* html2rss.c
 *
 *  GNU-Darwin html to rss converter
 *
 *  Copyright (c) 2002, Michael L. Love
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */


#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>

main(int argc,char *argv[])
{
const char *title=argv[1];
const char *link=argv[2];
const char *image=argv[3];

const char *linkstart=&"href=\"";
const char *linkend=&"\" style=";
const char *titlestart=&"#ffffff\">";
const char *titleend=&"</font></a>";

const char s1[10000];
int s1len;
int linkstartlen, linkendlen, titlestartlen, titleendlen;
int linkstartpoint=0, linkendpoint=0, titlestartpoint=0, titleendpoint=0;
int i=0, j=0;

linkstartlen=strlen(linkstart);
linkendlen=strlen(linkend);
titlestartlen=strlen(titlestart);
titleendlen=strlen(titleend);

printf ("<rdf:RDF\n");
printf ("xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n");
printf ("xmlns=\"http://my.netscape.com/rdf/simple/0.9/\">\n");
printf ("\n");
printf ("<channel>\n");
printf ("<title>%s</title>\n", title);
printf ("<link>%s</link>\n", link);
printf ("</channel>\n");
printf ("\n");
printf ("<image>\n");
printf ("<title>%s</title>\n", title);
printf ("<url>%s</url>\n", image);
printf ("<link>%s</link>\n", link);
printf ("</image>\n");
printf ("\n");


while(1)
	{
        for ( i=0; i>=0; i++)
        	{
                s1[i] = getchar();
                if ( s1[i] == EOF )
			{
			printf ("\n");
			printf ("</rdf:RDF>");
                        return(0);
			}
                if ( s1[i] == '\n' )
			{	
			s1[i]=0;
			s1len=i;
                        i=-100;
			}
        	}

	for ( j=0; j<=s1len; j++ )
		{
		if ( mystrncmp( &(s1[j]), linkstart , linkstartlen ) )
			{
			linkstartpoint=j+linkstartlen;
			}
		if ( mystrncmp( &(s1[j]), linkend, linkendlen ) )
			{
			linkendpoint=j+linkendlen;
			s1[j]=0;
			}
		if ( mystrncmp( &(s1[j]), titlestart, titlestartlen ) )
			{
			titlestartpoint=j+titlestartlen;
			}
		if ( mystrncmp( &(s1[j]), titleend, titleendlen ) )
			{
			titleendpoint=j+titleendlen;
			s1[j]=0;
			}
		}

	printf ("<item>\n"); 
	printf ("<title>%s</title>\n", &(s1[titlestartpoint]) );
	printf ("<link>%s</link>\n", &(s1[linkstartpoint]) );
	printf ("</item>\n"); 
	printf ("\n");  
                
	}               

printf ("\n");          
printf ("</rdf:RDF>");  

}                       

int mystrncmp ( const char *s1 , const char *s2 , int len )
{
int i;
for (i=0; i<len; i++)
		{ 
		if ( s1[i] != s2[i] )
			return 0;
		}
return 1;
}
