# Generated automatically from Makefile.in by configure.
SHELL = /bin/sh

CP = /bin/cp
GZIP = /usr/bin/gzip
INSTALL = /usr/bin/install -c
RM = /bin/rm
STRIP = /usr/bin/strip
TAR = /usr/bin/tar


prefix = /usr/local
exec_prefix = ${prefix}
bindir = ${exec_prefix}/bin
includedir = ${prefix}/include
libdir = ${exec_prefix}/lib
mandir = ${prefix}/man
auxdir = ${prefix}/share/xplanet
version = 0.73
distdir = xplanet-$(version)

CC = gcc
CPPFLAGS += -I${prefix}/include -Wall -O -pipe  
CXX = c++
CXXFLAGS += -I/usr/X11R6/include   $(CPPFLAGS)

X_LIBS = \
-L/usr/lib -lstdc++ -lcc_dynamic -lobjc \
-L/usr/local/lib  -lungif -ljpeg  -lpng  -ltiff -lz -lglut -lGLU -lGL \
-L/usr/X11R6/lib  -lXpm -lXmu -lX11 -lXext \
#-L/System/Library/Frameworks/OpenGL.framework/Versions/A/Libraries/ \
OPENGL_LIBS = #-lXext  -lXi
MAGICK_LIBS = 
#/Darwin/usr/X11R6/lib/libGL.a
#/System/Library/Frameworks/OpenGL.framework/Versions/A/Libraries/libGL.dylib
#/System/Library/Frameworks/OpenGL.framework/Versions/A/Libraries/libGLImage.dylib
#/System/Library/Frameworks/OpenGL.framework/Versions/A/Libraries/libGLSystem.dylib
#/System/Library/Frameworks/OpenGL.framework/Versions/A/Libraries/libGLU.dylib
GTK_LIBS = 
GRAPHICS_LIBS = #

SRCS = 	xplanet.cc \
	draw_markers.cc \
	 \
	get_color.cc \
	glutfuncs.cc \
	location.cc \
	moonpos.cc \
	options.cc \
	planet.cc \
	Projection.cc \
	ProjectionAzimuthal.cc \
	ProjectionMercator.cc \
	ProjectionMollweide.cc \
	ProjectionOrthographic.cc \
	ProjectionRectangular.cc \
	ssec.cc \
	sunpos.cc \
	util.cc \
	xroutines.cc

OBJS = $(SRCS:.cc=.o)
AUXDIR = $(notdir $(wildcard auxdir/*.jpg auxdir/*-markers.txt))

.cc.o: 
	$(CXX) -c $(CXXFLAGS) $< 

all: xplanet 

xplanet: $(OBJS) libimage/libimage.a getopt.o getopt1.o xp_getopt.o
	$(CXX) -o $@ $^ $(LIBS) $(X_LIBS) $(OPENGL_LIBS) $(MAGICK_LIBS) $(GRAPHICS_LIBS) 

xplanetbg: xplanetbg.o orbit.o getopt.o getopt1.o xp_getopt.o
	$(CXX) -o $@ $^ $(X_LIBS) 

libimage/libimage.a:
	(cd libimage; $(MAKE))

xplanet.o: auxfiles.h checkfuncs.h options.h planet.h \
Projection.h ProjectionAzimuthal.h ProjectionMercator.h ProjectionMollweide.h \
ProjectionOrthographic.h ProjectionRectangular.h sunpos.h util.h xroutines.h 

get_color.o: options.h util.h xplanet.h

glutfuncs.o: xplanet.h util.h

location.o: location.h util.h

moonpos.o: util.h

options.o: checkfuncs.h xp_getopt.h options.h util.h xplanet.h

planet.o: options.h planet.h util.h

Projection.o: get_color.h location.h options.h planet.h util.h \
xroutines.h

ProjectionAzimuthal.o: ProjectionAzimuthal.h get_color.h options.h util.h

ProjectionMollweide.o: ProjectionMollweide.h get_color.h options.h util.h

ProjectionMercator.o: ProjectionMercator.h get_color.h options.h util.h

ProjectionOrthographic.o: ProjectionOrthographic.h get_color.h location.h \
options.h planet.h util.h xplanet.h xroutines.h

ProjectionRectangular.o: ProjectionRectangular.h location.h options.h util.h

draw_markers.o: options.h planet.h Projection.h xplanet.h util.h xroutines.h

sunpos.o: util.h

xroutines.o: checkfuncs.h draw_markers.h location.h options.h planet.h util.h xplanet.h

xplanetbg.o: xplanetbg.cc checkfuncs.h xp_getopt.h orbit.h xplanetbg.h

orbit.o: orbit.cc orbit.h

install:
	$(INSTALL) -d $(bindir)
	$(INSTALL) xplanet $(bindir)
	$(INSTALL) xplanetbg $(bindir)
	$(INSTALL) -m 755 tkxplanet $(bindir)
	$(INSTALL) -m 755 tzcoord.pl $(bindir)
	$(INSTALL) -d $(mandir)
	$(INSTALL) -d $(mandir)/man1
	$(INSTALL) -m 644 tkxplanet.1 $(mandir)/man1
	$(INSTALL) -m 644 tzcoord.pl.1 $(mandir)/man1
	$(INSTALL) -m 644 xplanet.1 $(mandir)/man1
	$(INSTALL) -m 644 xplanetbg.1 $(mandir)/man1
	$(INSTALL) -d $(auxdir)
ifneq ($(AUXDIR),)
	$(INSTALL) -m 644 $(addprefix auxdir/,$(AUXDIR)) $(auxdir)
endif

install-strip: install
	$(STRIP) $(bindir)/xplanet
	$(STRIP) $(bindir)/xplanetbg

uninstall:
	$(RM) $(bindir)/xplanet
	$(RM) $(bindir)/xplanetbg
	$(RM) $(bindir)/tkxplanet
	$(RM) $(bindir)/tzcoord.pl
	$(RM) $(mandir)/man1/xplanet.1
	$(RM) $(mandir)/man1/xplanetbg.1
ifneq ($(AUXDIR),)
	$(RM) $(addprefix $(auxdir)/, $(AUXDIR))
endif

dist: 	
	$(INSTALL) -d $(distdir)
	$(CP) COPYING CREDITS ChangeLog FAQ INSTALL Makefile* README *.c \
	*.cc *.h *.h.in tkxplanet* tzcoord.pl* aclocal.m4 configure* *.1 \
	$(distdir)
	$(CP) -r autoconf $(distdir)
	$(INSTALL) -d $(distdir)/libimage
	$(CP) libimage/README libimage/*.in libimage/Makefile libimage/*.c \
	libimage/*.h $(distdir)/libimage
ifneq ($(AUXDIR),)
	$(INSTALL) -d $(distdir)/auxdir
	$(CP) -r auxdir/*.txt $(distdir)/auxdir	
endif
	$(TAR) cf $(distdir).tar $(distdir)
	$(GZIP) -9 $(distdir).tar
	$(RM) -fr $(distdir)

clean:
	$(RM) *.o 
	(cd libimage; $(MAKE) clean)

distclean:
	$(RM) *.o auxfiles.h checkfuncs.h xplanet xplanetbg xplanetbg.h \
	config.* tkxplanet tzcoord.pl Makefile; \
	(cd libimage; $(MAKE) distclean)
