# $Id: Logger.pm,v 1.1.1.1 2001/06/04 23:39:28 proclus Exp $

# This program is copyrighted free software; you can redistribute it and/or
# modify it under the same terms as Web Polygraph itself.

package Logger;
use strict;

#
# very simple logging interface
#

require Exporter;

@Logger::ISA = qw( Exporter );
@Logger::EXPORT = qw( &Log  &Logf &LogPrefix &ButifyBuf);

sub Log {
	#print(&LogPrefix(), @_, "\n");
	my $buf = join('', &LogPrefix(), @_, "\n");
	syswrite(STDOUT, $buf, length($buf));
	return undef;
}

sub Logf {
	my $fmt = shift;
	return Log(sprintf($fmt, @_));
}

sub ButifyBuf {
	my $buf = shift;

	die($buf) if $buf !~ /\n/;

	my $pfx = &LogPrefix();
	$buf = join("\n",
		map { $pfx . "\t" . $_ }
		split(/\n/m, $buf));

	return $buf;
}

sub LogPrefix {
	return &timeStr() . '| ';
}

sub timeStr {
	my $tm = shift || time();
	my ($sec,$min,$hour,$mday,$mon,$year) = localtime($tm);
	return sprintf('%02d/%02d %02d:%02d.%02d', 
		1+$mon, $mday, $hour, $min, $sec);
}
