# $Id: Tools.pm,v 1.1.1.1 2001/06/04 23:39:28 proclus Exp $

# This program is copyrighted free software; you can redistribute it and/or 
# modify it under the same terms as Web Polygraph itself.

package BB::Tools;
use strict;

#
# carious BB tools
#

@BB::Tools::ISA = qw( Exporter );
@BB::Tools::EXPORT = qw ( &Breed &EvalVars &CloneArr);

sub Breed {
	my $source = shift;
	die unless $source;
	die(caller) unless scalar @_;

	my @kids = ();

	foreach my $cfg (@_) {
		my %c = %{$cfg};
		$c{'cmd_id'} = 2 + scalar @kids;
		my $clone = $source->clone(\%c) or die();
		push @kids, $clone;
	}

	return ( @kids );
}

sub EvalVars {
	my ($template, $cfg) = @_;
	die() unless $cfg;

	my ($n, $v);
	while ( ($n, $v) = each %{$cfg} ) {
		$template =~ s/\$$n\b/$v/mge;
		$template =~ s/\$\{$n\}/$v/mge;
	}

	return $template;
}

sub CloneArr {
	my ($arr, $cfg) = @_;

	my @clones = ();

	foreach (@{$arr}) {
		push @clones, $_->clone($cfg);
	}

	return [ @clones ];
}

1;
