#!/usr/bin/env ruby

require 'mkmf'

if with_config("buggy-iconv")
  $CFLAGS += " -DBUGGY_ICONV"
end

if have_header("iconv.h")
  have_library("iconv", "iconv")
  if method(:have_func).arity != 1
    have_func("rb_obj_freeze", "ruby.h")
    have_func("rb_block_given_p", "ruby.h")
  end
  $objs = ["iconv.o"]
  create_makefile("iconv")
end
open("Makefile", "a") {|mf|
  mf.print <<EOMF

doc: iconv.html iconv.rlog.html iconv.rmi.html
dist tarball: iconv.tarball

Makefile: extconf.rb; ruby $<

%.html: %.c; rd2html --with-css=rd.css -o$* $<
%.rmi.html: %.rmi; rmi2html $< > $@
%.rmi: %.c; rd2rmi -o$* $<
%.rlog.html: %.rlog %.rmi; rd2html --with-rmi=$*.rmi --with-css=rd.css -o$*.rlog $<
%.tarball: %.c %.rlog MANIFEST; mktarball -f $< $*
%.rlog: %.c; rlog2rd -o$@ $<
EOMF
}
