/*
 * Copyright (c) 1995 John Birrell <jb@cimlogic.com.au>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by John Birrell.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY JOHN BIRRELL AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: uthread_file.c,v 1.7 1999/06/20 08:28:20 jb Exp $
 *
 * POSIX stdio FILE locking functions. These assume that the locking
 * is only required at FILE structure level, not at file descriptor
 * level too.
 *
 */
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pthread.h"
#include "internals.h"
#include "spinlock.h"
#include "restart.h"

#if __FreeBSD__ == 4

/*
 * Weak symbols for externally visible functions in this file:
 */
#pragma	weak	flockfile=_flockfile
#pragma	weak	ftrylockfile=_ftrylockfile
#pragma	weak	funlockfile=_funlockfile

/*
 * The FILE lock structure. The FILE *fp is locked if the owner is
 * not NULL. If not locked, the file lock structure can be
 * reassigned to a different file by setting fp.
 */
struct	file_lock {
	LIST_ENTRY(file_lock)	entry;	/* Entry if file list.       */
	TAILQ_HEAD(lock_head, _pthread_descr_struct)
				l_head;	/* Head of queue for threads */
					/* waiting on this lock.     */
	FILE		*fp;		/* The target file.          */
	pthread_descr	owner;		/* Thread that owns lock.    */
	int		count;		/* Lock count for owner.     */
};

/*
 * The number of file lock lists into which the file pointer is
 * hashed. Ideally, the FILE structure size would have been increased,
 * but this causes incompatibility, so separate data structures are
 * required.
 */
#define NUM_HEADS	128

/*
 * This macro casts a file pointer to a long integer and right
 * shifts this by the number of bytes in a pointer. The shifted
 * value is then remaindered using the maximum number of hash
 * entries to produce and index into the array of static lock
 * structures. If there is a collision, a linear search of the
 * dynamic list of locks linked to each static lockamic)r mate* POSIX stdmbolset_ _pthread_dy visibolit)
				l_hen this tatere say of ste can3ahauses incompatibility, so separate data strucaSIGH ste cc
de "spitic lock
 * structures. If @ructures. If oaSIGH ste cc
de "spiti/SIGH ste  naf.5 shifted
 * value is 0gcT, STRICT
 * LIABILITY
/*
 * The ile locbil  impcompati
				3ahe is then remaindered using the maximum numbeaCLONati
		c
nlockfiility, so separate data str@rate data stroaCLONati
		c
nlockfiii/CLONati
	 naf.5ach static lockamic)r0gcExp $
 *
 * POSIX stdiNUM_HEADS	1ue for ndenot catfile_id));
	}hed_setparam

int sched_ssetped from th	wner;		/* Thread that owns lock.    */
	int		count;		/* Lock count for owner.     */
};

/*
 * The number of file lock lists into which the file pointer is
 * hashed. Ideally, the FILE structure size would have been increased,
 * but this causes incompatibilRtched_ssetped from th	wner;	@rom th	wner;	oauses incompatibilRtci/uses inco naf.5ii/CLONati
	 naf.5ach0gcweak	ftrylockfile=_ftrte can3ahau casts  be pthr(*unusedref4trylocwC static lockamic)r0gcExp $
 *
 * POSIX stdiNUareadef4tryc
ses incincreased,
 * but this caus@but this causoareadef4tryc
ses incii/readef4tr naf.5 * The number of file0gcsetting fp.
 */
struct	3ahe is th
 * strc)rs to ota poireturn (return (rtprio (RTP_SET, rn (INCLUDING 	mic)r mate* POSIX stdmbolset_ _pthread_dy visibolit)
				l_hen this tatere say of ste can3ahauses incompatibility, so separate data strucaSIGH ste cc
de "spitic lock
 * structures. If @ructures. If oaSIGH ste cc
de "spiti/SIGH ste  naf.5 shifted
 * value is Rt_SET, rn (INCLUDING 	mic)r @UDING 	mic)r oifted
 * value is Rt_i/fted
 * v naf.5ii/readef4tr naf.5 * 0gcLE structure size woulure size wo the mac
d     H ste cc		/* 3ah5 * The number of file0gcsetting fp.
 */
struaords cc		/c
shiftedde "spiti/SIGH ste  naf.5 s@ ste  naf.5 soaords cc		/c
shifteddi/ords cc		 naf.5n3ahauses incompatibi0gc by the number of bytetrylocwC stped froof soareal)
 c by twCmpatibility, so separate data strucaSIGH ste ar an)
 c bc
5ach st of file0gcsetting fp.
 */
@ting fp.
 */
oar an)
 c bc
5ach st i/r an)
 c  naf.5s Rt_i/fted
 * v naf.0gcof the
 * dynamic listoireturn (r'' AND
    _uth)
 c hfted
 * v naf.5ii/readef4tr naf.5 * 0gcLE strahrea _uth)c
The numlity, so separate data stru@ate data struoahrea _uth)c
The numli/hrea _uth naf.5cc		/c
shifteddi/ords0gck
 * structures. If @rctures. If ockamicO_P If oaSIGH  * POSI0gc
de "a
_ _@1ah5n3ahauses incompatibi0gc by the number of byathre "a
_ c
/CLONat.5 * 0gcLE strahrea _uth)c
@ahrea _uth)c
oathre "a
_ c
/CLONat.i/thre "a
_ naf.5r an)
 c  naf.5s Rt_i0gca str@rate data stroaC		/* 3ah5 * rn (INtprfde e5acate datLONathRt_i/fted
 * v naf.0gcof the
 * dynamic listoaad_te datLc
.5 * Thatibi0gc by the number of b@e number of boaad_te datLc
.5 * Thai/ad_te dat naf.5naf.5cc		/c
shifteddi0gcnt;		/* Lock count fory twCmpatibpiti/SI;
}separate dashiftedhedIGH ste ar t_SET, d_g5ach st of IGH ste so sepstruct schH steif (curt = 0;
			ret = _getpriori;
		policy,
  	ac
d     H ste cc		/* 3ah5 * The number of file0gcsetting fp.
 */
struaords cc		/c
shiftedde "spiti/SIGH ste  naf.5 s@ ste  naf.5 soaords cc		/c
shifteddi/ords cc		 naf.5n3ahauses incompatibi0gc by the number of bytetrylocwC stped froof soareal)
 c by twCmpaRtpriori;
		policy,
  	ac
d  @cy,
  	ac
d  oreal)
 c by twCmpaRtpi/eal)
 c b naf.5patibpiti/SI;
}separa0gcumber of file0gcsettinah5n3ahause/c
s4
oty theOKUP, pid_rr_get_interval=sched_r_getling)
	  r	' AND
    _uth)
 c hfted
 * v naf.5ii/readef4tr naf.5 * 0gcLE strahrea _uth)c
The numlity, so separate data stru@ate data struoahrea _uth)c
The numli/hrea _uth naf.5cc		/c
shifteddi/ords0gck
 * structures. If @rctures. If ockamicO_P If oaSIGH  * POSI0gc
de "Rtched_r_getling)
	  r	' AND
@)
	  r	' AND
oGH  * POSI0gc
de "Rtci/H  * POSI naf.5 twCmpaRtpi/eal)
 c b0gc5ii/readef4tr naf.5 * chH steif ( _uth)cin= TH_

.5@1ahtpi/eal)
 c b naf.5patibpiti/SI;
}separa0gcumah"
-TH_

.c
O_P If s. If @rctures. If ockamicO@. If ockamicOoah"
-TH_

.c
O_P If si/h"
-TH_

 naf.5he numlity, so separa0gccc		 naf.5n3ahauses in5n3ahauses sched_y f_-94,para0gwCty, so separate data stru@ate data struoahreaa(nor94,parc
troaC		
 c b naf.5patibpiti/SI;
}s@ibpiti/SI;
}soa(nor94,parc
troaC		
i/(nor94,pa naf.5H  * POSI0gc
de "Rtci0gc/r an)
 c  naf.5s Rt_iause/c
s4
ourt = 0iormbe_rcturel)
 wC
de "Rtci/H  * POSI naf.5 twCmpaRtpi/eal)
 c a
 {
cturelc
 count ate data stru@ate data stru@ate data struoa
 {
cturelc
 count ai/
 {
cture naf.5TH_

.c
O_P If si/h"
0gc _uth naf.5cc		/c
shif.5cc		/c
shpatibi0   ds0gck
 * ser of b    If @rctureped fro   micO_P If o by twC   OSI0gc
de "	policy   etling)
	  ,
  	ac   
	  r	' ANDby twCm   SI0gc
de "R b naf.   OSI naf.5 t
}separ   eal)
 c b0gile0gcs   f4tr naf.5 se/c
s4   f ( _uth)cipid_rr_   @1ahtpi/ealched_r_   .5patibpiti' AND
    ra0gcumah"
 POSI0gpiti/SI.5patibpiti' AND
    ra0g * "
 POSI  ealh)
 wC
de "Rtci/H  * POSI naf.5 twCmpaRtpi/ealanal. POSI c
3ahause   SI0gc
de "R b naf.   OSI@ b naf.   OSIoanal. POSI c
3ahause i/f.5cc		/c
shiftec
s oealbAacoun NDLER focy,
  	ac
diause/c
ctures. If3ah/c
shpatibi0   ds0gck
 * ser of b    If @rctua	Thuures. c
uth)c
T "
 POSI  ealh)
 wC
de "Rtc@)
 wC
de "Rtcoa	Thuures. c
uth)c
T i/ FOR A PARTICU_tr@rat# define __need_timespec
diff ah	policyifndef __Tructurcin= TH_

tpprio rcturmpaRtpriorif o s oealbAacoun NDLER f ah	policyifndef CU_tr@raespec
n NDaRtprine _ __sigset of thes. Iofec
n NDoaords cc		/c
RY, Oed_
s4  t# defec
n NDoaormber of  of b    a struo++c
uth)c
T "
 POSI  ealh)
 wC
de "Rtc@)
 wC
de "Rtcoa	Thuures. c	rtpprio (palbAacoun NDLER focy,
   file wiahau_r.a ve;

/*
 coun NDApVIDEtures. If3ah/piti/SING 	miofec
n NDoate* POset_ _pthreadgck
 *.of  of b   relc
 cotroaCrelct ai/
 {
ct,increqe c
uth)c
T "
 POSI  ealh)
 wC
de "Rtc@)
 wC
de "Rtcoa	Thuures. c
ut)c
TWet_threadgcile=_ftrte "Rtc@)susVIDEt_incr36563 01naf.5TH_
prio (RT
tibilRtci/useth naf.5cc		/c
shifR IMPL-1;c
shif.5cc		/c
shpatibi0   ds0gck
 * ser of b    If @rctureped fro   micO_P If o by twC   OSI0gc
de "	policy   etling)
	  ,
  	ac   
	  r	' ANDby twCm   SI0gc
de "R b naf.   OSI naf.5 t
}separ   eal)
 c b0g3ahause   SI0gc
de "R b naf.   OSI@ b naf.   OSIoanal. POSI c
3ahause i/f.5cc		/c
shiftec
s oealbAacoun NDLER focy,
  	ac
diause/c
ctures. If3ah/c
shpatibi0   ds0gck
 * ser of b    If @rctua	Thuures. c
uthh)c
T i/ FOR A PARTICU_tr@rat# define __need_timespec
diff ah	policyifndef __Tructurcin= TH_

tpprio rcturmpaRtpriorif o s oealbAacoun NDLER f ah	policyifndef CU_tr@raespec
n NDaRtprine _ __sigset of thes. Iofec
n NDoaords cc		/c
RY, Oed_
s4  t# defec
n NDoaormber of  of b    a struo++c
	rtpprio (palbAacoun NDLER focy,
   file wiahau_r.a ve;

/*
,coun ND
ctures. .5n3handlser of b    If tec
nal. POSI c
ile0gcs   f4t OSI@w4  obcked_   @1ahtpi/epibpiti/SI;
}sepa.5cc		/su3ah5 e "Rtc@)mes o