--- protocols/icmp/nd_icmp.h.orig	Sun Oct 13 12:45:27 2002
+++ protocols/icmp/nd_icmp.h	Sun Oct 13 12:45:40 2002
@@ -30,8 +30,46 @@
 #include <netdude/nd_types.h>
 
 #include <netinet/in.h>
+#include <netinet/ip.h>
 #include <netinet/ip_icmp.h>
 
+#ifdef __FreeBSD__
+#define	ICMP_DEST_UNREACH	ICMP_UNREACH
+#define	ICMP_SOURCE_QUENCH	ICMP_SOURCEQUENCH
+#define	ICMP_TIME_EXCEEDED	ICMP_TIMXCEED
+#define	ICMP_PARAMETERPROB	ICMP_PARAMPROB
+#define	ICMP_TIMESTAMP		ICMP_TSTAMP
+#define	ICMP_TIMESTAMPREPLY	ICMP_TSTAMPREPLY
+#define	ICMP_INFO_REQUEST	ICMP_IREQ
+#define	ICMP_INFO_REPLY		ICMP_IREQREPLY
+#define	ICMP_ADDRESS		ICMP_MASKREQ
+#define	ICMP_ADDRESSREPLY	ICMP_MASKREPLY
+
+#define	ICMP_NET_UNREACH	ICMP_UNREACH_NET
+#define	ICMP_HOST_UNREACH	ICMP_UNREACH_HOST
+#define	ICMP_PROT_UNREACH	ICMP_UNREACH_PROTOCOL
+#define	ICMP_PORT_UNREACH	ICMP_UNREACH_PORT
+#define	ICMP_FRAG_NEEDED	ICMP_UNREACH_NEEDFRAG
+#define	ICMP_SR_FAILED		ICMP_UNREACH_SRCFAIL
+#define	ICMP_NET_UNKNOWN	ICMP_UNREACH_NET_UNKNOWN
+#define	ICMP_HOST_UNKNOWN	ICMP_UNREACH_HOST_UNKNOWN
+#define	ICMP_HOST_ISOLATED	ICMP_UNREACH_ISOLATED
+#define	ICMP_NET_ANO		ICMP_UNREACH_NET_PROHIB
+#define	ICMP_HOST_ANO		ICMP_UNREACH_HOST_PROHIB
+#define	ICMP_NET_UNR_TOS	ICMP_UNREACH_TOSNET
+#define	ICMP_HOST_UNR_TOS	ICMP_UNREACH_TOSHOST
+#define	ICMP_PKT_FILTERED	ICMP_UNREACH_FILTER_PROHIB
+#define	ICMP_PREC_VIOLATION	ICMP_UNREACH_HOST_PRECEDENCE
+#define	ICMP_PREC_CUTOFF	ICMP_UNREACH_PRECEDENCE_CUTOFF
+
+#define	ICMP_REDIR_NET		ICMP_REDIRECT_NET
+#define	ICMP_REDIR_HOST		ICMP_REDIRECT_HOST
+#define	ICMP_REDIR_NETTOS	ICMP_REDIRECT_TOSNET
+#define	ICMP_REDIR_HOSTTOS	ICMP_REDIRECT_TOSHOST
+
+#define	ICMP_EXC_TTL		ICMP_TIMXCEED_INTRANS
+#define	ICMP_EXC_FRAGTIME	ICMP_TIMXCEED_REASS
+#endif
 
 /* ICMP packet structure -- using our own for the funky stuff ... */
 
