/* Header for module datastruct, generated by p2c */
#ifndef DATASTRUCT_H
#define DATASTRUCT_H




#define max_line_width  79

#define ACCOUNTING      false


typedef enum {
  N, P, D, I, X
} transistor_types;



typedef struct nametype {
#if 1
  char *name;
#else
  char name[81];
#endif
  struct nametype *next;
} nametype;



typedef struct trantype {
  long strength;
  struct nodetype *gate, *s1, *s2;
  transistor_types t_type;
  struct trantype *next, *clone;   /* Place to point to my copy. */
  struct tequivtype *my_equiv_class;
  char my_circuit;
} trantype;

typedef struct tran_list_type {
  trantype *tran;
  struct tran_list_type *next;
} tran_list_type;

typedef struct equiv_list_type {
  struct tequivtype *tran_class;
  struct equiv_list_type *next;
} equiv_list_type;

typedef struct nodetype {
  long strength;
  nametype *names;
  tran_list_type *trans;
  struct nodetype *next, *clone;

  long pg, ng, ps, ns;   /* p/n gates and source fanouts */
  struct nequivtype *my_equiv_class;
  equiv_list_type *equiv_list;
  char my_circuit;
} nodetype;

typedef struct nequivtype {
  long count;
  /*   gate, s1, s2 : node_ptr;      */
  nodetype *nodes;
  struct nequivtype *next;
  char good;
  equiv_list_type *equiv_list;
} nequivtype;

typedef struct tequivtype {
  long count;
  nodetype *gate, *s1, *s2;
  nequivtype *egate, *es1, *es2;
  trantype *transistors;
  struct tequivtype *next;
  char good;
} tequivtype;


nequivtype *nequiv;
tequivtype *tequiv;
char dbug;
FILE *outfyle;


char allow_illegal_moves;   /* TRUE if allowed to create bad classes */
char propagate_badness;
    /* TRUE if bad classes allowed to break good classes */
char long_results;   /* TRUE if dbug to be turned on at PRINT_RESULTS time */
char fast_mode;   /* TRUE if good tuples are not to be further considered*/


extern void print_memory ();
extern void dump_data_structure ();
extern void print_names ();
extern void print_all_names ();
extern char *name_list ();
extern void print_node_equiv_class ();
extern void print_node ();
extern void print_node_equiv ();
extern void print_transistor_list ();
extern void print_transistor ();
extern void print_tran_equiv ();

extern void print_tran_equiv_class ();
extern tequivtype *getTEquiv ();
extern nequivtype *getNEquiv ();
extern tran_list_type *getNodeTran ();
extern trantype *getTran ();
extern nodetype *getNode ();
extern nametype *getName ();
extern equiv_list_type *getEquivList ();
/* reclaim the trans used */
extern void reclaim_tran_class ();
/* reclaim the nodes used */
extern void reclaim_node_class ();
/* reclaim the names used */
extern void reclaimName ();
/* Reclaim a list of names. */
extern void reclaimNameList ();
/* reclaim the transistor used */
extern void reclaimTran ();
/* reclaim all transistors in the list */
extern void reclaimTranList ();
/* reclaim an element of the nodes list of transistor pointers */
extern void reclaimNodeTran ();
/* reclaim the nodes list of transistor pointers */
extern void reclaimNodeTranList ();
/* reclaim the node used */
extern void reclaimNode ();
/* reclaim the list of nodes used */
extern void reclaimNodeList ();
extern void reclaimEquivList ();

extern void initialize_data_structure ();
extern trantype *find_tran ();
extern nodetype *find_node ();

extern void print_results ();
extern long number_of_tran_classes ();
extern long number_of_trans_in_class ();
extern void remove_tran_class_from_list ();
extern void add_tclass_to_list ();
extern void add_tran_to_class ();

extern char valid_tran_class ();
extern long number_of_node_classes ();
extern long number_of_nodes_in_class ();
extern char valid_node_class ();
extern void remove_from_list ();
extern void add_nclass_to_list ();


extern void add_node_to_class ();


#endif /*DATASTRUCT_H*/

/* End. */
