
/* "NETCMP", an simple netlist comparator,
   Copyright (C) 1985, 1990 California Institute of Technology.
   Original author: Massimo Sivilotti
   Unix Port Maintainer: John Lazzaro
   Maintainers's address: lazzaro@csvax.caltech.edu;
                          CB 425 CU Boulder/Boulder CO 91125. 


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (any version).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from P2C, the Pascal-to-C translator */
/* From input file "main.text" */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>


#ifndef DATASTRUCT_H
#include "datastruct.h"
#endif

/* Fix string lengths. */
/* Parser for NTK format.  Front end for MOSCMP - a network comparator program. */

#ifndef PARSER_H
#include "parser.h"
#endif

#ifndef COMPARE_H
#include "compare.h"
#endif

#if 0
#ifndef CITINFOMOD_H
#include <p2c/citinfomod.h>
#endif

#ifndef NEWCI_H
#include <p2c/newci.h>
#endif
#endif

/* caged_date="Rconst date = '$X';"    */

#define date_           "Jul 27, 1988 3:18 pm"
#define version         "#1.04"


main(argc, argv)
int argc;
char *argv[];
{

  char automorphisms;
  char command[81];
  char output_reassigned, networks_loaded;
  nodetype *tmp_node;
  char file_ok;
  char infilename1[81], infilename2[81];
  char done;
  FILE *infyle;
  char STR2[256];
  char *TEMP;


  infyle = NULL;
  initialize_data_structure();
  nequiv = getNEquiv();
  tequiv = getTEquiv();
  automorphisms = 0;
  output_reassigned = 0;
  networks_loaded = 0;
  propagate_badness = 0;
  long_results = 0;
  fast_mode = 1;
  dbug = 0;

  outfyle = NULL;
  if (argc == 3) {  /* "netcmp <file1> <file2>" */
    strcpy(infilename1, argv[1]);
    strcpy(infilename2, argv[2]);
    strcpy(command, infilename1);
    if (strpos2(command, ".", 1) == 0)
      strcat(command, ".cmp");
    else {
      sprintf(STR2, "%.*scmp", strpos2(command, ".", 1), command);
      strcpy(command, STR2);
    }
    outfyle = fopen(command, "w");
    if (outfyle == NULL) {
      printf("Unable to open output file: %s\n", command);
      exit (-1);
    }

    nequiv = getNEquiv();
    tequiv = getTEquiv();
    parsefile(1, infilename1);
    parsefile(2, infilename2);
    networks_loaded = 1;
    compare_networks(automorphisms);
    if (outfyle != NULL)
      fclose(outfyle);
    exit(0);
  }


  printf("NETCMP %s; compiled %s\n", version, date_);

  outfyle = NULL;
  while (outfyle == NULL) {
      char username[100];
      char *tmp;

#if defined(freebsd)
      getpwuid(getuid(), username);
#else
      getpw(getuid(), username);
#endif
      tmp = strchr(username,':');
      if (tmp != NULL) *tmp = '\0';
      printf("  Enter output file name [info]: ");
      fgets(command, 81, stdin);
      TEMP = strchr(command, '\n');
      if (TEMP != NULL)  *TEMP = 0;
      if (*command == '\0')
        sprintf(command, "info");
      outfyle = fopen(command, "w");
      if (outfyle == NULL) 
	fprintf(stderr, "No such file: %s\n", command);
  }
  /* fake up a read command */
  nequiv = getNEquiv();
  tequiv = getTEquiv();

  done = 0;
  infyle = NULL;
  while (!done) {
      printf("Enter input filename 1: [.ntk] ");
      fgets(infilename1, 81, stdin);
      TEMP = strchr(infilename1, '\n');
      if (TEMP != NULL) *TEMP = 0;
      if (strpos2(infilename1, ".", 1) == 0)
        strcat(infilename1, ".ntk");
      infyle = fopen(infilename1, "r");
      if (infyle == NULL) 
	printf("Error: file \"%s\" not found.\n", infilename1);
      else done = 1;
  }
  if (infyle != NULL)
    fclose(infyle);
  parsefile(1, infilename1);

  done = 0;
  infyle = NULL;
  while (!done) {
      printf("Enter input filename 2: [.ntk] ");
      fgets(infilename2, 81, stdin);
      TEMP = strchr(infilename2, '\n');
      if (TEMP != NULL)
        *TEMP = 0;
      if (strpos2(infilename2, ".", 1) == 0)
        strcat(infilename2, ".ntk");
      infyle = fopen(infilename2, "r");
      if (infyle == NULL) 
	printf("Error: file \"%s\" not found.\n", infilename2);
      else done = 1;
  }
  if (infyle != NULL)
    fclose(infyle);
  infyle = NULL;
  parsefile(2, infilename2);

  networks_loaded = 1;

  do {
    printf("netcmp> ");
    fgets(command, 81, stdin);
    TEMP = strchr(command, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    if (!strcmp(command, "read")) {
      nequiv = getNEquiv();
      tequiv = getTEquiv();
      parsefile(1, infilename1);
      parsefile(2, infilename2);
      networks_loaded = 1;
    } else {
      if (!strcmp(command, "auto")) {
        automorphisms = !automorphisms;
        printf("   Displaying automorphisms = %s\n",
               automorphisms ? "TRUE" : "FALSE");
      } else if (!strcmp(command, "dbug")) {
        dbug = !dbug;
        printf("   Debugging mode = %s\n", dbug ? "TRUE" : "FALSE");
      } else if (!strcmp(command, "bad")) {
        propagate_badness = !propagate_badness;
        printf("   Propagating badness = %s\n",
               propagate_badness ? "TRUE" : "FALSE");
      } else if (!strcmp(command, "slow")) {
        fast_mode = !fast_mode;
        printf("   Exhaustive class subdivision = %s\n",
               (!fast_mode) ? "TRUE" : "FALSE");
      } else if (!strcmp(command, "long")) {
        long_results = !long_results;
        printf("   Long result printout = %s\n",
               long_results ? "TRUE" : "FALSE");
      } else if (!strcmp(command, "dump"))
        dump_data_structure();
      else if (!strcmp(command, "file"))
        printf("*****  \"file\" command no longer necessary *****\n");
      else if (!strcmp(command, "node")) {
        printf("  Enter node name: ");
        fgets(command, 81, stdin);
        TEMP = strchr(command, '\n');
        if (TEMP != NULL)
          *TEMP = 0;
        tmp_node = find_node(nequiv, command);
        if (tmp_node == NULL)
          printf("  Node: %s not found.\n", command);
        else {
          print_node(tmp_node);
          print_all_names(tmp_node);
          print_transistor_list(tmp_node->trans);
        }
      } else if (!strcmp(command, "comp") || !strcmp(command, "run")) {
        if (networks_loaded) {
          compare_networks(automorphisms);
          networks_loaded = 0;
        } else
          printf("No networks loaded.  Use \"read\".\n");
      } else {
        if (strcmp(command, "quit")) {
          if (strcmp(command, "help") && strcmp(command, "?"))
            printf("Illegal command: %s\n", command);
          printf("NETCMP command summary\n");
          printf("   auto -- toggle display of automorphisms \n");
          printf("   comp -- compare the networks \n");
          printf("   quit -- exit the program \n");
          printf("   help -- print this list \n");
          printf("   dbug -- toggle debug mode \n");
          printf("   slow -- ALWAYS consider classes for subdivision\n");
          /*  writeln ('   bad  -- toggle "propagate badness" mode ');  */
          printf("   long -- print extra long results\n");
          printf("   dump -- dump data structure \n");
          printf("   node -- print info about node \n");
          printf("   read -- read .ntk files \n");
        }
      }
    }
  } while (strcmp(command, "quit"));
}



/* End. */
