/* Header for module wolcomplib, generated by p2c */
#ifndef WOLCOMPLIB_H
#define WOLCOMPLIB_H


#ifdef WOLCOMPLIB_G
# define vextern
#else
# define vextern extern
#endif


/* 21 Aug 1986  (glenn) - use mylib, not graphics.  This means we can run on bobcats */



typedef struct cel {
  Char name[201];
  long lx, ly, cifnum;
  struct cel *next;
  struct subcel *contents;
} cel;

typedef struct subcel {
  cel *cell;
  long x, y, xfrm;
  struct subcel *next;
} subcel;

typedef enum {
  LYON, TELLE, WOL
} cif_types;

typedef struct stringlist {
  Char str[201];
  struct stringlist *next;
} stringlist;


vextern long x0, y0, x1, y1;   /* cell position, last cell position   */
vextern long lambda;   /* value of lambda in 1/100 of microns */
vextern cif_types cif_type;   /* type of CIF being parsed            */
vextern boolean search_library;
    /* should the library be searched for each subcell*/
vextern boolean print_cells;   /* if true, print cell list on line printer */
vextern Char prefix[201];   /* filename prefix to specify directories */


extern long inpos PP((long left, Char *pattern, Char *source));
extern Char *fix_name PP((Char *Result, Char *fname));
extern Void getfile PP((Char *name));
/* load a single cell out of a WOL/NEWOL file */
extern Void getcompfile PP((Char *name));
/* load and re-number a composition cell file */
extern Void draw PP((cel *c));
/*draws the named cell at x0,y0*/
extern Void ndraw PP((cel *c, int drawit));
/*optionally draws the named cell at x0,y0*/
extern Void drawx PP((cel *c, long tform));
/* draw the named cell, transformed   */
extern Void ndrawx PP((cel *c, long tform, int drawit));
/* optionally draw the named cell, transformed   */
extern Void plot PP((cel *cell));
extern cel *cell PP((Char *name));
/* lookup name "cell" in symbol table */
extern Void define PP((Char *name));
/* start a composition cell definition*/
extern Void endef PV();
/* end   "      "       "        "    */
extern Void endef_routing PP((Char *a));
/* endef, but includes a routing file 'a'*/
extern Void box PP((Char *c));
extern Void set_up PV();
extern Void shut_down PV();
extern Void dumplist PV();
extern Void set_mbb PP((long llx, long lly, long urx, long ury));
/* set the MBB for a composition*/
extern Void load_library PP((Char *name));
/* load a composition into the symbol table */
extern long lam PP((long x));

extern Void width PP((long x));
extern Void wire PP((Char *layer, long startx, long starty));
extern Void x PP((long delta));
extern Void y PP((long delta));
extern Void dx PP((long delta));
extern Void dy PP((long delta));
extern Void xy PP((long x, long y));
extern Void dxdy PP((long deltax, long deltay));
extern Void endwire PV();

extern Void write_cif PP((Char *a));
extern Void writeln_cif PP((Char *a));


#undef vextern

#endif /*WOLCOMPLIB_H*/

/* End. */
