
/* "WOLCOMP", a simple chip compiler,
   Copyright (C) 1983, 1990 California Institute of Technology.
   Authors: Massimo Sivilotti, Carver Mead
   Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/CU Boulder/Boulder CO/80309. 


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* From input file "wolcompii.text" */


#include <p2c/p2c.h>


#define WOLCOMPII_G
#include "wolcompii.h"


typedef struct push_element {
  long x, y;
  struct push_element *next;
} push_element;


Static boolean hcomposing, vcomposing;
Static push_element *list_head;
Static long global_xform, global_offset;


Void wolcomp_init(lamb)
long lamb;
{
  set_up();   /* initialize wolcomp */
  lambda = lamb;
  printf("Initialization complete.   Lambda = %0.2f um\n", lambda / 100.0);
  nocompose();
  transform((long)R0);
  overlap(0L);
  list_head = NULL;
  include_geometry = true;
}


Void define_cell(cell_name)
Char *cell_name;
{
  define(cell_name);
  nocompose();
  transform(0L);
  overlap(0L);
}


Void place(cell_name)
Char *cell_name;
{
  ndrawx(cell(cell_name), global_xform, include_geometry);
  if (hcomposing)
    x0 = x1 - global_offset;
  else if (vcomposing)
    y0 = y1 - global_offset;

  /**/
}


Void hcompose()
{
  hcomposing = true;
  vcomposing = false;
}


Void vcompose()
{
  vcomposing = true;
  hcomposing = false;
}


Void nocompose()
{
  vcomposing = false;
  hcomposing = false;
}


Void make_array(cell_name, count)
Char *cell_name;
long count;
{
  long i;

  if (!(hcomposing || vcomposing))
    printf("NEWOLCOMP:  \"make_array(%s)\" without previous \"h/vcompose\"\n",
	   cell_name);
  else {
    for (i = 1; i <= count; i++)
      place(cell_name);
  }
}


Void push(xi, yi)
long xi, yi;
{
  push_element *tmp;

  tmp = (push_element *)Malloc(sizeof(push_element));
  tmp->next = list_head;
  tmp->x = xi;
  tmp->y = yi;
  list_head = tmp;
}


Void pop(xi, yi)
long *xi, *yi;
{
  if (list_head == NULL) {
    printf("POP:  stack underflow\n");
    return;
  }
  *xi = list_head->x;
  *yi = list_head->y;
  list_head = list_head->next;
}


Void transform(xfrm)
long xfrm;
{
  global_xform = xfrm;
}


Void overlap(lambda)
long lambda;
{
  global_offset = lam(lambda);
}


long cell_width(cell_name)
Char *cell_name;
{
  return (cell(cell_name)->lx);
}


long cell_height(cell_name)
Char *cell_name;
{
  return (cell(cell_name)->ly);
}


Char *make_cell_name(Result, root, i)
Char *Result, *root;
long i;
{
  Char tmp[201];
  long junk;

  sprintf(tmp, "%s%ld", root, i);
  junk = strlen(tmp) + 1;
  tmp[junk - 1] = '\0';
/* p2c: wolcompii.text, line 169:
 * Note: Modification of string length may translate incorrectly [146] */
  return strcpy(Result, tmp);
}


Static Void pad_out_cells(cell1, cell2, cell3, to_width, horiz)
Char *cell1, *cell2, *cell3;
long to_width;
boolean horiz;
{
  /*
     takes one instance of cell1 and vertically adds as many instances
     of cell2 as are required to give a cell of to_width lambda height.
     the resulting cell is defined as cell3.
  */
  long h1, h2, h3;

  define_cell(cell3);
  if (horiz)
    hcompose();
  else
    vcompose();
  place(cell1);
  if (horiz) {
    h1 = cell_width(cell1);
    h2 = cell_width(cell2);
  } else {
    h1 = cell_height(cell1);
    h2 = cell_height(cell2);
  }
  h3 = to_width;   /*lam(to_width)*/
  if (h3 > h1) {
    while (h1 + h2 < h3) {
      place(cell2);
      h1 += h2;
    }
    if (horiz)
      x0 = h3 - h2;
    else
      y0 = h3 - h2;
    place(cell2);
  }
  endef();
}


Void vpad(cell1, cell2, cell3, to_width)
Char *cell1, *cell2, *cell3;
long to_width;
{
  pad_out_cells(cell1, cell2, cell3, to_width, false);
}


Void hpad(cell1, cell2, cell3, to_width)
Char *cell1, *cell2, *cell3;
long to_width;
{
  pad_out_cells(cell1, cell2, cell3, to_width, true);
}


Void include_file(fname)
Char *fname;
{
  Char a[201];
  FILE *infile;
  Char *TEMP;

  infile = NULL;
  if (infile != NULL)
    infile = freopen(fname, "r", infile);
  else
    infile = fopen(fname, "r");
  if (infile == NULL)
    _EscIO(FileNotFound);
  while (fgets(a, 201, infile) != NULL) {
    TEMP = strchr(a, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    writeln_cif(a);
  }
  if (infile != NULL)
    fclose(infile);
  infile = NULL;
  if (infile != NULL)
    fclose(infile);
}




/* End. */
