
/* "UNTIL", a graphics editor,
   Copyright (C) 1985, 1990 California Institute of Technology.
   Original authors: Glenn Gribble, port by Steve DeWeerth
   Unix Port Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425 CU Boulder/Boulder CO 91125. 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, 1989).

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
USA. */


/*******************************************************************************/
/*                                                                             */ 
/*  file contains stuff to deal with alpha screen and cursor                   */
/*  cleaned up by steve - 8 May 1990                                           */
/*                                                                             */ 
/*******************************************************************************/


#include <p2c/p2c.h>

#include "crt_stuff.h"

#ifndef NEWCRT_H
#include <p2c/newcrt.h>
#endif

#ifndef NEWKBD_H
#include <p2c/newkbd.h>
#endif

#ifndef SYSDEVS_H
#include <p2c/sysdevs.h>
#endif


#define my_cursor       (nc_white + 252)   /* A white '' */


Static short acursorx, acursory;   /* last position of alpha cursor */
Static short acursorold;           /* last anything at alpha cursor position */


void crt_center_str(Char *s, short y, short high)
{
  crt_write_str((nk_screenwidth - strlen(s)) / 2, y, s, 0, high);
}


void crt_write_int(short x, short y, long i, short field, short high)
{
  Char s[21];
  long dummy;

  sprintf(s, "%ld", i);
  dummy = strlen(s) + 1;
  crt_write_str(x, y, s, field, high);
}


/* If cursor position is over a plain space, then put a '' there as a cursor. */
void acursor(short x, short y)
{
  nc_gotoXY(x, y);   /* At least update the silly underline */
}


void acursoroff(void)
{
  nc_gotoXY(0, 100);
}


void crt_write_str(short x, short y, Char *ss, short field, short high)
{
  Char s[256];
  short l;

  strcpy(s, ss);
  l = abs(field) - strlen(s);

  if (l > 0) {
    if (field > 0)
      sprintf(s, "%*s%s", l, "", strcpy(s, s));
    else
      sprintf(s + strlen(s), "%*s", l, "");
  }

  nc_setHighlight(high);
  nc_putStr(x, y, s);
  nc_setHighlight(0);
}
