
#ifndef MENU_STUFF_H
#define MENU_STUFF_H

#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif

#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

#ifndef ASM_H
#include <p2c/asm.h>
#endif

#ifndef TABLET_STUFF_H
#include "tablet_stuff.h"
#endif

#ifndef GR_STUFF_H
#include "gr_stuff.h"
#endif

#ifndef MAT_STUFF_H
#include "mat_stuff.h"
#endif

#ifndef CRT_STUFF_H
#include "crt_stuff.h"
#endif

#ifndef BB_STUFF_H
#include "bb_stuff.h"
#endif

#ifndef DATA_TYPES_H
#include "data_types.h"
#endif

#ifndef FFMAN_H
#include "ffman.h"
#endif

#ifndef PRIM_STUFF_H
#include "prim_stuff.h"
#endif

#ifndef MENU_H
#include "menu.h"
#endif


#define vRecMax         15


typedef struct vRec {
  short num;
  short arr[vRecMax + 1];
} vRec;


/* Zoom and offset variables */
extern double default_zoom;   /* default zoom for empty cells */
extern double min_zoom, max_zoom;   /* Max, min for center command */
extern double zoom;   /* Never used in matrix stuff */
extern long zoom_num, zoom_den, off_x, off_y;
extern boolean wideArrows, showGrid, draftMode;

/* Show comments in output PS files?*/
extern Char pensPsSearch[5][fidleng + 1];
extern vRec gridRec, rotRec, widthRec;

extern Char fontName[21];

extern Char origName[10];
extern Char *origNames;

extern boolean leftSide;   /* Bogus */


extern void build_matrix(void);
extern void refresh(void);
extern void set_zoom(double newzoom);

extern void set_grid(short g);
extern void a_cleara(void);
extern void a_zoomin(void);
extern void a_zoomout(void);
extern void a_home(void);
extern void center_display(void);
extern void maybeMakeFile(Char *name);
extern void a_load(void);
extern void a_cursor0(void);
extern void a_cursor1(void);

extern void a_cursor2(void);

extern void do_exit(void);


#endif /*MENU_STUFF_H*/
