/* "boxify", is a simple filter for cleaning up quite general CIF
             and make it readable for "WOL"
   Copyright (C) 1990 Tor Sverre Lande
   Author's address: bassen@ifi.uio.no

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (any version).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */


#define CodeSize        500
#define ChunkSize       3000
#define maxsymbols      500
#define STRINGSIZE	256
#define LONG_MAX   ((long)(((unsigned long) -1) >> 1))
#define LONG_MIN   (~LONG_MAX)

typedef char PATHNAME[100];
typedef char DDIRNAME[20];
typedef char FileNameType[14];
typedef char EXTENSION[3];


typedef double Tarray[3][3];
typedef enum {
  Call, EndS, Box, Layer, Comment, User, Nop
} CodeType;

typedef struct CallEntry {
  struct TransDef *TList;
  long num;
} CallEntry;

typedef struct BoxRecord {
  long l, w, cx, cy, dx, dy;
  int scaled;
} BoxRecord;   /* BoxRecord */

typedef struct CodeDef {
  CodeType CType;
  union {
    CallEntry *CPtr;
    BoxRecord *B;
    char *Str;
  } UU;
} CodeDef;


typedef struct CodeChunk {
  CodeDef code[ChunkSize + 1];
} CodeChunk;   /* CodeChunk */

typedef struct SymRef {
  long symbol;
  struct SymRef *next;
} SymRef;

typedef struct SymbolDefs {
  long number;
  int written, blowup, sa, sb,calls;
  SymRef *depend;
  CodeChunk *code[CodeSize];
  long codep;
  long Xmin,Ymin,Xmax,Ymax;
} SymbolDefs;

typedef struct pointdef {
  long x, y;
  struct pointdef *next;
} pointdef;   /*** point ***/


typedef struct edgedef {
  long x, y, angle;
  struct edgedef *pred, *suc;
} edgedef;   /*** edgedef ***/

typedef enum {
    Trans,Rot,Mirror
 }Transform;

typedef struct TransDef {
    Transform type;
    long t1, t2;
    struct TransDef *next;
} TransDef;

typedef struct FilterDef {
    char *com;
    struct FilterDef *next;
} FilterDef;

SymbolDefs *CurrentSymbol,*GlobalSymbol;
int GlobalScaleA, GlobalScaleB;
int CifScaleA, CifScaleB;
int PreScaleA, PreScaleB;
#ifdef IN_TRAPES
extern int GlobalBlowUp;
extern int DropZeroArea;
#else
int DropZeroArea = false;
int GlobalBlowUp = false;
#endif







