/* "boxify", is a simple filter for cleaning up quite general CIF
             and make it readable for "WOL"
   Copyright (C) 1990 Tor Sverre Lande
   Author's address: bassen@ifi.uio.no

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (any version).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include <stdio.h>

#include <math.h>

#include "trapes.h"

delete_under(ah,alt)
struct edge_head *ah;
double alt;
{
	struct edge *e=ah->first, *f=ah->first;
	while (e!=NULL)
	{
		if ((e->yh<alt) || (fabs(e->yh-alt)<LAMBDA))
		{		/* remove edge */
#ifdef DDEBUG
fprintf(stderr,"removing: %d xl %f yl %f xh %f yh %f\n",e->id,e->xl,e->yl,e->xh,e->yh);
if (e->mate!=NULL) fprintf(stderr,"**** should mates be removed!\n");
#endif
			if (e==f)
			{	/* first element */
#ifdef DDEBUG
fprintf(stderr,"Removing first element\n");
#endif
				if (e->next == NULL)
				{/* only one element */
				    ah->first=NULL;
				    ah->last=NULL;
				    e=NULL;
				} else
				{
				    ah->first=e->next;
				    free(e);
				    e=ah->first; f=ah->first;
				}
			} else
			{	/* e!=f */
#ifdef DDEBUG
fprintf(stderr,"Removing in list\n");
#endif
				f->next=e->next;
				if (ah->last==e)
				{/* last element */
					ah->last=f;
				}
				free(e);
				e=f->next;
			}
		} else
		{		/* check next */
			f=e; e=e->next;
		}
	}
}
