/* "boxify", is a simple filter for cleaning up quite general CIF
             and make it readable for "WOL"
   Copyright (C) 1990 Tor Sverre Lande
   Author's address: bassen@ifi.uio.no

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (any version).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */


#define true 1
#define false 0
#include <stdio.h>

#include <math.h>

#include "trapes.h"

#include "poly.h"

#define IN_TRAPES
#include "../boxify.h"

gentrapes(l,r,a,resa,resb,Xoffset,Yoffset)
struct edge *l,*r;
double a;
int resa,resb;
long Xoffset, Yoffset;
{
	extern FILE *tfile;
	extern int trapescount;
	struct polygon p;
	int i,res;
	double clx,crx;
	double llx,lly,lrx,lry,urx,ury,ulx,uly,lowy;
	CodeDef cd;
	BoxRecord *br;

#ifdef MDEBUG
fprintf(stderr,"outputs trapesoid\n");
#endif
    if ((((fabs(l->xl-r->xl)<LAMBDA) && (fabs(l->xh-r->xh)<LAMBDA)) 
        || (fabs(r->yl-a)<LAMBDA) || (fabs(l->yl-a)<LAMBDA)) && DropZeroArea)
    {
/*        fprintf(stderr,"***trapes:No-aera trapezoide. dropped alt: %d\n",(int)a);
	fprintf(stderr,"id:%dl->xl: %d l->yl %d l->xh: %d l->yh: %d \n",l->id,(int)l->xl,(int)l->yl,(int)l->xh,(int)l->yh);
	fprintf(stderr,"id:%dr->xl: %d r->yl %d r->xh: %d r->yh: %d \n",r->id,(int)r->xl,(int)r->yl,(int)r->xh,(int)r->yh);*/
    } else
    {
	if (l->yl!=r->yl)
	fprintf(stderr,"***trapes:yl %d %dmust be equal i trapezoides!?!\n",(int)l->yl,(int)r->yl);
	if (l->yl>a)
	fprintf(stderr,"***trapes:yl > a\n");

	llx=l->xl; lly=l->yl; /* lower left */
	lrx=r->xl; lry=r->yl; /* lower right */
	urx=(fabs((double)(r->xh-r->xl))<LAMBDA)?r->xl:(((r->xh-r->xl)/(r->yh-r->yl))*(a-r->yl)+r->xl); 
	ury=a; /* upper right */
	ulx=(fabs((double)(l->xh-l->xl))<LAMBDA)?l->xl:(((l->xh-l->xl)/(l->yh-l->yl))*(a-l->yl)+l->xl); 
	uly=a; /* upper left */
	if (ulx > urx) {
	    /* exchange */
	    lowy = ulx; ulx = urx; urx = lowy;
	}
#ifdef MDEBUG
fprintf(stderr,"trapes: (%ld,%ld) (%ld,%ld) (%ld,%ld) (%ld(%lf),%ld)\n",llx,lly,lrx,lry,urx,ury,ulx,l->xh,uly);
fprintf(stderr,"Xoffset:%ld Yoffset:%ld\n",Xoffset,Yoffset);
#endif
	/* generate boxes from trapes here */
	if ((llx == ulx) && (lrx == urx)) {
	    /* box */
	    br = (BoxRecord *)malloc(sizeof(BoxRecord));
	    br->scaled = GlobalBlowUp;
	    br->l = lrx - llx + 0.5;
	    br->w = uly - lly + 0.5;
	    br->cx = llx + (lrx - llx)/2+Xoffset + 0.5;
	    br->cy = lly + (uly - lly)/2+Yoffset + 0.5;
	    cd.CType = Box;
	    cd.UU.B = br;
	    if ((br->l != 0) && (br->w != 0))
		putcode(cd);
	} else {
	    /* some dammed trapzoide */
	    /* This version does it simple:
	       Just generate a lot of boxex with a given resolution */
	    /* The resolution should at least be twice the unit of measure1 */
	    res = resa/resb;
	    if (res < 4) {
/*		fprintf(stderr,"Resolution must at least be greater then 1! Doubling\n");*/
		res = 4;
	    }
	    for (lowy = lly;lowy < uly;lowy += res) {
		/* find interpolated x-values */
		/* y-values are easy... */
		clx = ((lowy+((lowy+res < uly)?res/2:(uly - lowy)/2)-lly)
			     *(ulx-llx))/(double)(uly-lly) + llx;
		crx = ((lowy+((lowy+res < uly)?res/2:(uly - lowy)/2)-lry)
			     *(urx-lrx))/(double)(ury-lry) + lrx;
		if ((fabs(crx-clx)>LAMBDA) && (fabs((double)(uly - lowy))>LAMBDA)) {
		    br = (BoxRecord *)malloc(sizeof(BoxRecord));
		    br->scaled = true;
		    br->l = (crx - clx)+0.5;
		    br->w = (lowy + res < uly)?res:uly - lowy + 0.5;
		    br->cx = ((clx + (crx -clx)/2+Xoffset))+0.5;
		    br->cy = (((lowy+res < uly)?lowy + res/2:lowy + (uly - lowy)/2)+Yoffset) + 0.5;
		    cd.CType = Box;
		    cd.UU.B = br;
		    if ((br->l != 0) && (br->w != 0))
		    putcode(cd);
		}
	    }
	}
		
    }
    }

