/* "boxify", is a simple filter for cleaning up quite general CIF
             and make it readable for "WOL"
   Copyright (C) 1990 Tor Sverre Lande
   Author's address: bassen@ifi.uio.no

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (any version).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */


#include <stdio.h>

#include <math.h>

#include "trapes.h"

#include "poly.h"

mates(ah,cy,alt,resa,resb,Xoffset,Yoffset)
struct edge_head *ah;		/* pointer to active-list */
double cy,alt;			/* current altitude */
int resa,resb;
long Xoffset,Yoffset;
{
	struct edge *l=ah->first, *r, *u, *v;
	struct windid w[MAXMATES];
	int pcnt,incnt,i,term;
	double del=0.0,sq,xx;
	
#ifdef MDEBUG
fprintf(stderr,"start mating\n");
displayedges(ah);
#endif
	while (l != NULL)
	{			/* find a mate for l */
		pcnt=0;
		w[pcnt].wind=l->wind; w[pcnt].id=l->id;
		incnt=1; r=l;
		while (incnt > 0)
		{		/* seek for mate */
		    do		/* while same x */
		    {
			if (r!=l) /* not first time */
			{ /* r pints to edges in between and not mate */
				if (r->mate!=NULL)
				{ /* generate trapesoide and change xl */
#ifdef MDEBUG
fprintf(stderr,"Generating trapes in between\n");
fprintf(stderr,"l:%d,xl:%f,yl:%f,xh:%f,yh:%f\n",l->id,l->xl,l->yl,l->xh,l->yh);
v=l->next;
while (v!=r)
{
fprintf(stderr,"v:%d,xl:%f,yl:%f,xh:%f,yh:%f\n",v->id,v->xl,v->yl,v->xh,v->yh);
v=v->next;
}
fprintf(stderr,"r:%d,xl:%f,yl:%f,xh:%f,yh:%f\n",r->id,r->xl,r->yl,r->xh,r->yh);
fprintf(stderr,"r->mate:%d,xl:%f,yl:%f,xh:%f,yh:%f\n",r->mate->id,r->mate->xl,r->mate->yl,r->mate->xh,r->mate->yh);
#endif

					if (r->xl<=r->mate->xl) v=r; else v=r->mate;
					gentrapes(v,v->mate,cy,resa,resb,Xoffset,Yoffset);
					r->mate->mate=NULL;
					r->mate=NULL;
				}
			}
			r=r->next;
			for (i=0; i <= pcnt; i++)
			{
				if (w[i].id == r->id) break;
			}
			if (i>pcnt) /* new polygon */
			{
				if (pcnt>=MAXMATES)
				fprintf(stderr,"****mate:w-array blown! STOP!\n");
				w[++pcnt].id=r->id;
				w[pcnt].wind=r->wind;
			} else
			{	/* update winding-nuumber */
				w[i].wind+=r->wind;
			}
			if (r->next !=NULL)
			{
			/* compute del as distance from r->next (cy and alt)
			   to r */
			    if ((fabs(r->xh - r->xl)< LAMBDA) &&
			        (fabs(r->next->xh - r->next->xl) <LAMBDA)) 
				/* y-parallell lines */
				del=fabs(r->xl - r->next->xl);
			    else {
				sq=sqrt((r->yh-r->yl)*(r->yh-r->yl)+(r->xh-r->xl)*(r->xh-r->xl));
			        xx=((r->next->xh-r->next->xl)*(alt-r->next->yl))/
			           (r->next->yh-r->next->yl)+r->next->xl;
			    del=(fabs(((r->yh-r->yl)*r->next->xl-
			          (r->xh-r->xl)*r->next->yl+
				  r->yl*(r->xh-r->xl)-r->xl*(r->yh-r->yl))
				 /sq)+
			     fabs(((r->yh-r->yl)*xx-
			          (r->xh-r->xl)*alt+
				  r->yl*(r->xh-r->xl)-r->xl*(r->yh-r->yl))
				 /sq))/2;
			    }
			} else del=1;
#ifdef MDEBUG
for (i=0;i<=pcnt;i++)
fprintf(stderr,"w: %d id: %d wind: %d incnt:%d del:%f\n",i,w[i].id,w[i].wind,incnt,del);
#endif
		    }
		    while ((r->next!=NULL) &&
		           (del<LAMBDA))/* x.cross-x.next.cross<LAMBDA */;

		    incnt=0;
		    for (i=0;i<=pcnt;i++)
			    if (w[i].wind!=0) incnt++;
		}
		/* r points to newly found mate */
		/* check against old mates */
#ifdef MDEBUG
fprintf(stderr,"found mate: id1 %d yl1 %f yh1 %f id2 %d yl2 %f yh2 %f\n",l->id,l->yl,l->yh,r->id,r->yl,r->yh);
fprintf(stderr,"x-val: id1: %d xl1 %f xh1 %f id2: %d xl2 %f xh2 %f\n",l->id,l->xl,l->xh,r->id,r->xl,r->xh);
#endif
		if (l->mate != r)
		{ 		/* change mate */
			if (l->mate != NULL) 
			{
#ifdef MDEBUG
fprintf(stderr,"Trapes between l and l.mate %d %d\n",l->id,l->mate->id);
#endif
				gentrapes(l,l->mate,cy,resa,resb,Xoffset,Yoffset);
				l->mate->mate=NULL;
			};
			if (r->mate != NULL) 
			{
#ifdef MDEBUG
fprintf(stderr,"trapes between r and r.mate %d %d\n",r->id,r->mate->id);
#endif
				gentrapes(r->mate,r,cy,resa,resb,Xoffset,Yoffset);
				r->mate->mate=NULL;
			}
			l->xl=(fabs(l->xh-l->xl)<LAMBDA)?l->xl:(((l->xh-l->xl)/(l->yh-l->yl))*(cy-l->yl)+l->xl);
			l->yl=cy;
			r->xl=(fabs(r->xh-r->xl)<LAMBDA)?r->xl:(((r->xh-r->xl)/(r->yh-r->yl))*(cy-r->yl)+r->xl);
			r->yl=cy;
			l->mate=r; r->mate=l;
		}
		l=r->next;
	}
	/* check for edges terminating on alt */
	l=ah->first;
	while (l!=NULL)
	{  
	    if ((l->mate!=NULL) && ((l->yh<alt) || (fabs(l->yh-alt)<LAMBDA)))
	    {
#ifdef MDEBUG
fprintf(stderr,"generating trapes in termination check %d %d\n",l->id,l->mate->id);
#endif
			u = (l->xl>l->mate->xl) ? l=l->mate : l;
			gentrapes(u,u->mate,alt,resa,resb,Xoffset,Yoffset);
			/* update coordinates */
			l->xl=(fabs(l->xh-l->xl)<LAMBDA)
			?l->xl
			:(((l->xh-l->xl)/(l->yh-l->yl))*(alt-l->yl)+l->xl);
			l->yl=alt;
			l->mate->xl=(fabs(l->mate->xh-l->mate->xl)<LAMBDA)
			?l->mate->xl
			:(((l->mate->xh-l->mate->xl)/(l->mate->yh-l->mate->yl))*(alt-l->mate->yl)+l->mate->xl);
			l->mate->yl=alt;
			l->mate->mate=NULL;
			l->mate=NULL;
	    } else
	    if (l->mate==NULL)
	    {
		if (fabs(l->yh-l->yl)<LAMBDA)
			l->xl=l->xh;
		else
		l->xl=(fabs(l->xh-l->xl)<LAMBDA)
		?l->xl
		:((l->xh-l->xl)*(alt-l->yl))/(l->yh-l->yl)+l->xl;
		l->yl=alt;
	    };
	    l=l->next;
	}
#ifdef MDEBUG
fprintf(stderr,"End mating\n");
#endif
}
