/* "boxify", is a simple filter for cleaning up quite general CIF
             and make it readable for "WOL"
   Copyright (C) 1990 Tor Sverre Lande
   Author's address: bassen@ifi.uio.no

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (any version).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#define		LAMBDA		0.25
#define		MAXMATES	10000
#define		TRUE		1
#define		FALSE		0

/********************************************************************\
* 								     *
*  Since edge-list is single-linked we need first and last element   *
* 								     *
\********************************************************************/

struct edge_head
{
	struct edge *first,*last;
};

/****************************************************\
* 						     *
* an edge is a polygon-side where xl<=xh and yl<yh.  *
* additonal data for mating etc.		     *
* 						     *
\****************************************************/
struct edge
{
	double xl,yl,xh,yh,xx;
	long id; 		/* identifies polygon uniqly */
	int wind;		/* winding nmber for this side */
	struct edge *next, *mate;
};

struct windid
{
	long id;
	int wind;
};

