/*
 * spice.c
 *
 */


#include <stdio.h>


void	GetSpiceWord ();
int	GetLastSpiceWord ();


/* Subroutine GetSpiceWord ()  --  SPICE '+' line-continuation handler
   ^^^^^^^^^^^^^^^^^^^^^^^^^^
   Typical preparation for use would be:

	fgets (STR1, 256, filePtr);
	strcpy (STR2, STR1);
	line = STR1;
	word = STR2;
*/

void GetSpiceWord (line, word, filePtr)
  char	*line;   /* must point to a pre-allocated block of 256 chars */
  char	*word;   /* must point to a pre-allocated block of 256 chars */
  FILE	*filePtr;
{
  char	*p = line;
  char	c;

/* skip leading space
*/
  while (isspace (*p)) p ++;

/* copy the first word from "p" to "word"
*/
  while (*p && !isspace (*p))
  {
    *word = *p;
    word ++;
    p ++;
  }
  *word = 0;

/* check for line continuation
*/
  if ((*p == 0) || (*p == 10))
  {
    c = fgetc (filePtr);
    if (c == '+')
      (void) fgets (p, 256, filePtr);
    else
    {
      ungetc (c, filePtr);
      *p = 0;
    }
  }

/* advance "p" to the next word(s)
*/
  while (isspace (*p)) p ++;

/* shift "p" to "line" beginning
*/
  while (*p)
  {
    *line = *p;
    line ++;
    p ++;
  }
  *line = 0;
}


/* Subroutine GetLastSpiceWord ()
   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
   Finds the last word in "line", stores a copy in "word", and returns
   the number of words found.
*/
int GetLastSpiceWord (line, word, filePtr)
  char	*line;
  char  word[256];
  FILE	*filePtr;
{
  long	currentFilePosition;
  char	STR1[256], STR2[256];
  char	*l, *w;
  int	nWords = 0;

  currentFilePosition = ftell (filePtr);

  strcpy (STR1, line);
  strcpy (STR2, line);
  l = STR1;
  w = STR2;

  do
  {
    GetSpiceWord (l, w, filePtr);
    if (*w)
    {
      strcpy (word, w);
      nWords ++;
    }
  } while (*w);

  (void) fseek (filePtr, currentFilePosition, 0);

  return (nWords);
}



