/*
   ss.c  --  Convert flattened LOGSPC output into UCB SIM format.

Written by Harold Levy (har@caltech.edu)

Version		Date	Description
^^^^^^^		^^^^	^^^^^^^^^^^
0.1 beta       11/06/93	First version handles MOSFET's only.
0.2 beta       07/01/94 Fixed GetSpiceWord()'s line-continuation routine
                        so that it works with piped input from stdin, and
                        added version-number print-out.

*/
#define VERSION "0.2"

#include <stdio.h>

#include "spice.h"

main (argc, argv)
  int   argc;
  char  *argv[];
{
  FILE          *inputfile;
  char          STR1[256], STR2[256];
  char          *line, *word;

  char		drain[256], gate[256], source[256], bulk[256];
  char		model[256], length[256], width[256];
  double	dl, dw;
  int		il, iw;

  char		buf[BUFSIZ] ;

/* open input file
*/
  if (argc == 2)
  {
    strcpy (STR1, argv[1]);
    if (!strcmp (STR1, "-"))
      inputfile = stdin;
    else
      inputfile = fopen (STR1, "r");
    if (!inputfile)
    {
      fprintf (stderr, "Cannot find \"%s\"\n", STR1);
      exit (2);
    }
  }
  else
  {
    fprintf (stderr, "usage (v%s):  ss <flat spc file>\n", VERSION);
    fprintf (stderr, "              ss -\n");
    exit (1);
  }

/* print units & technology
*/
  printf ("| units: 1    tech: scmos    format: UCB\n");

/* read root cell
*/
  while (fgets (STR1, 256, inputfile))
  {
    strcpy (STR2, STR1);
    line = STR1;
    word = STR2;

    GetSpiceWord (line, word, inputfile);

    if (*word == '*') continue;         /* comment */
    if (*word == 0) continue;           /* blank line */
    if (!strncmp (word, ".SUBCKT", 7))  /* skip subcircuit definitions now */
    {
      while (strncmp (fgets (STR1, 256, inputfile), ".ENDS", 5)) ;
      continue;
    }

    switch (*word)
    {
      case 'M':
        GetSpiceWord (line, word, inputfile); strcpy (drain, word);
        GetSpiceWord (line, word, inputfile); strcpy (gate, word);
        GetSpiceWord (line, word, inputfile); strcpy (source, word);
        GetSpiceWord (line, word, inputfile); strcpy (bulk, word);
        GetSpiceWord (line, word, inputfile); strcpy (model, word);
        GetSpiceWord (line, word, inputfile); strcpy (length, word);
        sscanf (length, "L=%lfUM", &dl);
        il = (int) (100.0 * dl);
        GetSpiceWord (line, word, inputfile); strcpy (width, word);
        sscanf (width, "W=%lfUM", &dw);
        iw = (int) (100.0 * dw);
        switch (*model)
        {
          case 'N':
            printf ("n  ");
            break;
          case 'P':
            printf ("p  ");
            break;
        }
        printf ("%s %s %s %d %d 0 0\n", gate, source, drain, il, iw);
        break;
    }
  }

/* close input file
*/
  fclose (inputfile);

}


