/* Dad.java
 *
 * created: Mon Jul 12 1999
 *
 * This file is part of Artemis
 *
 * Copyright (C) 1999  Genome Research Limited
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *  "Axiom:        Any non-trivial program contains some bugs
 *   Corollary:    If a program has no bugs, it is useless"
 *
 * $Header: /nfs/disk222/yeastpub/Repository/agctimpl/Dad.java,v 1.12 2000/09/18 12:36:41 kmr Exp $
 */

import diana.*;
import diana.components.*;
import diana.sequence.*;

import uk.ac.sanger.pathogens.*;

import uk.ac.sanger.pathogens.embl.QualifierInfoVector;
import uk.ac.sanger.pathogens.embl.QualifierInfoException;
import uk.ac.sanger.pathogens.embl.EntryInformation;
import uk.ac.sanger.pathogens.embl.EntryInformationException;
import uk.ac.sanger.pathogens.embl.ReadFormatException;
import uk.ac.sanger.pathogens.embl.InvalidRelationException;
import uk.ac.sanger.pathogens.embl.DocumentEntryFactory;

import java.awt.*;
import java.awt.event.*;
import java.io.*;

/**
 *  This class contains the main () method for "Dual Artemis Display" AKA
 *  "Artemis Comparison Tool".
 *
 *  @author Kim Rutherford
 *  @version $Id: Dad.java,v 1.12 2000/09/18 12:36:41 kmr Exp $
 **/

public class Dad {
  /**
   *  Version String use for banner messages and title bars.
   **/
  public static final String version = "Release 1";

  /**
   *  Main entry point for ACT
   **/
  public static void main (final String [] args) {
    final ActMain main_window = new ActMain ();

    main_window.setVisible (true);

    if (args.length == 3) {
      try {
        ActMain.makeComparator (main_window,
                                main_window.getInputStreamProgressListener (),
                                args[0], args[1], args[2]);
      } catch (IOException e) {
        final String message = "error while reading: " + e.getMessage ();
        new MessageFrame (message);
      } catch (OutOfRangeException e) {
        new MessageFrame ("read failed with an \"out of range\" error: " +
                          e.getMessage ());
      } catch (EntryInformationException e) {
        new MessageFrame ("read failed: " + e.getMessage ());
      }
    } else {
      if (args.length != 0) {
        System.err.println ("Error - this program needs zero or three " +
                            "arguments:");
        System.err.println ("   act sequence_1 sequence_2 comparison_data");
        System.err.println ("or");
        System.err.println ("   act");
        System.exit (1);
      }
    }
  }
}

