/* MSPcrunchComparisonData.java
 *
 * created: Tue Apr  4 2000
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 2000  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/MSPcrunchComparisonData.java,v 1.5 2000/06/05 12:43:19 kmr Exp $
 */

package diana;

import java.io.*;
import java.util.StringTokenizer;
import java.util.Vector;

import uk.ac.sanger.pathogens.embl.LinePushBackReader;

/**
 *  This class implements the ComparisonData interface for MSPcrunch -d
 *  output.
 *
 *  @author Kim Rutherford <kmr@sanger.ac.uk>
 *  @version $Id: MSPcrunchComparisonData.java,v 1.5 2000/06/05 12:43:19 kmr Exp $
 **/

public class MSPcrunchComparisonData extends SimpleComparisonData
    implements ComparisonData {
  /**
   *  Create a new MSPcrunchComparisonData object by reading from the given
   *  LinePushBackReader.
   **/
  public MSPcrunchComparisonData (final LinePushBackReader stream)
      throws IOException {

    final Vector align_match_vector = new Vector ();

    while (true) {
      final String line = stream.readLine ();

      if (line == null) {
        break;
      }

      final StringTokenizer tokenizer = new StringTokenizer (line, " ");

      if (tokenizer.countTokens () < 8) {
        final String message = "while reading MSPcrunch data: " +
          "not enough columns in this line: " + line;
        throw new ComparisonDataParseException (message);
      }

      final String score_token = tokenizer.nextToken ();
      final String percent_ident_token = tokenizer.nextToken ();
      final String q_start_token = tokenizer.nextToken ();
      final String q_end_token = tokenizer.nextToken ();

      tokenizer.nextToken ();

      final String s_start_token = tokenizer.nextToken ();
      final String s_end_token = tokenizer.nextToken ();

      try {
        final int score   = Integer.valueOf (score_token).intValue ();
        final int percent_ident =
          (int)(Float.valueOf (percent_ident_token).floatValue ());
        final int q_start = Integer.valueOf (q_start_token).intValue ();
        final int q_end   = Integer.valueOf (q_end_token).intValue ();
        final int s_start = Integer.valueOf (s_start_token).intValue ();
        final int s_end   = Integer.valueOf (s_end_token).intValue ();

        final AlignMatch new_match =
          makeAlignMatch (s_start, s_end, q_start, q_end, percent_ident);

        align_match_vector.addElement (new_match);
      } catch (NumberFormatException e) {
        throw new IOException ("while reading MSPcrunch data: " +
                               "failed to parse a number from this string: " +
                               e.getMessage ());
      }
    }

    final AlignMatch [] matches = new AlignMatch [align_match_vector.size ()];

    for (int i = 0 ; i < matches.length ; ++i) {
      matches[i] = (AlignMatch) align_match_vector.elementAt (i);
    }

    setMatches (matches);
  }
}
