/* ExternalProgramOptions.java
 *
 * created: Mon Oct  4 1999
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 1999  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/components/ExternalProgramOptions.java,v 1.1 1999/10/05 15:41:06 kmr Exp $
 */

package diana.components;

import diana.*;

import java.awt.*;

/**
 *  This component allows the user to set the options of an ExternalProgram.
 *
 *  @author Kim Rutherford
 *  @version $Id: ExternalProgramOptions.java,v 1.1 1999/10/05 15:41:06 kmr Exp $
 **/

public class ExternalProgramOptions {
  /**
   *  Create a new ExternalProgramOptions object for the given
   *  ExternalProgram.
   **/
  public ExternalProgramOptions (final ExternalProgram external_program) {
    if (external_program instanceof ExternalSearchProgram) {
      final ExternalSearchProgram external_search_program =
        (ExternalSearchProgram) external_program;

      final TextRequester requester =
        new TextRequester ("Options for " + external_program.getName () + ":",
                           18, external_search_program.getSearchOptions ());

      requester.addTextRequesterListener (new TextRequesterListener () {
        public void actionPerformed (final TextRequesterEvent event) {
          final String requester_text = event.getRequesterText ().trim ();
          if (requester_text.length () > 0) {
            external_search_program.setSearchOptions (requester_text);
          }
        }
      });

      requester.show ();
    } else {
      throw new Error ("internal error - please hit the programmer");
    }
  }
}
