/* MarkerRangeRequesterListener.java
 *
 * created: Mon Jul 10 2000
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 2000  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/components/MarkerRangeRequesterListener.java,v 1.1 2000/07/11 15:54:01 kmr Exp $
 */

package diana.components;

/**
 *  This interface is implemented by those classes that need to listen for
 *  MarkerRangeRequesterEvents.
 *
 *  @author Kim Rutherford <kmr@sanger.ac.uk>
 *  @version $Id: MarkerRangeRequesterListener.java,v 1.1 2000/07/11 15:54:01 kmr Exp $
 **/

public interface MarkerRangeRequesterListener {
  /** 
   *  Invoked when the user presses the OK or Cancel button on a
   *  MarkerRangeRequester component.
   **/
  public void actionPerformed (final MarkerRangeRequesterEvent event);
}
