/* ScoreChanger.java
 *
 * created: Thu Oct 21 1999
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 1999  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/components/ScoreChanger.java,v 1.1 1999/10/22 14:17:13 kmr Exp $
 */

package diana.components;

import java.awt.*;
import java.awt.event.*;

/**
 *  This is a Frame component that contains ScoreScrollbar components.
 *
 *  @author Kim Rutherford
 *  @version $Id: ScoreChanger.java,v 1.1 1999/10/22 14:17:13 kmr Exp $
 **/

public class ScoreChanger extends Frame {
  /**
   *  Create a new ScoreChanger.
   **/
  public ScoreChanger (final String name,
                       final ScoreChangeListener minimum_listener,
                       final ScoreChangeListener maximum_listener)
      throws IllegalArgumentException {

    super (name);

    this.minimum_listener = minimum_listener;
    this.maximum_listener = maximum_listener;

    setLayout (new GridLayout (5, 1));

     minimum_label = new Label ();

    add (minimum_label);

    minimum_score_scrollbar = new ScoreScrollbar ();

    final ScoreChangeListener this_minimum_listener =
      new ScoreChangeListener () {
        public void scoreChanged (ScoreChangeEvent event) {
          minimum_label.setText ("Minimum Cutoff: " + event.getValue ());
        }
      };

    minimum_score_scrollbar.addScoreChangeListener (this_minimum_listener);

    add (minimum_score_scrollbar);

    maximum_label = new Label ();

    add (maximum_label);

    maximum_score_scrollbar = new ScoreScrollbar ();

    final ScoreChangeListener this_maximum_listener =
      new ScoreChangeListener () {
        public void scoreChanged (ScoreChangeEvent event) {
          maximum_label.setText ("Maximum Cutoff: " + event.getValue ());
        }
      };

    maximum_score_scrollbar.addScoreChangeListener (this_maximum_listener);

    add (maximum_score_scrollbar);

    final FlowLayout flow_layout =
      new FlowLayout (FlowLayout.CENTER, 18, 0);

    final Panel button_panel = new Panel (flow_layout);

    final Button reset_button = new Button ("Reset");

    reset_button.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        reset ();
      }
    });

    button_panel.add (reset_button);


    final Button close_button = new Button ("Close");

    close_button.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        dispose ();
      }
    });


    button_panel.add (close_button);

    add (button_panel);

    addWindowListener (new WindowAdapter () {
      public void windowClosing (WindowEvent event) {
        dispose ();
      }
    });

    pack ();

    setSize (270, getSize ().height);

    final Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    setLocation (new Point ((screen.width - getSize ().width) / 2,
                            (screen.height - getSize ().height) / 2));

    reset ();
    
    minimum_score_scrollbar.addScoreChangeListener (minimum_listener);
    maximum_score_scrollbar.addScoreChangeListener (maximum_listener);
  }

  /**
   *  Call reset (), clean up the listeners then call super.dispose ().
   **/
  public void dispose () {
    reset ();

    minimum_score_scrollbar.removeScoreChangeListener (minimum_listener);
    maximum_score_scrollbar.removeScoreChangeListener (maximum_listener);

    super.dispose ();
  }

  /**
   *  Reset the minimum_score_scrollbar to 0 and the maximum_score_scrollbar
   *  to 100.
   **/
  private void reset () {
    minimum_score_scrollbar.setValue (0);
    maximum_score_scrollbar.setValue (100);

    minimum_label.setText ("Minimum Cutoff: " + 0);
    maximum_label.setText ("Maximum Cutoff: " + 100);

    final ScoreChangeEvent minimum_event =
      new ScoreChangeEvent (this, 0);

    minimum_listener.scoreChanged (minimum_event);

    final ScoreChangeEvent maximum_event =
      new ScoreChangeEvent (this, 100);

    maximum_listener.scoreChanged (maximum_event);
  }

  /**
   *  The ScoreChangeListener for the minimum score that was passed to the
   *  constructor.
   **/
  final ScoreChangeListener minimum_listener;

  /**
   *  The minimum score scrollbar the created by the constructor.
   **/
  final ScoreScrollbar minimum_score_scrollbar;

  /**
   *  The ScoreChangeListener for the maximum score that was passed to the
   *  constructor.
   **/
  final ScoreChangeListener maximum_listener;

  /**
   *  The maximum score scrollbar the created by the constructor.
   **/
  final ScoreScrollbar maximum_score_scrollbar;

  /**
   *  A Label that shows something like this: "Minimum Cutoff: 0"
   **/
  final Label minimum_label;

  /**
   *  A Label that shows something like this: "Maximum Cutoff: 100"
   **/
  final Label maximum_label;
}

