
/* "MT", a GPIB interface to view program,
   Copyright (C) 1987, 1990 California Institute of Technology.
   Original author: John Lazzaro
   Unix Port Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125.


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, Feb 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */



#include <p2c/p2c.h>

#include "mt.h"
#define FCMT_G
#include "fcmt.h"

#define HP5316B_CH       "20"



typedef struct state_of_FC {
  boolean exists;           /*is one connected to HPIB?*/
  v_paramrec *output;       /*frequency output from FC*/
  v_paramrec *func;         /*function from FC*/
} state_of_FC;


Static state_of_FC FC;


/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/
/*                   HP5316B Frequency Counter MT Library                    */
/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/



/*****************************************************************************/
/*        'this variable has been changed - here's the string '              */

Static Void MT_FC_chproc(pp, val)

  v_paramrec *pp;
  Char *val;

{
/****************************************************************************/

  Char STR1[256];

  if (!FC.exists)
    return;

  if (pp == FC.output) {
    v_failmsg("Writing attempted to a read-only parameter");
    return;
  }

  if (pp != FC.func) {
    v_failmsg("MT system error");
    return;
  }

  strupper(val, val);
  if (!strcmp(val, "0") || !strcmp(val, "DISP_TEST")) {
    pp->val.U1.i1 = 0;
    sprintf(STR1, "output %s;FN0\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "1") || !strcmp(val, "FREQ_A")) {
    pp->val.U1.i1 = 1;
    sprintf(STR1, "output %s;FN1\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "2") || !strcmp(val, "TI_A_B")) {
    pp->val.U1.i1 = 2;
    sprintf(STR1, "output %s;FN2\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "3") || !strcmp(val, "TI_DELAY")) {
    pp->val.U1.i1 = 3;
    sprintf(STR1, "output %s;FN3\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "4") || !strcmp(val, "RATIO_A_B")) {
    pp->val.U1.i1 = 4;
    sprintf(STR1, "output %s;FN4\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "5") || !strcmp(val, "FREQ_C")) {
    pp->val.U1.i1 = 5;
    sprintf(STR1, "output %s;FN5\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "6") || !strcmp(val, "TOTALIZE_STOP")) {
    pp->val.U1.i1 = 6;
    sprintf(STR1, "output %s;FN6\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "7") || !strcmp(val, "PERIOD_A")) {
    pp->val.U1.i1 = 7;
    sprintf(STR1, "output %s;FN7\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "8") || !strcmp(val, "TI_AV_A_B")) {
    pp->val.U1.i1 = 8;
    sprintf(STR1, "output %s;FN8\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "9") || !strcmp(val, "CHECK_10MHZ")) {
    pp->val.U1.i1 = 9;
    sprintf(STR1, "output %s;FN9\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "10") || !strcmp(val, "A_GATE_B")) {
    pp->val.U1.i1 = 10;
    sprintf(STR1, "output %s;FN10\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "11") || !strcmp(val, "GATE_TIME")) {
    pp->val.U1.i1 = 11;
    sprintf(STR1, "output %s;FN11\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "12") || !strcmp(val, "TOTALIZE_STOP")) {
    pp->val.U1.i1 = 12;
    sprintf(STR1, "output %s;FN12\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "13") || !strcmp(val, "FREQ_A_ARMED_B")) {
    pp->val.U1.i1 = 13;
    sprintf(STR1, "output %s;FN13\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "14") || !strcmp(val, "FREQ_A_ARMED_MB")) {
    pp->val.U1.i1 = 14;
    sprintf(STR1, "output %s;FN14\n", HP5316B_CH );
    ieeewt(STR1);
    return;
  }
  if (!strcmp(val, "16") || !strcmp(val, "HPIB_TEST")) {
    pp->val.U1.i1 = 16;
    sprintf(STR1, "output %s;FN16\n", HP5316B_CH );
    ieeewt(STR1);
  } else {
    sprintf(STR1, "Do not understand %s", val);
    v_failmsg(STR1);
  }
}


/*****************************************************************************/
/*       'give me the value of this variable in string form'                 */

Static Void MT_FC_fmtproc(pp, val)
v_paramrec *pp;
Char *val;
{

/*****************************************************************************/
  float outreal;
  Char STR1[256];

  if (!FC.exists)
    return;
  if (pp == FC.output) {

    sprintf(STR1, "output %s;RE\n", HP5316B_CH ); /* reset FC */
    ieeewt(STR1);

    sprintf(STR1, "enter %s\n", HP5316B_CH); /* read counter */
    ieeewt(STR1);
    ieeescnf("%*c%e", &outreal);
    FC.output->val.r = outreal;
    sprintf(val, "%g", pp->val.r);
    return;
  }
  if (pp != FC.func) {
    v_failmsg("MT system error");
    return;
  }
  switch (pp->val.U1.i1) {

  case 0:
    strcpy(val, "Disp_Test");
    break;

  case 1:
    strcpy(val, "Freq_A");
    break;

  case 2:
    strcpy(val, "Time_A_B");
    break;

  case 3:
    strcpy(val, "Time_Delay");
    break;

  case 4:
    strcpy(val, "Ratio_A_B");
    break;

  case 5:
    strcpy(val, "Freq_C");
    break;

  case 6:
    strcpy(val, "Totalize_Stop");
    break;

  case 7:
    strcpy(val, "Period_A");
    break;

  case 8:
    strcpy(val, "Time_Av_A_B");
    break;

  case 9:
    strcpy(val, "Check_10Mhz");
    break;

  case 10:
    strcpy(val, "A_Gate_B");
    break;

  case 11:
    strcpy(val, "Gate_Time");
    break;

  case 12:
    strcpy(val, "Totalize_Stop");
    break;

  case 13:
    strcpy(val, "Freq_A_Armed_B");
    break;

  case 14:
    strcpy(val, "Freq_A_Armed_mB");
    break;

  case 15:
    strcpy(val, "Not used");
    break;

  case 16:
    strcpy(val, "HPIB_Test");
    break;

  default:
    v_failmsg("MT system error");
    break;
  }
}


/****************************************************************************/
/*    'this variable has been changed - here's the number '                */

Static Void MT_FC_nchproc(pp, val)
v_paramrec *pp;
double *val;
{

/***************************************************************************/
}


/****************************************************************************/
/*       'give me the value of this variable in number form'               */

Static Void MT_FC_nfmtproc(pp, val)
v_paramrec *pp;
double *val;
{
/***************************************************************************/
}


Local Void MT_FC_init()
{

/****************************************************************************/

  Char STR1[256];

  TRY(try1);
    FC.exists = false;
    sprintf(STR1, "output %s;IN\n", HP5316B_CH ); /* initalize FC */
    ieeewt(STR1);

    sprintf(STR1, "output %s;RE\n", HP5316B_CH ); /* reset FC */
    ieeewt(STR1);

    FC.exists = true;
    FC.output->val.r = 0.0;   /*counter output*/
    FC.func->val.U1.i1 = 1;   /*freq A*/
  RECOVER(try1);
    printf("frequency counter not found - continuing initialization\n");
  ENDTRY(try1);
}



/****************************************************************************/
/* updates state of FC                                                      */

Local Void MT_FC_update()
{
}

/*****************************************************************************/
/*                   resets FC state to sane values                          */

Local Void MT_FC_reset()
{

/****************************************************************************/
  Char STR1[256];

    sprintf(STR1, "output %s;RE\n", HP5316B_CH ); /* reset FC */
    ieeewt(STR1);

}

/*****************************************************************************/
/*                           uninitialized FC                                */

Local Void MT_FC_uninit()
{

/*****************************************************************************/
  FC.exists = false;
}

/*main procedure*/

/*****************************************************************************/
/*                     makes parameters for FC                              */

Local Void MT_FC_makeparam()
{

/*****************************************************************************/

  v_paramkindrec *dummykind;   /*parameter kind placeholder*/

  v_addparamkind(&dummykind, v_pk_other);
  dummykind->chproc.proc = (Anyptr)MT_FC_chproc;
  dummykind->chproc.link = (Anyptr)NULL;
  dummykind->nchproc.proc = (Anyptr)MT_FC_nchproc;
  dummykind->nchproc.link = (Anyptr)NULL;
  dummykind->fmtproc.proc = (Anyptr)MT_FC_fmtproc;
  dummykind->fmtproc.link = (Anyptr)NULL;
  dummykind->nfmtproc.proc = (Anyptr)MT_FC_nfmtproc;
  dummykind->nfmtproc.link = (Anyptr)NULL;

  v_addparam("FC_OUTPUT", &FC.output, dummykind);
  v_addparam("FC_FUNC", &FC.func, dummykind);
  FC.exists = false;
}



/*****************************************************************************/
/*                   Procedures specific to FC function generator            */

Void MT_FC_MAIN(action_)
mt_action action_;
{


/*****************************************************************************/
/*****************************************************************************/
/* initializes library of FC                                                 */
  switch (action_) {


  case mt_reset:
    MT_FC_reset();
    break;

  case mt_init:
    MT_FC_init();
    break;

  case mt_uninit:
    MT_FC_uninit();
    break;

  case mt_update:
    MT_FC_update();
    break;

  case mt_makeparam:
    MT_FC_makeparam();
    break;
  }
}


/* End. */
