/* Output from p2c --VERSION--, the Pascal-to-C translator */
/* From input file "fgmt.text" */

/* "MT", a GPIB interface to view program,
   Copyright (C) 1987, 1990 California Institute of Technology.
   Original author: John Lazzaro
   Unix Port Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125.


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, Feb 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */



#include <p2c/p2c.h>

#include "mt.h"
#define FGMT_G
#include "fgmt.h"

#define HP3245A_CH       "09"



/*waveform*/

#define None            0
#define DC              1
#define Sinewave        2


typedef struct state_of_FG {
  boolean exists;   /*is one connected to HPIB*/
  v_paramrec *A_amplitude;   /*amplitude of waveform ch A*/
  v_paramrec *A_frequency;   /*frequency of waveform ch A*/
  v_paramrec *A_waveform;    /*waveform ch A */
  v_paramrec *B_amplitude;   /*amplitude of waveform ch B*/
  v_paramrec *B_frequency;   /*frequency of waveform ch B*/
  v_paramrec *B_waveform;    /*waveform ch B */

} state_of_FG;


Static state_of_FG FG;


/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
/*      MT procedure library for HP3314 function generator                  */
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/


/****************************************************************************/
/*    'this variable has been changed - here's the string '                 */

Static Void MT_FG_chproc(pp, val)
v_paramrec *pp;
Char *val;
{

/****************************************************************************/
  double testreal;
  long testint;
  Char STR1[256];

  if (!FG.exists)
    return;
  if ((pp == FG.A_waveform)||(pp == FG.B_waveform)) {
    strupper(val, val);
    if (!strcmp(val, "NONE")) {
      pp->val.U1.i1 = None;
    }
    if (!strcmp(val, "DC")) {
      pp->val.U1.i1 = DC;
      return;
    }
    if (!strcmp(val, "SIN") || !strcmp(val, "SINE") ||
	!strcmp(val, "SINEWAVE")) {
      pp->val.U1.i1 = Sinewave;
      return;
    } else {
      sprintf(STR1, "Do not understand %s", val);
      v_failmsg(STR1);
    }
    return;
  }
  if ((pp == FG.A_amplitude)||(pp == FG.B_amplitude)) {
    if (!v_parsereal(val, &testreal)) {
      sprintf(STR1, "Do not understand %s", val);
      v_failmsg(STR1);
      return;
    }

    if (pp == FG.A_amplitude) {
      testint = FG.A_waveform->val.U1.i1;
      sprintf(STR1, "output %s;USE CHANA\n", HP3245A_CH);
      ieeewt(STR1);}
    if (pp == FG.B_amplitude) {
      testint = FG.B_waveform->val.U1.i1;
      sprintf(STR1, "output %s;USE CHANB\n", HP3245A_CH);
      ieeewt(STR1);}

    switch (testint) {

     case None:
      pp->val.r = testreal;
      break;

     case DC:
      pp->val.r = testreal;
      sprintf(STR1, "output %s;APPLY DCV %g\n", HP3245A_CH, testreal);
      ieeewt(STR1);
      break;

     case Sinewave:
      testreal = fabs(testreal);
      pp->val.r = testreal;
      sprintf(STR1, "output %s;APPLY ACV %g\n", HP3245A_CH, testreal);
      ieeewt(STR1);
      break;

     default:
      v_failmsg("MT system error");
      break;
    }
   return;
  }
  if (pp == FG.A_frequency || pp == FG.B_frequency) {
    if (!v_parsereal(val, &testreal)) {
      sprintf(STR1, "Do not understand %s", val);
      v_failmsg(STR1);
      return;
    }
    testreal = fabs(testreal);
    pp->val.r = testreal;

    if (pp == FG.A_frequency) 
      sprintf(STR1, "output %s;USE CHANA\n", HP3245A_CH);
    else
      sprintf(STR1, "output %s;USE CHANB\n", HP3245A_CH);
    ieeewt(STR1);

    sprintf(STR1, "output %s;FREQ %g\n", HP3245A_CH, testreal);
    ieeewt(STR1);
    return;
  }
  v_failmsg("MT system error");
  return;
}


/***************************************************************************/
/*       'give me the value of this variable in string form'               */

Static Void MT_FG_fmtproc(pp, val)
v_paramrec *pp;
Char *val;
{

/***************************************************************************/
  if (!FG.exists)
    return;
  if (pp == FG.A_waveform||pp == FG.B_waveform) {
    switch (pp->val.U1.i1) {

    case None:
      strcpy(val, "None");
      break;

    case DC:
      strcpy(val, "DC");
      break;

    case Sinewave:
      strcpy(val, "SineWave");
      break;

    }
    return;
  }
  if (pp == FG.A_amplitude || pp == FG.A_frequency || pp == FG.B_amplitude ||
      pp == FG.B_frequency) {
    sprintf(val, "%g", pp->val.r);
    return;
  }
    v_failmsg("MT system error");
    return;
}


/****************************************************************************/
/*    'this variable has been changed - here's the number '                 */

Static Void MT_FG_nchproc(pp, val)
v_paramrec *pp;
double *val;
{

/*****************************************************************************/
}


/*****************************************************************************/
/*       'give me the value of this variable in number form'                 */

Static Void MT_FG_nfmtproc(pp, val)
v_paramrec *pp;
double *val;
{

/*****************************************************************************/
}


Local Void MT_FG_init()
{

/*****************************************************************************/

  Char STR1[256];

  TRY(try1);
    FG.exists = false;
    sprintf(STR1, "output %s;CLEAR\n", HP3245A_CH);
    ieeewt(STR1);
    sprintf(STR1, "output %s;RST\n", HP3245A_CH);
    ieeewt(STR1);
    sprintf(STR1, "output %s;SCRATCH\n", HP3245A_CH);
    ieeewt(STR1);
    FG.exists = true;
  RECOVER(try1);
   printf("HP3245 function generator not found - continuing initialization\n");
  ENDTRY(try1);
}


/*****************************************************************************/
/* uninitializes library of FG                                               */

Local Void MT_FG_uninit()
{

/*****************************************************************************/
  FG.exists = false;
}



/*****************************************************************************/
/* updates state of FG                                                       */

Local Void MT_FG_update()
{

/*****************************************************************************/
  if (!FG.exists)
    return;
}


/*****************************************************************************/
/*                resets FG state to sane values                             */

Local Void MT_FG_reset()
{

/*****************************************************************************/
  if (!FG.exists)
    return;
  FG.A_amplitude->val.r = 0;
  FG.A_frequency->val.r = 1000.0;
  FG.A_waveform->val.U1.i1 = None;
  FG.B_amplitude->val.r = 0;
  FG.B_frequency->val.r = 1000.0;
  FG.B_waveform->val.U1.i1 = None;
 
}

/**************************************************************************/

Local Void FG_DoCmd_Vinsert(buffer) 

Char *buffer;
{ 

/**************************************************************************/

  Char inbuff[256], fcurvename[256], fcurveperm[256];  /*parsed name of curve*/
  v_curverec *fcurve;                      /*pointer to curve*/
  Char STR1[256];
  int size, count;
  double max;


  if (!FG.exists){
    sprintf(STR1, "Initialize fg before using fg_vinsert");
    v_failmsg(STR1);}
  strcpy(inbuff, buffer);
  v_exstrword(buffer, fcurvename);           /* find curve name */
  strcpy(fcurveperm,fcurvename);
  v_curvelist(fcurvename, &fcurve, v_clone); /*  find curve     */
  strcpy(fcurvename, fcurveperm);
  if (fcurve == NULL) {
    sprintf(STR1, "%s not a curve", fcurvename);
    v_failmsg(STR1);
    return;
  }
 size = fcurve->base->len;
 if (size > 2048) {
  sprintf(STR1, "%s greater than 2048 points", fcurvename);
  v_failmsg(STR1);
  return;
  }
 max = 0;
 for (count = 0; count < size; count++) 
   if (fcurve->vec[count] != v_badvalue)
     if (fabs(fcurve->vec[count]) > max)
       max = fabs(fcurve->vec[count]);
 sprintf(STR1, "output %s;REAL SOUND(2047)\n", HP3245A_CH);
 ieeewt(STR1);
 sprintf(STR1, "output %s;FILL SOUND ", HP3245A_CH);
 ieeewt(STR1);


 for (count = 0; count < size-1; count++) 
   if (fcurve->vec[count] != v_badvalue){
    sprintf(STR1, " %f,", ((fcurve->vec[count])/max));
    ieeewt(STR1);}
   else {
    sprintf(STR1, " 0,");
    ieeewt(STR1);}
 count = size-1; 
 if (fcurve->vec[count] != v_badvalue){
  sprintf(STR1, " %f \n", ((fcurve->vec[count])/max));
  ieeewt(STR1);}
  else {
  sprintf(STR1, " 0 \n");
  ieeewt(STR1);}

 sprintf(STR1, "output %s;APPLY WFV 1, SOUND\n", HP3245A_CH);
 ieeewt(STR1);


 } 




/*****************************************************************************/
/*                     makes parameters for FG                              */

Local Void MT_FG_makeparam()
{

/*****************************************************************************/
  v_paramkindrec *dummykind;   /*parameter kind placeholder*/
  _PROCEDURE TEMP;

  v_addparamkind(&dummykind, v_pk_other);
  dummykind->chproc.proc = (Anyptr)MT_FG_chproc;
  dummykind->chproc.link = (Anyptr)NULL;
  dummykind->nchproc.proc = (Anyptr)MT_FG_nchproc;
  dummykind->nchproc.link = (Anyptr)NULL;
  dummykind->fmtproc.proc = (Anyptr)MT_FG_fmtproc;
  dummykind->fmtproc.link = (Anyptr)NULL;
  dummykind->nfmtproc.proc = (Anyptr)MT_FG_nfmtproc;
  dummykind->nfmtproc.link = (Anyptr)NULL;

  v_addparam("FG_A_AMP", &FG.A_amplitude, dummykind);
  v_addparam("FG_A_FREQ", &FG.A_frequency, dummykind);
  v_addparam("FG_A_WAVE", &FG.A_waveform, dummykind);

  v_addparam("FG_B_AMP", &FG.B_amplitude, dummykind);
  v_addparam("FG_B_FREQ", &FG.B_frequency, dummykind);
  v_addparam("FG_B_WAVE", &FG.B_waveform, dummykind);

  TEMP.proc = (Anyptr)FG_DoCmd_Vinsert; 
  TEMP.link = (Anyptr)NULL; 
  v_addcmd("Fg_Vinsert", TEMP, "Fg_Vinsert", 
  "Inserts a vector into the current arbitrary waveform"); 
  v_addhelp("Fg_Vinsert");
  v_addhelp("Inserts a vector into the current arbitrary waveform");

  FG.exists = false;

}


/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/
/*                       Main procedure of FG                                */

Void MT_FG_MAIN(action_)
mt_action action_;
{

/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/




/*****************************************************************************/
/* initializes library of FG                                                 */
/* main procedure for 3314                                                   */

  switch (action_) {

  case mt_reset:
    MT_FG_reset();
    break;

  case mt_init:
    MT_FG_init();
    break;

  case mt_uninit:
    MT_FG_uninit();
    break;

  case mt_update:
    MT_FG_update();
    break;

  case mt_makeparam:
    MT_FG_makeparam();
    break;
  }
}







/* End. */
