/* Output from p2c, the Pascal-to-C translator */
/* From input file "mmmt.text" */



#include <p2c/p2c.h>

#include "mt.h"
#define MMMT_G
#include "mmmt.h"



typedef struct state_of_MM {
  boolean exists;   /*is one connected to HPIB*/
  v_paramrec *resolution;   /*# of digits - 3/4/5/6 legal values*/
  v_paramrec *range;   /*range 0=autorange, 1--7 legal values*/
  v_paramrec *mode1;   /*mode1: V(volts),A(amps),R(ohms)*/
  v_paramrec *mode2;   /*mode2: A(AC),D(DC),B(db)*/
  v_paramrec *filter;   /*0 = no filter, 1-99 number of samples averages*/
  v_paramrec *output;   /*real number output of meter*/
} state_of_MM;


Static state_of_MM MM;


/*******************************************************************************/
/*******************************************************************************/
/*******************************************************************************/
/*                     MT Library for K196 Multimeter                          */
/*******************************************************************************/
/*******************************************************************************/
/*******************************************************************************/

/*HPIB library commands for K196
  FUNCTION K196_Error  : BOOLEAN;
  PROCEDURE trigger_K196;
  PROCEDURE Init_K196;*/
/*call at beginning*/
/*
    PROCEDURE Set_k196_Res (res : integer);*/
/*3,4,5,6 digits*/
/*
    PROCEDURE Set_k196_Range (range : integer);*/
/*0 auto, 1--7*/
/*
    PROCEDURE Set_k196_Mode (M,T : CHAR);*/
/*"M"  'V'  ==>  Voltmeter 'A'  ==>  Ammeter 'R'  ==>  Ohmmeter
{"T"  'A'  ==>  AC        'D'  ==>  DC      'B'  ==>  dB*/
/*PROCEDURE Set_k196_Filter(filter: integer);*/
/*Sets filter function to off if filter = 0
  Number of readings averaged if filter = 1-99*/
/*FUNCTION  Read_k196: REAL;*/
/*  Reads Keithley 196 DVM  */
/*PROCEDURE Reset_k196;*/
/*put 196 into continous trigger and local mode*/



/*******************************************************************************/
/*    'this variable has been changed - here's the string '                    */

Static Void MT_MM_chproc(pp, val)
v_paramrec *pp;
Char *val;
{

  /*******************************************************************************/
  long testint;
  Char STR1[256];

  if (!MM.exists)
    return;
  if (pp == MM.mode1) {
    strupper(val, val);
    if (!strcmp(val, "VOLT") || !strcmp(val, "VOLTS") ||
	!strcmp(val, "VOLTMETER") || !strcmp(val, "V")) {
      pp->val.c[0] = 'V';
      return;
    }
    /*Set_k196_Mode (mode1^.val.c[0], mode2^.val.c[0]);*/
    if (!strcmp(val, "AMP") || !strcmp(val, "AMPS") ||
	!strcmp(val, "AMMETER") || !strcmp(val, "A")) {
      pp->val.c[0] = 'A';
      return;
    }
    if (!strcmp(val, "OHM") || !strcmp(val, "OHMS") ||
	!strcmp(val, "OHMMETER") || !strcmp(val, "R") || !strcmp(val, "O"))
      pp->val.c[0] = 'R';
    else {
      sprintf(STR1, "Do not understand %s", val);
      v_failmsg(STR1);
    }
    return;
  }
  if (pp == MM.mode2) {
    strupper(val, val);
    if (!strcmp(val, "AC") || !strcmp(val, "A")) {
      pp->val.c[0] = 'A';
      return;
    }
    /*Set_k196_Mode (mode1^.val.c[0], mode2^.val.c[0]);*/
    if (!strcmp(val, "DC") || !strcmp(val, "D")) {
      pp->val.c[0] = 'D';
      return;
    }
    if (!strcmp(val, "DB") || !strcmp(val, "B"))
      pp->val.c[0] = 'B';
    else {
      sprintf(STR1, "Do not understand %s", val);
      v_failmsg(STR1);
    }
    return;
  }
  if (pp == MM.resolution) {
    if (v_parseinteger(val, &testint) && testint > 2 && testint < 7)
      pp->val.U1.i1 = testint;
    else {
      sprintf(STR1, "Incorrect value %s", val);
      v_failmsg(STR1);
    }
    /*Set_K196_Res(pp^.val.i1);*/
    return;
  }
  if (pp == MM.range) {
    if (v_parseinteger(val, &testint) && testint > -1 && testint < 8) {
      pp->val.U1.i1 = testint;
      return;
    }
    /*Set_K196_Range(pp^.val.i1);*/
    strupper(val, val);
    if (!strcmp(val, "AUTO") || !strcmp(val, "A"))
      pp->val.U1.i1 = 0;
    else {
      sprintf(STR1, "Incorrect value %s", val);
      v_failmsg(STR1);
    }
    return;
  }
  if (pp == MM.filter) {
    if (v_parseinteger(val, &testint) && testint > -1 && testint < 100) {
      pp->val.U1.i1 = testint;
      return;
    }
    /*Set_K196_Filter(pp^.val.i1);*/
    strupper(val, val);
    if (!strcmp(val, "OFF") || !strcmp(val, "O"))
      pp->val.U1.i1 = 0;
    else {
      sprintf(STR1, "Incorrect value %s", val);
      v_failmsg(STR1);
    }
    return;
  }
  if (pp == MM.output)
    v_failmsg("Writing attempted to a read-only parameter");
  else
    v_failmsg("MT system error");
}


/*******************************************************************************/
/*       'give me the value of this variable in string form'                   */

Static Void MT_MM_fmtproc(pp, val)
v_paramrec *pp;
Char *val;
{

  /*******************************************************************************/
  if (!MM.exists)
    return;
  if (pp == MM.mode1) {
    sprintf(val, "%c", pp->val.c[0]);
    return;
  }
  if (pp == MM.mode2) {
    switch (pp->val.c[0]) {

    case 'A':
      strcpy(val, "AC");
      break;

    case 'B':
      strcpy(val, "dB");
      break;

    case 'D':
      strcpy(val, "DC");
      break;
    }
    return;
  }
  if (pp == MM.resolution) {
    sprintf(val, "%ld", pp->val.U1.i1);
    return;
  }
  if (pp == MM.range) {
    if (pp->val.U1.i1 == 0)
      strcpy(val, "AUTO");
    else
      sprintf(val, "%ld", pp->val.U1.i1);
    return;
  }
  if (pp == MM.filter) {
    if (pp->val.U1.i1 == 0)
      strcpy(val, "OFF");
    else
      sprintf(val, "%ld", pp->val.U1.i1);
    return;
  }
  if (pp == MM.output) {
    /*pp^.val.r := Read_k196;*/
    sprintf(val, "%g", pp->val.r);
  } else
    v_failmsg("MT system error");
}


/*******************************************************************************/
/*    'this variable has been changed - here's the number '                    */

Static Void MT_MM_nchproc(pp, val)
v_paramrec *pp;
double *val;
{

  /*******************************************************************************/
}


/*******************************************************************************/
/*       'give me the value of this variable in number form'                   */

Static Void MT_MM_nfmtproc(pp, val)
v_paramrec *pp;
double *val;
{

  /*******************************************************************************/
}


Local Void MT_MM_init()
{

  /*******************************************************************************/
  TRY(try1);
    MM.exists = false;
    /*Init_K196;*/
    MM.exists = true;
    MM.output->val.r = 0.0;   /*meter output*/
  RECOVER(try1);
    printf("K196 multimeter  not found - continuing initialization\n");
  ENDTRY(try1);
}

/*******************************************************************************/
/* uninitializes library of MM                                                     */

Local Void MT_MM_uninit()
{

  /*******************************************************************************/
  MM.exists = false;
}

/*******************************************************************************/
/* updates state of MM                                                       */

Local Void MT_MM_update()
{

  /*******************************************************************************/
  /*Set_k196_Range(range^.val.i1);*/
  /*Set_k196_Mode (mode1^.val.c[0],mode2^.val.c[0]);*/
  /*Set_k196_Res (resolution^.val.i1);*/
  /*Set_k196_Filter(filter^.val.i1);*/
}


/*******************************************************************************/
/*               resets MM state to sane values                        */

Local Void MT_MM_reset()
{

  /*******************************************************************************/
  if (!MM.exists)
    return;
  MM.resolution->val.U1.i1 = 6;   /*six digits resolution*/
  MM.range->val.U1.i1 = 0;   /*autoranging*/
  MM.mode1->val.c[0] = 'V';   /*volts*/
  MM.mode2->val.c[0] = 'A';   /*AC*/
  MM.filter->val.U1.i1 = 4;   /*average over 4+1 readings*/
}

/*******************************************************************************/
/*                     makes parameters for MM                             */

Local Void MT_MM_makeparam()
{

  /*******************************************************************************/
  v_paramkindrec *dummykind;   /*parameter kind placeholder*/

  v_addparamkind(&dummykind, v_pk_other);
  dummykind->chproc.proc = (Anyptr)MT_MM_chproc;
  dummykind->chproc.link = (Anyptr)NULL;
  dummykind->nchproc.proc = (Anyptr)MT_MM_nchproc;
  dummykind->nchproc.link = (Anyptr)NULL;
  dummykind->fmtproc.proc = (Anyptr)MT_MM_fmtproc;
  dummykind->fmtproc.link = (Anyptr)NULL;
  dummykind->nfmtproc.proc = (Anyptr)MT_MM_nfmtproc;
  dummykind->nfmtproc.link = (Anyptr)NULL;

  v_addparam("MM_DIGITS", &MM.resolution, dummykind);
  v_addparam("MM_RANGE", &MM.range, dummykind);
  v_addparam("MM_V_A_R", &MM.mode1, dummykind);
  v_addparam("MM_AC_DC_DB", &MM.mode2, dummykind);
  v_addparam("MM_AVERAGE", &MM.filter, dummykind);
  v_addparam("MM_OUTPUT", &MM.output, dummykind);
  MM.exists = false;

}


/*******************************************************************************/
/*                       Main procedures of MM                               */

Void MT_MM_MAIN(action_)
mt_action action_;
{

  /*******************************************************************************/



  /*******************************************************************************/
  /* initializes library of MM                                                     */
  /* main procedure for MM */

  switch (action_) {

  case mt_reset:
    MT_MM_reset();
    break;

  case mt_init:
    MT_MM_init();
    break;

  case mt_uninit:
    MT_MM_uninit();
    break;

  case mt_update:
    MT_MM_update();
    break;

  case mt_makeparam:
    MT_MM_makeparam();
    break;
  }
}








/* End. */
