
/* "MT", a GPIB interface to view program,
   Copyright (C) 1987, 1990 California Institute of Technology.
   Original author: John Lazzaro
   Unix Port Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, Feb 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* From input file "mmmt.text" */



#include <p2c/p2c.h>

#include "mt.h"
#define MMMT_G
#include "mmmt.h"

#define K197_CH       "04"


typedef struct state_of_MM {
  boolean exists;   /*is one connected to HPIB*/
  v_paramrec *db;       /*Y = dB mode, N = not dB mode */
  v_paramrec *output;   /*real number output of meter*/
} state_of_MM;


Static state_of_MM MM;


/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/
/*                     MT Library for K197 Multimeter                        */
/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/



/*****************************************************************************/
/*    'this variable has been changed - here's the string '                  */

Static Void MT_MM_chproc(pp, val)
v_paramrec *pp;
Char *val;
{

/*****************************************************************************/

  long testint;
  Char STR1[256];

  if (!MM.exists)
    return;
  if (pp == MM.db) {
    strupper(val, val);
    if (!strcmp(val, "ON") || !strcmp(val, "YES") ||
	!strcmp(val, "Y") || !strcmp(val, "TRUE")) {
      pp->val.c[0] = 'Y';
      sprintf(STR1, "output %s;D1X\n", K197_CH);
      ieeewt(STR1);
      return;
    }
    if (!strcmp(val, "OFF") || !strcmp(val, "NO") ||
	!strcmp(val, "N") || !strcmp(val, "FALSE")) {
      pp->val.c[0] = 'N';
      sprintf(STR1, "output %s;D0X\n", K197_CH);
      ieeewt(STR1);
      return;
    }
    else {
      sprintf(STR1, "Do not understand %s", val);
      v_failmsg(STR1);
    }
    return;
  }
  if (pp == MM.output)
    v_failmsg("Writing attempted to a read-only parameter");
  else
    v_failmsg("MT system error");
}


/*****************************************************************************/
/*       'give me the value of this variable in string form'                 */

Static Void MT_MM_fmtproc(pp, val)
v_paramrec *pp;
Char *val;
{

  Char STR1[256];
  float reading;

/*****************************************************************************/
 
  if (!MM.exists)
    return;
  if (pp == MM.db) {
    switch (pp->val.c[0]) {

    case 'Y':
      strcpy(val, "on");
      break;
    case 'N':
      strcpy(val, "off");
      break;

    }
    return;
  }
  if (pp == MM.output) {
   sprintf(STR1, "enter %s\n", K197_CH);
   ieeewt(STR1);
   ieeescnf("%e", &reading);
   pp->val.r = reading;
   sprintf(val, "%g", pp->val.r);
  } else
    v_failmsg("MT system error");
}


/*****************************************************************************/
/*    'this variable has been changed - here's the number '                  */

Static Void MT_MM_nchproc(pp, val)
v_paramrec *pp;
double *val;
{

/*****************************************************************************/
}


/*****************************************************************************/
/*       'give me the value of this variable in number form'                 */

Static Void MT_MM_nfmtproc(pp, val)
v_paramrec *pp;
double *val;
{

/*****************************************************************************/
}


Local Void MT_MM_init()
{
  
  Char STR1[256];

/*****************************************************************************/
  TRY(try1);
    MM.exists = false;
    sprintf(STR1, "clear %s\n", K197_CH);      /* does SDC */
    ieeewt(STR1);
    sprintf(STR1, "output %s;G1D0X\n", K197_CH);
    ieeewt(STR1);
    MM.exists = true;
    MM.output->val.r = 0.0;   /*meter output*/
  RECOVER(try1);
    printf("K197 multimeter  not found - continuing initialization\n");
  ENDTRY(try1);
}

/*****************************************************************************/
/* uninitializes library of MM                                               */

Local Void MT_MM_uninit()
{

/****************************************************************************/
  MM.exists = false;
}


/*****************************************************************************/
/* updates state of MM                                                       */

Local Void MT_MM_update()
{
  Char STR1[256];
/****************************************************************************/
    
  switch (MM.db->val.c[0]) {

    case 'Y':
      sprintf(STR1, "output %s;D1X\n", K197_CH);
      ieeewt(STR1);
      break;
    case 'N':
      sprintf(STR1, "output %s;D0X\n", K197_CH);
      ieeewt(STR1);
      break;

    }
}


/*****************************************************************************/
/*               resets MM state to sane values                              */

Local Void MT_MM_reset()
{

/*****************************************************************************/
  if (!MM.exists)
    return;
  MM.db->val.c[0] = 'N';   /*dB mode off*/
  MM.output->val.r = 0.0;   /*null meter output*/

}

/*****************************************************************************/
/*                     makes parameters for MM                               */

Local Void MT_MM_makeparam()
{

/*****************************************************************************/
  v_paramkindrec *dummykind;   /*parameter kind placeholder*/

  v_addparamkind(&dummykind, v_pk_other);
  dummykind->chproc.proc = (Anyptr)MT_MM_chproc;
  dummykind->chproc.link = (Anyptr)NULL;
  dummykind->nchproc.proc = (Anyptr)MT_MM_nchproc;
  dummykind->nchproc.link = (Anyptr)NULL;
  dummykind->fmtproc.proc = (Anyptr)MT_MM_fmtproc;
  dummykind->fmtproc.link = (Anyptr)NULL;
  dummykind->nfmtproc.proc = (Anyptr)MT_MM_nfmtproc;
  dummykind->nfmtproc.link = (Anyptr)NULL;

  v_addparam("MM_DB", &MM.db, dummykind);
  v_addparam("MM_OUTPUT", &MM.output, dummykind);
  MM.exists = false;

}


/*****************************************************************************/
/*                       Main procedures of MM                               */

Void MT_MM_MAIN(action_)
mt_action action_;
{

/*****************************************************************************/



/*****************************************************************************/
  
/* initializes library of MM */
/* main procedure for MM */

  switch (action_) {

  case mt_reset:
    MT_MM_reset();
    break;

  case mt_init:
    MT_MM_init();
    break;

  case mt_uninit:
    MT_MM_uninit();
    break;

  case mt_update:
    MT_MM_update();
    break;

  case mt_makeparam:
    MT_MM_makeparam();
    break;
  }
}








/* End. */
