/* Output from p2c --VERSION--, the Pascal-to-C translator */
/* From input file "fgmt.text" */



#include <p2c/p2c.h>


#define FGMT_G
#include "fgmt.h"



/*waveform*/

#define None            0
#define Sinewave        1
#define Squarewave      2
#define Triwave         3

/*arbitrary waveform mode*/

#define ArbOff          0
#define ArbOn           1
#define ArbClear        2


typedef struct state_of_FG {
  boolean exists;   /*is one connected to HPIB*/
  v_paramrec *amplitude;   /*amplitude of waveform*/
  v_paramrec *offset;   /*DC of waveform*/
  v_paramrec *frequency;   /*frequency of waveform*/
  v_paramrec *phase;   /*phase of waveform*/
  v_paramrec *waveform;   /*waveform: see const list for code*/
  v_paramrec *arbmode;   /*arb waveform mode: see const list for code*/
  v_paramrec *vheight;   /*arb waveform mode: current vector height*/
  v_paramrec *vlength;   /*arb waveform mode: current vector length*/
} state_of_FG;


Static state_of_FG FG;


/*******************************************************************************/
/*******************************************************************************/
/*******************************************************************************/
/*      MT procedure library for HP3314 function generator                     */
/*******************************************************************************/
/*******************************************************************************/
/*******************************************************************************/

/*HPIB library commands for function generator

  FUNCTION HP3314_Error  : BOOLEAN;
  FUNCTION Readv_hp3314: REAL;
  FUNCTION Readf_hp3314: REAL;
  PROCEDURE trigger_hp3314;
  PROCEDURE Init_hp3314;
  PROCEDURE Set_hp3314_v (amplitude : real);
  PROCEDURE Set_hp3314_off (offset : real);
  PROCEDURE Set_hp3314_phase (phase : real);
  PROCEDURE Set_hp3314_f (frequency : real);
  PROCEDURE Set_hp3314_func (func : integer);
  PROCEDURE Reset_hp3314;
  PROCEDURE Set_hp3314_arbmode(mode :integer);
  PROCEDURE Set_hp3314_newvector(vheight, vlength :integer);*/

/*******************************************************************************/
/*    'this variable has been changed - here's the string '                    */

Static Void MT_FG_chproc(pp, val)
v_paramrec *pp;
Char *val;
{

  /*******************************************************************************/
  double testreal;
  long testint;
  Char STR1[256];

  if (!FG.exists)
    return;
  if (pp == FG.waveform) {
    strupper(val, val);
    if (!strcmp(val, "NONE") || !strcmp(val, "DC")) {
      pp->val.U1.i1 = None;
      Set_hp3314_func(None);
/* p2c: fgmt.text, line 101:
 * Warning: Symbol 'SET_HP3314_FUNC' is not defined [221] */
      return;
    }
    if (!strcmp(val, "SIN") || !strcmp(val, "SINE") ||
	!strcmp(val, "SINEWAVE")) {
      pp->val.U1.i1 = Sinewave;
      Set_hp3314_func(Sinewave);
/* p2c: fgmt.text, line 107:
 * Warning: Symbol 'SET_HP3314_FUNC' is not defined [221] */
      return;
    }
    if (!strcmp(val, "SQUARE") || !strcmp(val, "SQR") ||
	!strcmp(val, "SQUAREWAVE")) {
      pp->val.U1.i1 = Squarewave;
      Set_hp3314_func(Squarewave);
/* p2c: fgmt.text, line 113:
 * Warning: Symbol 'SET_HP3314_FUNC' is not defined [221] */
      return;
    }
    if (!strcmp(val, "TRIWAVE") || !strcmp(val, "TRI") ||
	!strcmp(val, "TRIANGLE") || !strcmp(val, "TRIANGLEWAVE")) {
      pp->val.U1.i1 = Triwave;
      Set_hp3314_func(Triwave);
/* p2c: fgmt.text, line 120:
 * Warning: Symbol 'SET_HP3314_FUNC' is not defined [221] */
    } else {
      sprintf(STR1, "Do not understand %s", val);
      v_failmsg(STR1);
    }
    return;
  }
  if (pp == FG.amplitude) {
    if (!v_parsereal(val, &testreal)) {
      sprintf(STR1, "Do not understand %s", val);
      v_failmsg(STR1);
      return;
    }
    testreal = fabs(testreal);
    pp->val.r = testreal;
    Set_hp3314_v(testreal);
/* p2c: fgmt.text, line 132:
 * Warning: Symbol 'SET_HP3314_V' is not defined [221] */
    return;
  }
  if (pp == FG.frequency) {
    if (!v_parsereal(val, &testreal)) {
      sprintf(STR1, "Do not understand %s", val);
      v_failmsg(STR1);
      return;
    }
    testreal = fabs(testreal);
    pp->val.r = testreal;
    Set_hp3314_f(testreal);
/* p2c: fgmt.text, line 144:
 * Warning: Symbol 'SET_HP3314_F' is not defined [221] */
    return;
  }
  if (pp == FG.offset) {
    if (v_parsereal(val, &testreal)) {
      pp->val.r = testreal;
      Set_hp3314_off(testreal);
/* p2c: fgmt.text, line 155:
 * Warning: Symbol 'SET_HP3314_OFF' is not defined [221] */
    } else {
      sprintf(STR1, "Do not understand %s", val);
      v_failmsg(STR1);
    }
    return;
  }
  if (pp == FG.phase) {
    if (v_parsereal(val, &testreal)) {
      pp->val.r = testreal;
      Set_hp3314_phase(testreal);
/* p2c: fgmt.text, line 166:
 * Warning: Symbol 'SET_HP3314_PHASE' is not defined [221] */
    } else {
      sprintf(STR1, "Do not understand %s", val);
      v_failmsg(STR1);
    }
    return;
  }
  if (pp == FG.arbmode) {
    strupper(val, val);
    if (!strcmp(val, "OFF")) {
      pp->val.U1.i1 = ArbOff;
      Set_hp3314_arbmode(ArbOff);
/* p2c: fgmt.text, line 178:
 * Warning: Symbol 'SET_HP3314_ARBMODE' is not defined [221] */
      return;
    }
    if (!strcmp(val, "ON")) {
      pp->val.U1.i1 = ArbOn;
      Set_hp3314_arbmode(ArbOn);
/* p2c: fgmt.text, line 184:
 * Warning: Symbol 'SET_HP3314_ARBMODE' is not defined [221] */
      return;
    }
    if (!strcmp(val, "CLEAR")) {
      pp->val.U1.i1 = ArbClear;
      Set_hp3314_arbmode(ArbClear);
/* p2c: fgmt.text, line 190:
 * Warning: Symbol 'SET_HP3314_ARBMODE' is not defined [221] */
    } else {
      sprintf(STR1, "Do not understand %s", val);
      v_failmsg(STR1);
    }
    return;
  }
  if (pp == FG.vheight) {
    if (v_parseinteger(val, &testint) && testint >= -1999 && testint <= 1999)
      pp->val.U1.i1 = testint;
    else {
      sprintf(STR1, "Do not understand %s", val);
      v_failmsg(STR1);
    }
    return;
  }
  if (pp != FG.vlength) {
    v_failmsg("MT system error");
    return;
  }
  if (v_parseinteger(val, &testint) && testint >= 1 && testint <= 127)
    pp->val.U1.i1 = testint;
  else {
    sprintf(STR1, "Do not understand %s", val);
    v_failmsg(STR1);
  }
}


/*******************************************************************************/
/*       'give me the value of this variable in string form'                   */

Static Void MT_FG_fmtproc(pp, val)
v_paramrec *pp;
Char *val;
{

  /*******************************************************************************/
  if (!FG.exists)
    return;
  if (pp == FG.waveform) {
    switch (pp->val.U1.i1) {

    case None:
      strcpy(val, "None");
      break;

    case Sinewave:
      strcpy(val, "SineWave");
      break;

    case Squarewave:
      strcpy(val, "SquareWave");
      break;

    case Triwave:
      strcpy(val, "TriangleWave");
      break;
    }
    return;
  }
  if (pp == FG.amplitude || pp == FG.frequency || pp == FG.offset ||
      pp == FG.phase) {
    sprintf(val, "%g", pp->val.r);
    return;
  }
  if (pp == FG.arbmode) {
    switch (pp->val.U1.i1) {

    case ArbOff:
      strcpy(val, "Off");
      break;

    case ArbOn:
      strcpy(val, "On");
      break;

    case ArbClear:
      strcpy(val, "Clear");
      break;
    }
    return;
  }
  if (pp == FG.vlength || pp == FG.vheight)
    sprintf(val, "%ld", pp->val.U1.i1);
  else
    v_failmsg("MT system error");
}


/*******************************************************************************/
/*    'this variable has been changed - here's the number '                    */

Static Void MT_FG_nchproc(pp, val)
v_paramrec *pp;
double *val;
{

  /*******************************************************************************/
}


/*******************************************************************************/
/*       'give me the value of this variable in number form'                   */

Static Void MT_FG_nfmtproc(pp, val)
v_paramrec *pp;
double *val;
{

  /*******************************************************************************/
}


Local Void MT_FG_init()
{

  /*******************************************************************************/
  TRY(try1);
    FG.exists = false;
    Init_hp3314();
/* p2c: fgmt.text, line 310:
 * Warning: Symbol 'INIT_HP3314' is not defined [221] */
    FG.exists = true;
  RECOVER(try1);
    printf("HP3314 function generator not found - continuing initialization\n");
  ENDTRY(try1);
}


/*******************************************************************************/
/* uninitializes library of FG                                               */

Local Void MT_FG_uninit()
{

  /*******************************************************************************/
  FG.exists = false;
}



/*******************************************************************************/
/* updates state of FG                                                     */

Local Void MT_FG_update()
{

  /*******************************************************************************/
  if (!FG.exists)
    return;
  Set_hp3314_v(FG.amplitude->val.r);
/* p2c: fgmt.text, line 342:
 * Warning: Symbol 'SET_HP3314_V' is not defined [221] */
  Set_hp3314_off(FG.offset->val.r);
/* p2c: fgmt.text, line 343:
 * Warning: Symbol 'SET_HP3314_OFF' is not defined [221] */
  Set_hp3314_phase(FG.phase->val.r);
/* p2c: fgmt.text, line 344:
 * Warning: Symbol 'SET_HP3314_PHASE' is not defined [221] */
  Set_hp3314_f(FG.frequency->val.r);
/* p2c: fgmt.text, line 345:
 * Warning: Symbol 'SET_HP3314_F' is not defined [221] */
  Set_hp3314_func(FG.waveform->val.U1.i1);
/* p2c: fgmt.text, line 346:
 * Warning: Symbol 'SET_HP3314_FUNC' is not defined [221] */
  Set_hp3314_arbmode(FG.arbmode->val.U1.i1);
/* p2c: fgmt.text, line 347:
 * Warning: Symbol 'SET_HP3314_ARBMODE' is not defined [221] */
}


/*******************************************************************************/
/*                resets FG state to sane values                           */

Local Void MT_FG_reset()
{

  /*******************************************************************************/
  if (!FG.exists)
    return;
  FG.amplitude->val.r = 0.02;
  FG.offset->val.r = 0.0;
  FG.phase->val.r = 0.0;
  FG.frequency->val.r = 1000.0;
  FG.waveform->val.U1.i1 = Sinewave;
  FG.arbmode->val.U1.i1 = ArbOff;
  FG.vlength->val.U1.i1 = 1;
  FG.vheight->val.U1.i1 = 0;
}


/*******************************************************************************/

Local Void FG_DoCmd_Vinsert(buffer)
Char *buffer;
{

  /*******************************************************************************/
  Set_hp3314_newvector(FG.vheight->val.U1.i1, FG.vlength->val.U1.i1);
/* p2c: fgmt.text, line 382:
 * Warning: Symbol 'SET_HP3314_NEWVECTOR' is not defined [221] */
}


/*******************************************************************************/
/*                     makes parameters for FG                             */

Local Void MT_FG_makeparam()
{

  /*******************************************************************************/
  v_paramkindrec *dummykind;   /*parameter kind placeholder*/
  _PROCEDURE TEMP;

  v_addparamkind(&dummykind, v_pk_other);
  dummykind->chproc.proc = (Anyptr)MT_FG_chproc;
  dummykind->chproc.link = (Anyptr)NULL;
  dummykind->nchproc.proc = (Anyptr)MT_FG_nchproc;
  dummykind->nchproc.link = (Anyptr)NULL;
  dummykind->fmtproc.proc = (Anyptr)MT_FG_fmtproc;
  dummykind->fmtproc.link = (Anyptr)NULL;
  dummykind->nfmtproc.proc = (Anyptr)MT_FG_nfmtproc;
  dummykind->nfmtproc.link = (Anyptr)NULL;

  v_addparam("FG_ACAMP", &FG.amplitude, dummykind);
  v_addparam("FG_DCAMP", &FG.offset, dummykind);
  v_addparam("FG_PHASE", &FG.phase, dummykind);
  v_addparam("FG_FREQ", &FG.frequency, dummykind);
  v_addparam("FG_WAVE", &FG.waveform, dummykind);
  v_addparam("FG_ARBMODE", &FG.arbmode, dummykind);
  v_addparam("FG_VLENGTH", &FG.vlength, dummykind);
  v_addparam("FG_VHEIGHT", &FG.vheight, dummykind);

  TEMP.proc = (Anyptr)FG_DoCmd_Vinsert;
  TEMP.link = (Anyptr)NULL;
  v_addcmd("Fg_Vinsert", TEMP, "Fg_Vinsert",
	   "Inserts a vector into the current arbitrary waveform");
  v_addhelp("Fg_Vinsert");
  v_addhelp("Inserts a vector into the current arbitrary waveform");

  FG.exists = false;

}


/*******************************************************************************/
/*******************************************************************************/
/*******************************************************************************/
/*                       Main procedure of FG                              */

Void MT_FG_MAIN(action_)
mt_action action_;
{

  /*******************************************************************************/
  /*******************************************************************************/
  /*******************************************************************************/




  /*******************************************************************************/
  /* initializes library of FG                                               */
  /* main procedure for 3314  */

  switch (action_) {

  case mt_reset:
    MT_FG_reset();
    break;

  case mt_init:
    MT_FG_init();
    break;

  case mt_uninit:
    MT_FG_uninit();
    break;

  case mt_update:
    MT_FG_update();
    break;

  case mt_makeparam:
    MT_FG_makeparam();
    break;
  }
}







/* End. */
