
/* "Take/Tek2430", a Tek2430 interface to view program,
   Copyright (C) 1987, 1990 California Institute of Technology.
   Original authors: John Tanner, Dave Gillespie, Mass Sivilotti, John Lazzaro
   Unix Port Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, Feb 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* From input file "take2430.text" */


/* View-tool interface to TEK2430 module */
/* Dave Gillespie 1/19/88 */




#include <p2c/p2c.h>


#define TAKE2430_G
#include "take2430.h"



Static Char cvname[256];


#define maxchans        2


Static Void dotake2430(buf_)
Char *buf_;
{
  Char buf[256];
  long i, size;
  Char chan[3];
  Char buf2[256], wrd[256];
  long numchans, numnames;
  Char STR1[256];
  Char STR2[22];
  Char STR3[28];

  strcpy(buf, buf_);
  /* Count how many names entered on command line */
  numnames = 0;
  strcpy(buf2, buf);
  do {
    v_strword(buf2, wrd);   /*eat a name from temporary stuff*/
    if (*wrd != '\0')
      numnames++;
  } while (*wrd != '\0');
  if (numnames == 1)   /*get curve name*/
    v_strword(buf, cvname);

  /* Get the data */
  capture_traces_from_scope("Joe_Data");   /*title is not used*/

  /* Count how many channels responded */
  numchans = 0;
  for (i = 1; i <= maxchans; i++) {
    get_view_info(i, &size);
    if (size > 0)
      numchans++;
  }
  if (numnames > numchans) {
    sprintf(STR1, "Too many names; only got %ld channels", numchans);
    v_failmsg(STR1);
  }
  if (numnames < numchans && numnames > 1)
    v_failmsg("Not enough curve names");

  /* Store the curves */
  for (i = 1; i <= maxchans; i++) {
    /* chan := strchar(chr(ord('A') + i-1)); */
    sprintf(chan, "%ld", i);
    get_view_info(i, &size);
    if (size > 0) {
      v_stretchtempvecs(size);
      get_view_curve(i, &v_tempxvec, &v_tempyvec);
      if (numnames > 1)   /*get one word from command line*/
	v_strword(buf, wrd);
      else if (numchans > 1)
	sprintf(wrd, "%s%s", cvname, chan);
	    /*add channel letter if necessary*/
      else
	strcpy(wrd, cvname);
      if (numnames < numchans) {  /*verify the name*/
	sprintf(STR3, "Curve name for channel %s: ", chan);
	v_readkbddef(wrd, STR3, wrd, "");   /*ignore result*/
	if (*wrd == '\0')
	  sprintf(wrd, "%s%s", cvname, chan);
	else if (strends(wrd, chan) && strlen(wrd) > strlen(chan))
	  sprintf(cvname, "%.*s", strlen(wrd) - strlen(chan), wrd);
	else if (numchans == 1)
	  strcpy(cvname, wrd);
      }
      v_addcurve(size, v_tempxvec, v_tempyvec, "Sec", "V", wrd);
    } else {
      sprintf(STR2, "No data on channel %s", chan);
      v_logwriteln(STR2);
    }
  }

  /*remember the name*/
}

#undef maxchans


Void take2430_viewinit()
{
  _PROCEDURE TEMP;

  init_tek2430();
  strcpy(cvname, "scope");
  TEMP.proc = (Anyptr)dotake2430;
  TEMP.link = (Anyptr)NULL;
  v_addcmd("take2430", TEMP, "take2430", "Take data from scope");
  v_addhelp("take2430");
  v_addhelp("take2430 <curve>");
  v_addhelp("take2430 <curve> <curve>");
  v_addhelp("  Take a curve or pair of curves from the");
  v_addhelp("  Tektronix 2430 oscilloscope.");
}


/*take2430*/






/* End. */
