
/* "Take/Tek2430", a Tek2430 interface to view program,
   Copyright (C) 1987, 1990 California Institute of Technology.
   Original authors: John Tanner, Dave Gillespie, Mass Sivilotti, John Lazzaro
   Unix Port Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, Feb 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* From input file "tek2430main.text" */


#include <p2c/p2c.h>


#ifndef IODECLARATIONS_H
#include <p2c/iodecl.h>
#endif

#ifndef GENERAL_0_H
#include <p2c/general_0.h>
#endif

#ifndef GENERAL_2_H
#include <p2c/general_2.h>
#endif

#ifndef GENERAL_3_H
#include <p2c/general_3.h>
#endif

#ifndef GENERAL_1_H
#include <p2c/general_1.h>
#endif

#ifndef SYSDEVS_H
#include <p2c/sysdevs.h>
#endif

#ifndef HPIB_1_H
#include <p2c/hpib_1.h>
#endif

#ifndef HPIB_2_H
#include <p2c/hpib_2.h>
#endif

#ifndef HPIB_3_H
#include <p2c/hpib_3.h>
#endif

#ifndef HPIB_0_H
#include <p2c/hpib_0.h>
#endif

#ifndef NEWKBD_H
#include <p2c/newkbd.h>
#endif

#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

#ifndef PLOT_H
#include <p2c/plot.h>
#endif

#ifndef PLOT_ROUTINES_H
#include <p2c/plot_routines.h>
#endif

#ifndef TEK2430_H
#include "tek2430.h"
#endif


Static long i;
Static Char command;
Static Char fname[81];
Static boolean quit;
Static long cp1, y1_, cp2, y2;
Static Char labl[256];


/* Local variables for maryanns_plot_stuff: */
struct LOC_maryanns_plot_stuff {
  double *ch1x, *ch2x, *ch1y, *ch2y;
  long points;
  Char ylabel[2][81];
  long numTraces;
} ;

Local Void plotit(LINK)
struct LOC_maryanns_plot_stuff *LINK;
{
  long i, FORLIM;

  if (LINK->numTraces == 1) {
    mam_scale(&LINK->ch1x, &LINK->ch1y, LINK->points);
    printf("ok\n");
    printf("%12ld\n", LINK->points);
    FORLIM = LINK->points;
    for (i = 1; i <= FORLIM; i++)
      printf("% .5E% .5E\n", LINK->ch1x[i - 1], LINK->ch1y[i - 1]);
    mam_axis("Time", "Sec", "linear", LINK->ylabel[0], "V", "linear");
    mam_plot(&LINK->ch1x, &LINK->ch1y, LINK->points);
    mam_close();
    return;
  }
  if (LINK->numTraces != 2)
    return;
  mam_scale(&LINK->ch1x, &LINK->ch1y, LINK->points);
  mam_rscale(&LINK->ch2x, &LINK->ch2y, LINK->points);
  mam_axis3("Time", "Sec", "linear", LINK->ylabel[0], "V", "linear",
	    LINK->ylabel[1], "V", "linear");
  mam_plot(&LINK->ch1x, &LINK->ch1y, LINK->points);
  mam_plot3(&LINK->ch2x, &LINK->ch2y, LINK->points);
  mam_close();
}


Static Void maryanns_plot_stuff()
{
  struct LOC_maryanns_plot_stuff V;
  Char ans[81], filename[81];
  FILE *f;
  long j, i;
  Char *TEMP;
  long FORLIM, FORLIM1;

  f = NULL;
  V.ch1x = (double *)Malloc(sizeof(mam_vectorarray));
  V.ch1y = (double *)Malloc(sizeof(mam_vectorarray));
  V.ch2x = (double *)Malloc(sizeof(mam_vectorarray));
  V.ch2y = (double *)Malloc(sizeof(mam_vectorarray));
  /*  convert_traces(ch1x,ch1y,ch2x,ch2y,points,numTraces);   DEATH -- MAS  */
  printf("points%12ld\n", V.points);
  /*get labels for plots*/
  if (V.numTraces >= 1) {
    printf("enter label for first y axis\n");
    fgets(V.ylabel[0], 81, stdin);
    TEMP = strchr(V.ylabel[0], '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    if (V.numTraces >= 2) {
      printf("enter label for second y axis\n");
      fgets(V.ylabel[1], 81, stdin);
      TEMP = strchr(V.ylabel[1], '\n');
      if (TEMP != NULL)
	*TEMP = 0;
    }
    mam_init_screen();
    plotit(&V);
  }

  /*   writeln('plot this data ? ');
     readln(ans);
     if (ans[1] = 'y') or (ans[1] = 'Y') then begin
       writeln('plot commands to file or plotter?');
       writeln('f=file and p=plotter');
       readln(ans);
       if (ans[1] = 'f') or (ans[1] = 'F') then begin
          writeln('file for output?');
          readln(filename);
          mam_init_file(filename);
       end
       else
         mam_init_plotter;
       plotit;
     end;
  */
  printf("write this data to a file?\n");
  fgets(ans, 81, stdin);
  TEMP = strchr(ans, '\n');
  if (TEMP != NULL)
    *TEMP = 0;
  if (ans[0] == 'y' || ans[0] == 'Y') {
    printf("please enter filename for saved data\n");
    fgets(filename, 81, stdin);
    TEMP = strchr(filename, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    if (f != NULL)
      f = freopen(filename, "w", f);
    else
      f = fopen(filename, "w");
    if (f == NULL)
      _EscIO(FileNotFound);
    FORLIM = V.numTraces;
    for (j = 1; j <= FORLIM; j++) {
      fprintf(f, "\nTIME\n");
      fprintf(f, "%s\n", V.ylabel[j - 1]);
      fprintf(f, "%12ld\n", V.points);
      FORLIM1 = V.points;
      for (i = 1; i <= FORLIM1; i++) {
	if (j == 1)
	  fprintf(f, "% .5E  % .5E\n", V.ch1x[i - 1], V.ch1y[i - 1]);
	else
	  fprintf(f, "% .5E   % .5E\n", V.ch2x[i - 1], V.ch2y[i - 1]);
      }
    }
    if (f != NULL)
      fclose(f);
    f = NULL;
  }
  if (f != NULL)
    fclose(f);
}


Static Void edit(i, s)
long *i;
Char *s;
{
  long x, y;
  boolean quit;
  Char c;

  printf("%s: ", s);
  nk_getxy(&x, &y);
  printf("%12ld", *i);
  c = nk_getkey();
  quit = false;
  while (!quit) {
    nk_gotoxy((int)x, (int)y);
    printf("               ");
    switch (c) {

    case '\b':
      (*i)++;
      break;

    case '\034':
      (*i)--;
      break;

    default:
      quit = true;
      break;
    }
    nk_gotoxy((int)x, (int)y);
    printf("%12ld", *i);
    if (!quit)
      c = nk_getkey();
  }
  if (!(c == '-' || isdigit(c))) {
    putchar('\n');
    return;
  }
  nk_gotoxy((int)x, (int)y);
  printf("               ");
  nk_gotoxy((int)x, (int)y);
  nk_ungetkey(c);
  scanf("%ld%*[^\n]", i);
  getchar();
}


main(argc, argv)
int argc;
Char *argv[];
{
  Char *TEMP;

  PASCAL_MAIN(argc, argv);
  printf("This program captures data from the Tektronix 2430 Digital Oscilloscope.\n");
  printf("This data can be stored in a trace file for later use.  Trace data from\n");
  printf("either of these two sources can be displayed on the screen, plotted on\n");
  printf("a pen plotter, sent as postscript to the apple laserwriter or converted\n");
  printf(
    "to till format for graphical editing.  Also can be sent through Maryann's\n");
  printf(
    "plotting package and/or saved in her format.  To plot several traces on top\n");
  printf(
    "of one another use the N command to put the current trace(s) into the append\n");
  printf(
    "buffer.  C command clears the append buffer.  Displays and plots show both\n");
  printf(
    "the current and appended traces.  G toggles the display of the graticule.\n");
  printf(
    "                                               Report bugs to John Tanner.\n\n");
  quit = false;
  reset_tek2430();
  init_tek2430();
  while (!quit) {
    printf("Command [Oscope Read Edit Screen Write Apple Ff\n");
    printf("           Plot MaryAnn appeNd Clear Graticule View Quit]: ");
    command = getchar();
    if (command == '\n')
      command = ' ';
    putchar('\n');
    switch (command) {

    case 'O':
    case 'o':
      printf("Enter label for these traces:\n");
      gets(labl);
      printf("Capturing trace data from Oscope.\n");
      capture_traces_from_scope(labl);
      break;

    case 'R':
    case 'r':
      printf("Filename: ");
      fgets(fname, 81, stdin);
      TEMP = strchr(fname, '\n');
      if (TEMP != NULL)
	*TEMP = 0;
      printf("Reading trace data from file: %s\n", fname);
      read_traces_from_file(fname);
      break;

    case 'E':
    case 'e':
      get_trace_params(&cp1, &y1_, &cp2, &y2);
      edit(&cp1, "Trace 1:  Center point   ");
      edit(&y1_, "          Vertical offset");
      edit(&cp2, "Trace 2:  Center point   ");
      edit(&y2, "          Vertical offset");
      set_trace_params(cp1, y1_, cp2, y2);
      break;

    case 'S':
    case 's':
      printf("Displaying trace data to screen.\n");
      display_traces_to_screen();
      break;

    case 'W':
    case 'w':
      printf("Filename: ");
      fgets(fname, 81, stdin);
      TEMP = strchr(fname, '\n');
      if (TEMP != NULL)
	*TEMP = 0;
      printf("Writing trace data to file: %s\n", fname);
      write_traces_to_file(fname);
      break;

    case 'A':
    case 'a':
      printf("Filename [/spool/apple.data/tek2430.ps]: ");
      fgets(fname, 81, stdin);
      TEMP = strchr(fname, '\n');
      if (TEMP != NULL)
	*TEMP = 0;
      if (*fname == '\0')
	strcpy(fname, "/spool/apple.data/tek2430.ps");
      printf("Writing PostScipt to file: %s\n", fname);
      write_traces_to_ps_file(fname);
      break;

    case 'F':
    case 'f':
      printf("Filename: ");
      fgets(fname, 81, stdin);
      TEMP = strchr(fname, '\n');
      if (TEMP != NULL)
	*TEMP = 0;
      printf("Writing Till format (.ff) to file: %s\n", fname);
      write_traces_to_ff_file(fname);
      break;

    case 'P':
    case 'p':
      printf("Plotting trace data.\n");
      display_traces_to_plotter();
      break;

    case 'N':
    case 'n':
      printf("Adding the current trace to the append buffer.\n");
      append_traces();
      break;

    case 'C':
    case 'c':
      printf("Clearing appended traces.\n");
      clear_appends();
      break;

    case 'M':
    case 'm':
      maryanns_plot_stuff();
      break;

    /*                     'M','m': writeln('This command has been disabled for your protection.');*/
    case 'G':
    case 'g':
      toggle_display_graticule();
      break;

    case 'V':
    case 'v':
      printf("Filename: ");
      fgets(fname, 81, stdin);
      TEMP = strchr(fname, '\n');
      if (TEMP != NULL)
	*TEMP = 0;
      printf("Writing View format to file: %s\n", fname);
      write_traces_to_view_file(fname);
      break;

    case 'Q':
    case 'q':
      quit = true;
      break;

    default:
      printf("Invalid Command\n");
      break;
    }
  }
  exit(EXIT_SUCCESS);
}




/* End. */
