
/* "VIEW", a data viewing program,
   Copyright (C) 1987, 1990 California Institute of Technology.
   Original authors: Dave Gillespie, port by Rick Koshi
   Unix Port Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, Feb 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* From input file "viewfuncs.text" */


/* The View program
   by Dave Gillespie
 */



/*caged_date='I{ Last edit by $U on $X $]'*/
/* Last edit by dave on Feb 12, 1988 3:18 pm */
/* Last edit by dave on Jan 21, 1988 12:02 am */
/* Last edit by dave on Jan 20, 1988 11:56 pm */
/* Last edit by dave on Jan 20, 1988 11:20 pm */








#include <sys/types.h>
#include <sys/stat.h>

#include "global.h"


#define VIEWFUNCS_G
#include "viewfuncs.h"



#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif

#ifndef SYSDEVS_H
#include <p2c/sysdevs.h>
#endif

/*homeless orphans*/

#ifndef MISC_H
#include <p2c/misc.h>
#endif

#ifndef FILEPACK_H
#include <p2c/filepack.h>
#endif

#ifndef NUMEX_H
#include <p2c/numex.h>
#endif

#ifndef NEWASM_H
#include <p2c/newasm.h>
#endif

#ifndef MATH_H
#include <p2c/math.h>
#endif

#ifndef MYLIB_H
#include <p2c/mylib.h>
#endif

#ifndef NEWCRT_H
#include <p2c/newcrt.h>
#endif

#ifndef NEWCI_H
#include <p2c/newci.h>
#endif

#ifndef LUNIX_PAS_H
#include <p2c/lunix_pas.h>
#endif

/*for datetoint*/

#ifndef VIEWMOD_H
#include "viewmod.h"
#endif

#ifndef VIEWCONF_H
#include "viewconf.h"
#endif



/*$if v_hasdebug$
   $debug$
$end$*/




/* Basic math */

Static Void truncproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_rtrunc(ne_reval(nex->UU.U10.p1));
}


Static Void roundproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_rround(ne_reval(nex->UU.U10.p1));
}


Static Void ceilproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_rceil(ne_reval(nex->UU.U10.p1));
}


Static Void floorproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_rfloor(ne_reval(nex->UU.U10.p1));
}


Static Void absproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = fabs(ne_reval(nex->UU.U10.p1));
}


Static Void sgnproc(nex, res)
ne_nexrec *nex;
double *res;
{
  if (nex->nargs == 1)
    *res = ma_sgn(ne_reval(nex->UU.U10.p1));
  else
    *res = ma_sgn2(ne_reval(nex->UU.U10.p1), ne_reval(nex->UU.U10.p2));
}


Static Void sqrproc(nex, res)
ne_nexrec *nex;
double *res;
{
  double TEMP;

  TEMP = ne_reval(nex->UU.U10.p1);
  *res = TEMP * TEMP;
}


Static Void sqrtproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = sqrt((double)(ne_reval(nex->UU.U10.p1)));
}


Static Void gammaproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_rgamma(ne_reval(nex->UU.U10.p1));
}


Static Void bincoefproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_rbincoef((long)floor(ne_reval(nex->UU.U10.p1) + 0.5),
		     (long)floor(ne_reval(nex->UU.U10.p2) + 0.5));
}


Static Void expproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = exp(ne_reval(nex->UU.U10.p1));
}


Static Void lnproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = log(ne_reval(nex->UU.U10.p1));
}


Static Void logproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_log(ne_reval(nex->UU.U10.p1));
}


Static Void minproc(nex, res)
ne_nexrec *nex;
double *res;
{
  long i, FORLIM;

  *res = ne_reval(nex->UU.U10.p1);
  FORLIM = nex->nargs;
  for (i = 1; i < FORLIM; i++)
    ma_amin(res, ne_reval(nex->UU.U99.pvals[i]));
}


Static Void maxproc(nex, res)
ne_nexrec *nex;
double *res;
{
  long i, FORLIM;

  *res = ne_reval(nex->UU.U10.p1);
  FORLIM = nex->nargs;
  for (i = 1; i < FORLIM; i++)
    ma_amax(res, ne_reval(nex->UU.U99.pvals[i]));
}


Static Void sinproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = sin(ne_reval(nex->UU.U10.p1));
}


Static Void cosproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = cos(ne_reval(nex->UU.U10.p1));
}


Static Void tanproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_tan(ne_reval(nex->UU.U10.p1));
}


Static Void arcsinproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_arcsin(ne_reval(nex->UU.U10.p1));
}


Static Void arccosproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_arccos(ne_reval(nex->UU.U10.p1));
}


Static Void arctanproc(nex, res)
ne_nexrec *nex;
double *res;
{
  if (nex->nargs == 1)
    *res = atan(ne_reval(nex->UU.U10.p1));
  else
    *res = ma_arctan2(ne_reval(nex->UU.U10.p1), ne_reval(nex->UU.U10.p2));
}


Static Void sindproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_sind(ne_reval(nex->UU.U10.p1));
}


Static Void cosdproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_cosd(ne_reval(nex->UU.U10.p1));
}


Static Void tandproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_tand(ne_reval(nex->UU.U10.p1));
}


Static Void arcsindproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_arcsind(ne_reval(nex->UU.U10.p1));
}


Static Void arccosdproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_arccosd(ne_reval(nex->UU.U10.p1));
}


Static Void arctandproc(nex, res)
ne_nexrec *nex;
double *res;
{
  if (nex->nargs == 1)
    *res = ma_arctand(ne_reval(nex->UU.U10.p1));
  else
    *res = ma_arctand2(ne_reval(nex->UU.U10.p1), ne_reval(nex->UU.U10.p2));
}


Static Void sinhproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = sin(ne_reval(nex->UU.U10.p1));
}


Static Void coshproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_cosh(ne_reval(nex->UU.U10.p1));
}


Static Void tanhproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_tanh(ne_reval(nex->UU.U10.p1));
}


Static Void arcsinhproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_arcsinh(ne_reval(nex->UU.U10.p1));
}


Static Void arccoshproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_arccosh(ne_reval(nex->UU.U10.p1));
}


Static Void arctanhproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ma_arctanh(ne_reval(nex->UU.U10.p1));
}




/* Random numbers */

Static Void v_setuprand()
{
  if (v_p_seed->val.U1.i1 != 0) {
    ma_seedrandom(&v_randseed, v_p_seed->val.U1.i1);
    v_p_seed->val.U1.i1 = 0;
  }
}


Static Void irandproc(nex, res)
ne_nexrec *nex;
double *res;
{
  v_setuprand();
  switch (nex->nargs) {

  case 1:
    *res = ma_irandom(v_randseed, 0L,
		      (long)floor(ne_reval(nex->UU.U10.p1) + 0.5) - 1);
    break;

  case 2:
    *res = ma_irandom(v_randseed, (long)floor(ne_reval(nex->UU.U10.p1) + 0.5),
		      (long)floor(ne_reval(nex->UU.U10.p2) + 0.5));
    break;
  }
}


Static Void randproc(nex, res)
ne_nexrec *nex;
double *res;
{
  v_setuprand();
  switch (nex->nargs) {

  case 0:
    *res = ma_urandom(v_randseed);
    break;

  case 1:
    *res = ma_rrandom(v_randseed, 0.0, ne_reval(nex->UU.U10.p1));
    break;

  case 2:
    *res = ma_rrandom(v_randseed, ne_reval(nex->UU.U10.p1),
		      ne_reval(nex->UU.U10.p2));
    break;
  }
}


Static Void nrandproc(nex, res)
ne_nexrec *nex;
double *res;
{
  v_setuprand();
  switch (nex->nargs) {

  case 0:
    *res = ma_nrandom(v_randseed, 0.0, 1.0);
    break;

  case 1:
    *res = ma_nrandom(v_randseed, 0.0, ne_reval(nex->UU.U10.p1));
    break;

  case 2:
    *res = ma_nrandom(v_randseed, ne_reval(nex->UU.U10.p1),
		      ne_reval(nex->UU.U10.p2));
    break;
  }
}




/* String functions */

Static Void strsubproc(nex, res)
ne_nexrec *nex;
Char *res;
{
  Char STR1[256];

  ne_seval(res, nex->UU.U10.p1);
  switch (nex->nargs) {

  case 2:
    strcpy(res,
	   strsub(STR1, res,
		  (int)((long)floor(ne_reval(nex->UU.U10.p2) + 0.5)), 1));
    break;

  case 3:
    strcpy(res, strsub(STR1, res,
		       (int)((long)floor(ne_reval(nex->UU.U10.p2) + 0.5)),
		       (int)((long)floor(ne_reval(nex->UU.U10.p3) + 0.5))));
    break;
  }
}


Static Void strpartproc(nex, res)
ne_nexrec *nex;
Char *res;
{
  Char STR1[256];

  ne_seval(res, nex->UU.U10.p1);
  switch (nex->nargs) {

  case 2:
    strcpy(STR1, res + (long)floor(ne_reval(nex->UU.U10.p2) + 0.5) - 1);
    strcpy(res, STR1);
    break;

  case 3:
    strcpy(res, strpart(STR1, res,
			(int)((long)floor(ne_reval(nex->UU.U10.p2) + 0.5)),
			(int)((long)floor(ne_reval(nex->UU.U10.p3) + 0.5))));
    break;
  }
}


Static Void strlenproc(nex, res)
ne_nexrec *nex;
double *res;
{
  Char STR1[256];

  *res = strlen(ne_seval(STR1, nex->UU.U10.p1));
}




/* Condition functions (now obsolete) */

/* syntax:  if(c,then(t,e))  =>  (c) ? (t) : (e) */
Static Void ifproc(nex, res)
ne_nexrec *nex;
double *res;
{
  if ((ne_opkind)nex->UU.U10.p2->op != ne_rf ||
      strcmp(nex->UU.U10.p2->UU.U15.fps->s, "then") ||
      nex->UU.U10.p2->nargs != 2) {
    *res = 0.0;
    return;
  }
  if (ne_reval(nex->UU.U10.p1) == 0.0)
    *res = ne_reval(nex->UU.U10.p2->UU.U10.p2);
  else
    *res = ne_reval(nex->UU.U10.p2->UU.U10.p1);
}


/* syntax:  then(a,b)  =>  (a) ? (a) : (b) */
Static Void thenproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = ne_reval(nex->UU.U10.p1);
  if (*res == 0.0)
    *res = ne_reval(nex->UU.U10.p2);
}




/* Miscellaneous functions */

Static Void paramproc(nex, res)
ne_nexrec *nex;
Char *res;
{
  Char STR2[256];

  v_getstrparam(res, v_findparam(ne_seval(STR2, nex->UU.U10.p1)));
}



Static Void fexistsproc(nex, res)
ne_nexrec *nex;
double *res;
{
  Char STR1[256];

  *res = (access(ne_seval(STR1, nex->UU.U10.p1), F_OK) == 0);
}



Static Void fdateproc(nex, res)
ne_nexrec *nex;
double *res;
{
  struct stat st_buf;
  Char STR1[256];

  v_closelog();
  if (stat(ne_seval(STR1, nex->UU.U10.p1), &st_buf))
    *res = 0.0;
  else
    *res = st_buf.st_mtime;
}

Static Void curdateproc(nex, res)
ne_nexrec *nex;
double *res;
{
  *res = newci_fullseconds();
}





/* Command to list all available functions */

Static Void dolfuncs(buf)
Char *buf;
{
  v_listfuncs(buf);
}







Void viewfuncs_viewbuiltin()
{
  na_strlist *l1;
  _PROCEDURE TEMP;

  TEMP.proc = (Anyptr)roundproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("round", TEMP);
  v_staticfunc();
  v_addhelp("round(x)");
  v_addhelp("  Return a number rounded to the nearest integer value.");
  TEMP.proc = (Anyptr)truncproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("trunc", TEMP);
  v_staticfunc();
  v_addhelp("trunc(x)");
  v_addhelp("  Return a number truncated toward zero to an integer value.");
  TEMP.proc = (Anyptr)ceilproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("ceil", TEMP);
  v_staticfunc();
  v_addhelp("ceil(x)");
  v_addhelp("  Return a number rounded up to an integer value.");
  TEMP.proc = (Anyptr)floorproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("floor", TEMP);
  v_staticfunc();
  v_addhelp("floor(x)");
  v_addhelp("  Return a number rounded down to an integer value.");
  TEMP.proc = (Anyptr)absproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("abs", TEMP);
  v_staticfunc();
  v_addhelp("abs(x)");
  v_addhelp("  Return the absolute value of a number.");
  TEMP.proc = (Anyptr)sgnproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunco2("sgn", TEMP);
  v_staticfunc();
  v_addhelp("sgn(x)");
  v_addhelp("sgn(x,y)");
  v_addhelp("  The first form returns -1, 1, or 0, according to the sign of x.");
  v_addhelp("  The second form returns X, with its sign changed to that of Y.");
  v_addhelp("  The sign of X is ignored.  If Y = 0, the result is zero.");
  TEMP.proc = (Anyptr)lnproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("ln", TEMP);
  v_staticfunc();
  v_addhelp("ln(x)");
  v_addhelp("  Return the natural logarithm of a number.");
  TEMP.proc = (Anyptr)logproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("log", TEMP);
  v_staticfunc();
  v_addhelp("log(x)");
  v_addhelp("  Return the base-10 logarithm of a number.");
  TEMP.proc = (Anyptr)expproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("exp", TEMP);
  v_staticfunc();
  v_addhelp("exp(x)");
  v_addhelp("  Return E raised to the power of a number.");
  TEMP.proc = (Anyptr)sqrproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("sqr", TEMP);
  v_staticfunc();
  v_addhelp("sqr(x)");
  v_addhelp("  Return the square of a number.");
  TEMP.proc = (Anyptr)sqrtproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("sqrt", TEMP);
  v_staticfunc();
  v_addhelp("sqrt(x)");
  v_addhelp("  Return the square root of a number.");
  TEMP.proc = (Anyptr)gammaproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("gamma", TEMP);
  v_staticfunc();
  v_addhelp("gamma(x)");
  v_addhelp("  Return the gamma function of a number.");
  v_addhelp("  For integer I, gamma(I+1) = factorial of I.");
  TEMP.proc = (Anyptr)bincoefproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc2("bincoef", TEMP);
  v_staticfunc();
  v_addhelp("bincoef(a,b)");
  v_addhelp("  Return the binary coefficient of two numbers.");
  v_addhelp("  A must be greater than or equal to B.");
  TEMP.proc = (Anyptr)sinproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("sin", TEMP);
  v_staticfunc();
  v_addhelp("sin(x)");
  v_addhelp("  Return the sine of an angle in radians.");
  TEMP.proc = (Anyptr)cosproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("cos", TEMP);
  v_staticfunc();
  v_addhelp("cos(x)");
  v_addhelp("  Return the cosine of an angle in radians.");
  TEMP.proc = (Anyptr)tanproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("tan", TEMP);
  v_staticfunc();
  v_addhelp("tan(x)");
  v_addhelp("  Return the tangent of an angle in radians.");
  TEMP.proc = (Anyptr)arcsinproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("arcsin", TEMP);
  v_staticfunc();
  v_addhelp("arcsin(x)");
  v_addhelp("  Return the inverse sine of an angle, in radians.");
  v_addhelp("  Result is in the range (-pi,pi].");
  TEMP.proc = (Anyptr)arccosproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("arccos", TEMP);
  v_staticfunc();
  v_addhelp("arccos(x)");
  v_addhelp("  Return the inverse cosine of an angle, in radians.");
  v_addhelp("  Result is in the range (-pi,pi].");
  TEMP.proc = (Anyptr)arctanproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunco2("arctan", TEMP);
  v_staticfunc();
  v_addhelp("arctan(x)");
  v_addhelp("arctan(y,x)");
  v_addhelp("  Return the inverse tangent of an angle, in radians.");
  v_addhelp("  Result is in the range (-pi/2,pi/2].");
  v_addhelp("  The second form returns arctan of y/x, in the range (-pi,pi].");
  TEMP.proc = (Anyptr)sindproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("sind", TEMP);
  v_staticfunc();
  v_addhelp("sind(x)");
  v_addhelp("  Return the sine of an angle in degrees.");
  TEMP.proc = (Anyptr)cosdproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("cosd", TEMP);
  v_staticfunc();
  v_addhelp("cosd(x)");
  v_addhelp("  Return the cosine of an angle in degrees.");
  TEMP.proc = (Anyptr)tandproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("tand", TEMP);
  v_staticfunc();
  v_addhelp("tand(x)");
  v_addhelp("  Return the tangent of an angle in degrees.");
  TEMP.proc = (Anyptr)arcsindproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("arcsind", TEMP);
  v_staticfunc();
  v_addhelp("arcsind(x)");
  v_addhelp("  Return the inverse sine of an angle, in degrees.");
  v_addhelp("  Result is in the range (-180,180].");
  TEMP.proc = (Anyptr)arccosdproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("arccosd", TEMP);
  v_staticfunc();
  v_addhelp("arccosd(x)");
  v_addhelp("  Return the inverse cosine of an angle, in degrees.");
  v_addhelp("  Result is in the range (-180,180].");
  TEMP.proc = (Anyptr)arctandproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunco2("arctand", TEMP);
  v_staticfunc();
  v_addhelp("arctand(x)");
  v_addhelp("arctand(y,x)");
  v_addhelp("  Return the inverse tangent of an angle, in degrees.");
  v_addhelp("  Result is in the range (-90,90].");
  v_addhelp("  The second form returns arctand of y/x, in the range (-180,180].");
  TEMP.proc = (Anyptr)sinhproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("sinh", TEMP);
  v_staticfunc();
  v_addhelp("sinh(x)");
  v_addhelp("  Return the hyperbolic sine of a number.");
  TEMP.proc = (Anyptr)coshproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("cosh", TEMP);
  v_staticfunc();
  v_addhelp("cosh(x)");
  v_addhelp("  Return the hyperbolic cosine of a number.");
  TEMP.proc = (Anyptr)tanhproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("tanh", TEMP);
  v_staticfunc();
  v_addhelp("tanh(x)");
  v_addhelp("  Return the hyperbolic tangent of a number.");
  TEMP.proc = (Anyptr)arcsinhproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("arcsinh", TEMP);
  v_staticfunc();
  v_addhelp("arcsinh(x)");
  v_addhelp("  Return the inverse hyperbolic sine of a number.");
  TEMP.proc = (Anyptr)arccoshproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("arccosh", TEMP);
  v_staticfunc();
  v_addhelp("arccosh(x)");
  v_addhelp("  Return the inverse hyperbolic cosine of a number.");
  TEMP.proc = (Anyptr)arctanhproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc("arctanh", TEMP);
  v_staticfunc();
  v_addhelp("arctanh(x)");
  v_addhelp("  Return the inverse hyperbolic tangent of a number.");
  TEMP.proc = (Anyptr)minproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc2("min", TEMP);
  v_staticfunc();
  v_setmaxargs(255L);
  v_addhelp("min(a,b,...)");
  v_addhelp("  Return the minimum of two or more numbers.");
  TEMP.proc = (Anyptr)maxproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc2("max", TEMP);
  v_staticfunc();
  v_setmaxargs(255L);
  v_addhelp("max(a,b,...)");
  v_addhelp("  Return the maximum of two or more numbers.");

  TEMP.proc = (Anyptr)irandproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunco2("irand", TEMP);
  v_addhelp("irand(n)");
  v_addhelp("irand(min,max)");
  v_addhelp("  Return a random integer between 0 and N-1, or between");
  v_addhelp("  MIN and MAX.");
  TEMP.proc = (Anyptr)randproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc2("rand", TEMP);
  v_setminargs(0L);
  v_addhelp("rand");
  v_addhelp("rand(max)");
  v_addhelp("rand(min,max)");
  v_addhelp("  Return a random real number between 0 and 1, 0 and MAX,");
  v_addhelp("  or MIN and MAX.");
  TEMP.proc = (Anyptr)nrandproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc2("nrand", TEMP);
  v_setminargs(0L);
  v_addhelp("nrand");
  v_addhelp("nrand(sdev)");
  v_addhelp("nrand(mean,sdev)");
  v_addhelp("  Return a random real number normally distributed with the");
  v_addhelp("  specified mean (default 0) and standard deviation (default 1).");

  TEMP.proc = (Anyptr)strlenproc;
  TEMP.link = (Anyptr)NULL;
  v_realfuncgen("strlen", ne_string, ne_notype, TEMP);
  v_addhelp("strlen(s)");
  v_addhelp("  Return the length of the string argument S.");
  TEMP.proc = (Anyptr)strsubproc;
  TEMP.link = (Anyptr)NULL;
  v_strfuncgen3("strsub", ne_string, ne_real, ne_real, TEMP);
  v_staticfunc();
  v_setminargs(2L);
  v_addhelp("strsub(s,first)");
  v_addhelp("strsub(s,first,size)");
  v_addhelp("  Return the SIZE characters starting at position FIRST");
  v_addhelp("  of string S.  The first character has an index of one.");
  v_addhelp("  Default SIZE is one.");
  TEMP.proc = (Anyptr)strpartproc;
  TEMP.link = (Anyptr)NULL;
  v_strfuncgen3("strpart", ne_string, ne_real, ne_real, TEMP);
  v_staticfunc();
  v_setminargs(2L);
  v_addhelp("strpart(s,first)");
  v_addhelp("strpart(s,first,last)");
  v_addhelp("  Return the characters starting from positions FIRST to");
  v_addhelp("  LAST of string S.  The first character has an index of");
  v_addhelp("  one.  Default LAST is the length of the string.");

  TEMP.proc = (Anyptr)ifproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc2("if", TEMP);
  v_addhelp("if(cond,then(thenexpr,elseexpr))");
  v_addhelp("  Obsolete; equivalent to (COND?THENEXPR:ELSEEXPR).");
  TEMP.proc = (Anyptr)thenproc;
  TEMP.link = (Anyptr)NULL;
  v_realfunc2("then", TEMP);
  v_addhelp("then(a,b)");
  v_addhelp("  Obsolete; equivalent to (A||B).");

  TEMP.proc = (Anyptr)paramproc;
  TEMP.link = (Anyptr)NULL;
  v_strfuncgen("param", ne_string, ne_notype, TEMP);
  v_addhelp("param(name)");
  v_addhelp("  Return the value of parameter NAME, formatted as a string.");
  TEMP.proc = (Anyptr)fexistsproc;
  TEMP.link = (Anyptr)NULL;
  v_realfuncgen("fexists", ne_string, ne_notype, TEMP);
  v_addhelp("fexists(fname)");
  v_addhelp("  Return 1 if the named file exists, 0 otherwise.");


  TEMP.proc = (Anyptr)fdateproc;
  TEMP.link = (Anyptr)NULL;
  v_realfuncgen("fdate", ne_string, ne_notype, TEMP);
  v_addhelp("fdate(fname)");
  v_addhelp("  Return the last-modified date of the named file in");
  v_addhelp("  seconds since 1-Jan-1970, or 0 if file doesn't exist.");
  v_addhelp("  Note that since the file server has an independent clock,");
  v_addhelp("  modification dates can be slightly larger than the \"current\"");
  v_addhelp("  time!");
  TEMP.proc = (Anyptr)curdateproc;
  TEMP.link = (Anyptr)NULL;
  v_realfuncgen("curdate", ne_notype, ne_notype, TEMP);
  v_addhelp("curdate");
  v_addhelp("  Return the current date and time in seconds since");
  v_addhelp("  1-Jan-1970.");

  v_addfuncname("pi", &l1);
  ne_makerealconst(l1, ma_pi);

  TEMP.proc = (Anyptr)dolfuncs;
  TEMP.link = (Anyptr)NULL;
  v_addcmd("lfuncs", TEMP, "", "");
  v_addhelp("lfuncs");
  v_addhelp("lfuncs <function>");
  v_addhelp("  Print a list of all functions allowed in expressions,");
  v_addhelp("  or a listing of a particular function.");

}








/*viewfuncs*/






/* End. */
