
/* "VIEW", a data viewing program,
   Copyright (C) 1987, 1990 California Institute of Technology.
   Original authors: Dave Gillespie, port by Rick Koshi
   Unix Port Maintainer: John Lazzaro
   Maintainers's address: lazzaro@hobiecat.cs.caltech.edu;
                          CB 425/ CU Boulder/Boulder CO 91125. 


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (Version 1, Feb 1989).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Output from p2c, the Pascal-to-C translator */
/* From input file "viewmain.text" */


/* The View program
   by Dave Gillespie
 */



/*caged_date='I{ Last edit by $U on $X $]'*/
/* Last edit by dave on Jun 6, 1988 8:16 pm */
/* Last edit by dave on Feb 15, 1988 3:42 pm */
/* Last edit by dave on Feb 15, 1988 2:04 pm */
/* Last edit by dave on Feb 15, 1988 1:53 pm */
/* Last edit by dave on Jan 20, 1988 3:20 am */
/* Last edit by dave on Jan 20, 1988 12:47 am */
/* Last edit by dave on Nov 24, 1987 9:56 pm */
/* Last edit by dave on Nov 24, 1987 9:36 pm */
/* Last edit by dave on Nov 9, 1987 11:00 pm */
/* Last edit by dave on Nov 9, 1987 5:36 pm */
/* Last edit by dave on Nov 9, 1987 3:35 pm */
/* Last edit by dave on Nov 9, 1987 3:23 pm */
/* Last edit by dave on Nov 9, 1987 3:22 pm */
/* Last edit by dave on Nov 9, 1987 2:26 pm */
/* Last edit by dave on Oct 21, 1987 5:09 pm */
/* Last edit by dave on Oct 20, 1987 10:28 pm */
/* Last edit by dave on Oct 19, 1987 9:41 am */







#include "global.h"


#ifndef NEWASM_H
#include <p2c/newasm.h>
#endif

#ifndef NEWCI_H
#include <p2c/newci.h>
#endif

#ifndef NEWKBD_H
#include <p2c/newkbd.h>
#endif

#ifndef SYSDEVS_H
#include <p2c/sysdevs.h>
#endif

#ifndef SYSGLOBALS_H
#include <p2c/sysglobals.h>
#endif


#ifndef VIEWMOD_H
#include "viewmod.h"
#endif

#ifndef VIEWCONF_H
#include "viewconf.h"
#endif

#include <signal.h>


/*$if v_hasdebug$
   $debug$
$end$*/



Static Void usage()
{
  fprintf(stderr,
	  "usage: view  [[-u toolfile] ...]  [-s cmdfile]  [datafile ...]\n");
}


#define cnffilename     "view.cnf"
#define deflogfile      "view.log"


/* Local variables for main_: */
struct LOC_main_ {
  _PROCEDURE savepreshesc, savepostshesc;
  long runkeynum;
  nk_userkeyrec runkeyrec;
} ;

Local Void runkeyproc(ukrp, LINK)
nk_userkeyrec *ukrp;
struct LOC_main_ *LINK;
{
  if (v_takeoveraction.link != NULL)
    (*(Void(*) PP((Anyptr _link)))v_takeoveraction.proc)(v_takeoveraction.link);
  else
    (*(Void(*) PV())v_takeoveraction.proc)();
}

Local Void mypreshesc(LINK)
struct LOC_main_ *LINK;
{
/*  nk_deluserkey(&LINK->runkeyrec);*/
  if (LINK->savepreshesc.link != NULL)
    (*(Void(*) PP((Anyptr _link)))LINK->savepreshesc.proc)(LINK->savepreshesc.link);
  else
    (*(Void(*) PV())LINK->savepreshesc.proc)();
}

Local Void mypostshesc(LINK)
struct LOC_main_ *LINK;
{
  _PROCEDURE TEMP;

  TEMP.proc = (Anyptr)runkeyproc;
  TEMP.link = (Anyptr)LINK;
/*  nk_adduserkey(false, (int)LINK->runkeynum, 0, TEMP, &LINK->runkeyrec);*/
  if (LINK->savepostshesc.link != NULL)
    (*(Void(*) PP((Anyptr _link)))LINK->savepostshesc.proc)(
      LINK->savepostshesc.link);
  else
    (*(Void(*) PV())LINK->savepostshesc.proc)();
}

Local void handler(sig, code, scp, addr)
int sig, code;
struct sigcontext *scp;
char *addr;

{
signal(SIGINT, handler);
_Escape((int)(-20));
}


Static Void main_()
{
  struct LOC_main_ V;
  long i, j, nargs, markid;
  Char buf[256], wrd[256], sourcefile[256], logfile[256];
  na_strlist *usefiles, *loadfiles, *args, *l1;
  boolean done, vanilla, quiet, cflag, nointer;
  Char STR1[20];
  Char STR2[256];
  _PROCEDURE TEMP;

  signal(SIGINT, handler);
  usefiles = NULL;
  loadfiles = NULL;
  args = NULL;
  nargs = 0;
  *sourcefile = '\0';
  strcpy(logfile, deflogfile);
  vanilla = false;
  quiet = false;
  nointer = false;
  cflag = false;
  /* malloc_debug(1); */
  i = 1;
  while (i < P_argc) {
    if (*P_argv[i] == '-') {
      if (!strcmp(P_argv[i], "-u")) {
	i++;
	if (i >= P_argc)
	  usage();
	l1 = strlist_append(&usefiles, P_argv[i]);
      } else if (!strcmp(P_argv[i], "-s")) {
	i++;
	if (i >= P_argc)
	  usage();
	strcpy(sourcefile, P_argv[i]);
      } else if (!strcmp(P_argv[i], "-c")) {
	i++;
	if (i >= P_argc)
	  usage();
	strcpy(buf, P_argv[i]);
	strword(buf, sourcefile);
	l1 = strlist_append(&args, sourcefile);
	if (*buf != '\0') {
	  while (*buf != '\0') {
	    nargs++;
	    strword2(buf, wrd);
	    l1 = strlist_append(&args, wrd);
	  }
	} else {
	  while (i + 1 < P_argc) {
	    i++;
	    nargs++;
	    l1 = strlist_append(&args, P_argv[i]);
	  }
	}
	*logfile = '\0';
	vanilla = true;
	nointer = true;
	cflag = true;
      } else if (!strcmp(P_argv[i], "-l")) {
	i++;
	if (i >= P_argc)
	  usage();
	strcpy(logfile, P_argv[i]);
      } else if (!strcmp(P_argv[i], "-n"))
	*logfile = '\0';
      else if (!strcmp(P_argv[i], "-v"))
	vanilla = true;
      else if (!strcmp(P_argv[i], "-X")) {
	nc_text_in_window = true;
/* p2c: viewmain.text, line 157:
 * Warning: Symbol 'NC_TEXT_IN_WINDOW' is not defined [221] */
      } else if (!strcmp(P_argv[i], "-q"))
	quiet = true;
      else
	usage();
    } else
      l1 = strlist_append(&loadfiles, P_argv[i]);
    i++;
  }
  if (!cflag){
    printf("Data viewer %s\n", v_version);
    printf("Copyright (C) 1987, 1990 California Institute of Technology\n");
    printf("Covered by the GNU Public License, 1989; see file COPYING\n\n");}
  if (*logfile != '\0')
    newci_fixfname(logfile, "log", "");
  newci_markprogram(&markid);
  TRY(try1);
    v_initialize(logfile, quiet);
    V.savepreshesc = v_preshellescape;
    v_preshellescape.proc = (Anyptr)mypreshesc;
    v_preshellescape.link = (Anyptr)&V;
    V.savepostshesc = v_postshellescape;
    v_postshellescape.proc = (Anyptr)mypostshesc;
    v_postshellescape.link = (Anyptr)&V;
    if (KBDTYPE == ITFKBD)   /*chipmunk*/
      V.runkeynum = 10;   /*bobcat*/
    else
      V.runkeynum = 47;
    TEMP.proc = (Anyptr)runkeyproc;
    TEMP.link = (Anyptr)&V;
/*    nk_adduserkey(false, (int)V.runkeynum, 0, TEMP, &V.runkeyrec);*/
    i = 0;
    l1 = args;
    while (l1 != NULL) {
      sprintf(STR2, "arg%ld", i);
      v_assigncurvestr(l1->s, STR2);
      i++;
      l1 = l1->next;
    }
    if (cflag)
      v_assigncurveconst((double)nargs, "argc");
    if (!vanilla) {
      sprintf(STR1, "%s/%s", v_libdir, cnffilename);
      if (!v_sourcefile(STR1, false))   /*write error message if any*/
	v_writeerror();
      if (!v_sourcefile(cnffilename, false))
	v_writeerror();
    }
    v_initdone = true;
    l1 = usefiles;
    while (l1 != NULL) {
      if (v_use(l1->s, "") == 0) {
	v_writeerror();
	printf("[Tool file %s: can't install]\n", l1->s);
      }
      l1 = l1->next;
    }
    l1 = loadfiles;
    while (l1 != NULL) {
      switch (v_loadfile(l1->s)) {

      case 0:
	/* blank case */
	break;

      case 1:
	printf("[File %s not found]\n", l1->s);
	break;

      case 2:
	printf("[File %s: bad format]\n", l1->s);
	break;
      }
      l1 = l1->next;
    }
    if (*sourcefile != '\0') {
      if (!v_pushinput_file(sourcefile, true)) {
	printf("[Can't read file %s]\n", sourcefile);
	*sourcefile = '\0';
      } else if (!v_doinputstream(v_viewprompt)) {
	v_writeerror();
	printf("[Error reading file %s]\n", sourcefile);
	*sourcefile = '\0';
      }
    }
    if (*sourcefile == '\0' && !nointer && !v_exitflag) {
      do {
	v_setup_stdin();
	TRY(try2);
	  v_doinputsession(v_viewprompt);
	  if (v_p_novice->val.U1.i1 != 0 && v_checkneedsave()) {
	    fprintf(stderr, "Do you really want to exit the View system? ");
	    fgets(buf, 256, stdin);
	    done = strcibegins(buf, "y");
	  } else
	    done = true;
	RECOVER(try2);
	  if (P_escapecode == 0)
	    done = false;
	  else if (P_escapecode != -20)
	    goto _Ltry1;
	  else {
	    fprintf(stderr, "[STOP]\n");
	    v_checkneedsave();
	    fprintf(stderr, "Do you really want to exit the View system? ");
	    fgets(buf, 256, stdin);
	    done = strcibegins(buf, "y");
	  }
	ENDTRY(try2);
      } while (!done);
    }
/*    nk_deluserkey(&V.runkeyrec);*/
    v_cleanup();
    newci_releaseprogram(&markid);
  RECOVER2(try1,_Ltry1);
    i = P_escapecode;
    j = P_ioresult;
/*    nk_deluserkey(&V.runkeyrec);*/
    v_cleanup();
    newci_releaseprogram(&markid);
    P_ioresult = j;
    _Escape((int)i);
  ENDTRY(try1);
}  /*main*/

#undef cnffilename
#undef deflogfile


main(argc, argv)
int argc;
Char *argv[];
{
  PASCAL_MAIN(argc, argv);
  main_();
  exit(0);
}








/* End. */
