/* ComparisonDataParseException.java
 *
 * created: Mon Jul 19 1999
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 1999  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/ComparisonDataParseException.java,v 1.1 1999/07/21 13:42:46 kmr Exp $
 */

package diana;

import java.io.IOException;

/**
 *  This exception is thrown if an input file containing comparison data can't
 *  be read.
 *
 *  @author Kim Rutherford
 *  @version $Id: ComparisonDataParseException.java,v 1.1 1999/07/21 13:42:46 kmr Exp $
 **/

public class ComparisonDataParseException extends IOException {
  /**
   *  Create a new ComparisonDataParseException object with the given message.
   **/
  public ComparisonDataParseException (final String message) {
    super (message);
  }
}

