/* MUMmerComparisonData.java
 *
 * created: Thu Jul 15 1999
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 1999,2000  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/MUMmerComparisonData.java,v 1.8 2000/06/05 12:43:26 kmr Exp $
 */

package diana;

import uk.ac.sanger.pathogens.embl.LinePushBackReader;

import java.io.*;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 *  This class implements the ComparisonData interface for MUMmer output.
 *
 *  @author Kim Rutherford
 *  @version $Id: MUMmerComparisonData.java,v 1.8 2000/06/05 12:43:26 kmr Exp $
 **/

public class MUMmerComparisonData extends SimpleComparisonData
    implements ComparisonData {
  /**
   *  Create a new MUMmerComparisonData object by reading from the given
   *  LinePushBackReader.
   **/
  public MUMmerComparisonData (final LinePushBackReader stream)
      throws IOException {

    final Vector align_match_vector = new Vector ();

    while (true) {
      final String line = stream.readLine ();

      if (line == null) {
        break;
      }

      if (line.startsWith (">")) {
        continue;
      }

      final StringTokenizer tokenizer = new StringTokenizer (line, " ");

      if (tokenizer.countTokens () < 3) {
        final String message =
          "unable to understand this line: " + line;
        throw new ComparisonDataParseException (message);
      }
      
      final String first_token = tokenizer.nextToken ();
      final String second_token = tokenizer.nextToken ();
      final String third_token = tokenizer.nextToken ();

      String forth_token = "+";

      if (tokenizer.countTokens () > 0) {
        forth_token = tokenizer.nextToken ();
      }

      try {
        final int first_number = Integer.valueOf (first_token).intValue ();
        final int second_number = Integer.valueOf (second_token).intValue ();
        final int match_length = Integer.valueOf (third_token).intValue ();

//        System.err.println ("token: " + forth_token + "  " + line);

        int score = -1;

        if ((forth_token.equals ("+") || forth_token.equals ("-")) &&
            tokenizer.countTokens () > 0) {
          score = Integer.valueOf (tokenizer.nextToken ()).intValue ();

          if (score < -1) {
            score = -1;
          }
        }

        if (forth_token.equals ("-")) {
          final AlignMatch new_match =
            makeAlignMatch (first_number, first_number + match_length - 1,
                            second_number + match_length - 1, second_number,
                            score);
          align_match_vector.addElement (new_match);
        } else {
          final AlignMatch new_match =
            makeAlignMatch (first_number, first_number + match_length - 1,
                            second_number, second_number + match_length - 1,
                            score);
          align_match_vector.addElement (new_match);
        }
      } catch (NumberFormatException e) {
        throw new IOException ("while reading MUMmer file: failed to " +
                               "parse a number from this string: " +
                               e.getMessage ());
      }
    }

    final AlignMatch [] matches = new AlignMatch [align_match_vector.size ()];

    for (int i = 0 ; i < matches.length ; ++i) {
      matches[i] = (AlignMatch) align_match_vector.elementAt (i);
    }

    setMatches (matches);
  }
}
