/* EnsemblEntrySource.java
 *
 * created: Wed Jun  7 2000
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 2000  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/components/EnsemblEntrySource.java,v 1.1 2000/06/09 15:11:52 kmr Exp $
 */

package diana.components;

import diana.sequence.*;

/**
 *  This is an EntrySource that reads Entry objects from the EnsEMBL CORBA
 *  server.
 *
 *  @author Kim Rutherford <kmr@sanger.ac.uk>
 *  @version $Id: EnsemblEntrySource.java,v 1.1 2000/06/09 15:11:52 kmr Exp $
 **/

public class EnsemblEntrySource {
  /**
   *  Create a new EnsemblEntrySource from the given String.
   *  @param ior_url_string A String containing the URL of the IOR for the
   *    server. 
   **/
  public EnsemblEntrySource (final String ior_url_string) {
    super (ior_url_string);
  }

  /**
   *  Get an Entry object from the EnsEMBL CORBA server.
   *  @param bases The Bases object to pass to the Entry constructor.
   *  @exception OutOfRangeException Thrown if one of the features in 
   *    embl_entry is out of range of the Bases object.
   **/
  public Entry getEntry (final Bases bases)
      throws OutOfRangeException {
XXX    
            getOwner ().makeCorbaDialog (getEntryGroup (),
                                         db_ior_url, false, true);
  }

  /**
   *  Return the name of this source (for display to the user in menus).
   **/
  public String getSourceName () {
    return "EnsEMBL";
  }
  

  /**
   *  Given an accession number and the handle of an EnsEMBL corba server,
   *  this method will ask the user (using a TextRequester) for the id of a
   *  entry in the server and will then attempt to get it.
   *  @param entry_group If this is null a new EntryEdit component will be
   *    created for the entry once it has been read from the server.  If not
   *    null then the new entry will be added to the given EntryGroup.
   *  @param corba_handle The handle of the Ensembl.artemis.DB object from
   *  which we will read the entry.
   *  @param corba_id The id of the entry in the database
   **/
  private void makeFromEnsemblID (final EntryGroup entry_group,
                                  final Ensembl.artemis.DB corba_handle,
                                  final String corba_id) {
    try {

      final Ensembl.artemis.Entry embl_seq =
        corba_handle.getEntry (corba_id);

      final uk.ac.sanger.pathogens.embl.Entry new_embl_entry =
        new uk.ac.sanger.pathogens.embl.EnsemblCorbaEntry (embl_seq);

      final EntryGroup real_entry_group;

      if (entry_group == null) {
        if (new_embl_entry.getSequence () == null) {
          final String message =
            "the entry contains no sequence: " + corba_id;
          getStatusLabel ().setText (message);
          new MessageFrame (message);
          return;
        }

        final Bases embl_bases = new Bases (new_embl_entry.getSequence ());

        real_entry_group = new SimpleEntryGroup (embl_bases);
      } else {
        real_entry_group = entry_group;
      }

      final Entry new_entry =
        new Entry (real_entry_group.getBases (), new_embl_entry);

      real_entry_group.add (new_entry);

      getStatusLabel ().setText ("");

      if (entry_group == null) {
        final EntryEdit entry_edit = makeEntryEdit (real_entry_group);

        entry_edit.setVisible (true);
      }
    } catch (LocationParseException e) {
      final String message =
        "Unexpected error while accessing " + corba_id + ": " + e;
      getStatusLabel ().setText (message);
      new MessageFrame (message);
    } catch (Ensembl.artemis.NoEntry e) {
      final String message =
        "the object you requested (" + corba_id + ") does not exist";
      getStatusLabel ().setText (message);
      new MessageFrame (message);
    } catch (InvalidKeyException e) {
      final String message =
        "Unexpected error while accessing " + corba_id + ": " + e;
      getStatusLabel ().setText (message);
      new MessageFrame (message);
    } catch (org.omg.CORBA.OBJECT_NOT_EXIST e) {
      final String message =
        "the object you requested (" + corba_id + ") does not exist";
      getStatusLabel ().setText (message);
      new MessageFrame (message);
    }
  }

}
