/* TextDialog.java
 *
 * created: Mon Jan 11 1999
 *
 * This file is part of Artemis
 *
 * Copyright (C) 1998,1999,2000  Genome Research Limited
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/components/TextDialog.java,v 1.1 2000/06/12 12:27:36 kmr Exp $
 **/

package diana.components;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

/**
 *  A popup TextField Dialog with an OK and a Cancel button.
 *
 *  @author Kim Rutherford
 *  @version $Id: TextDialog.java,v 1.1 2000/06/12 12:27:36 kmr Exp $
 **/

public class TextDialog extends Dialog {
  /**
   *  Create a new TextDialog component with the given prompt. Other
   *  components can listen for TextDialogEvent object.
   *  @param parent The parent window.
   *  @param prompt A message that is displayed in the component beside the
   *    TextArea that the user types into.  This String is also used as the
   *    Frame title.
   *  @param width The width of the new TextField.
   *  @param initial_text The initial text to put in the TextField.
   **/
  public TextDialog (final Frame parent,
                     final String prompt,
                     final int width,
                     final String initial_text) {
    super (parent, prompt, true);

    add (new Label (prompt), "North");

    final Panel panel = new Panel ();

    panel.add (ok_button);
    ok_button.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        text = text_field.getText ();
        TextDialog.this.dispose ();
      }
    });

    panel.add (cancel_button);
    cancel_button.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        text = null;
        TextDialog.this.dispose ();
      }
    });

    add (panel, "South");

    text_field = new TextField (initial_text, width);

    text_field.addKeyListener (new KeyAdapter () {
      public void keyTyped(final KeyEvent e) {
//    System.out.println ("key:" + e.getKeyChar () + "  " + e.getKeyCode ());


//  disabled because this causes a lockup under jdk1.1
//          if (e.getKeyChar () == '\n') {
//            text = text_field.getText ();
//            text = null;
//          }
      }
    });

    add (text_field, "Center");

    pack ();

    final Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    setLocation (new Point ((screen.width - getSize ().width) / 2,
                            (screen.height - getSize ().height) / 2));
  }

  /**
   *  Wait for a user action then return the text if the user hit OK or null
   *  if the user hit Cancel.
   **/
  public String getText () {
    setVisible (true);

    return text;
  }

  private final Button ok_button = new Button ("OK");
  private final Button cancel_button = new Button ("Cancel");
  private TextField text_field = null;

  /**
   *  Set to null if and only if the user cancels the dialog, otherwise
   *  contains the text that the user entered.
   **/
  private String text = null;
}
