/*
 * Decompiled with CFR 0.152.
 */
package uk.org.skeet.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;

public class IOUtil {
    public static byte[] readFully(String filename) throws IOException {
        return IOUtil.readFully(new FileInputStream(filename));
    }

    public static byte[] readFully(File file) throws IOException {
        return IOUtil.readFully(new FileInputStream(file));
    }

    public static byte[] readFully(InputStream is) throws IOException {
        byte[] tmp;
        int size = 10000;
        int off = 0;
        byte[] ret = new byte[size];
        try {
            int got;
            while ((got = is.read(ret, off, size - off)) != -1) {
                if ((off += got) != size) continue;
                tmp = new byte[size *= 2];
                System.arraycopy(ret, 0, tmp, 0, off);
                ret = tmp;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            IOUtil.close(is);
            throw throwable;
        }
        IOUtil.close(is);
        if (off != size) {
            tmp = new byte[off];
            System.arraycopy(ret, 0, tmp, 0, off);
            ret = tmp;
        }
        return ret;
    }

    public static Vector readText(String filename) throws IOException {
        return IOUtil.readText(new FileReader(filename));
    }

    public static Vector readText(File file) throws IOException {
        return IOUtil.readText(new FileReader(file));
    }

    /*
     * WARNING - void declaration
     */
    public static Vector readText(Reader r) throws IOException {
        Vector<String> vector;
        BufferedReader br = new BufferedReader(r);
        try {
            String line;
            Vector<String> ret = new Vector<String>();
            while ((line = br.readLine()) != null) {
                void var3_3;
                ret.addElement(var3_3.intern());
            }
            vector = ret;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            IOUtil.close(br);
            throw throwable;
        }
        IOUtil.close(br);
        return vector;
    }

    public static void writeText(Vector lines, String filename) throws IOException {
        IOUtil.writeText(lines, new FileWriter(filename));
    }

    public static void writeText(Vector lines, File file) throws IOException {
        IOUtil.writeText(lines, new FileWriter(file));
    }

    public static void writeText(Vector lines, Writer out) throws IOException {
        BufferedWriter bw = new BufferedWriter(out);
        try {
            int l = lines.size();
            int i = 0;
            while (i < l) {
                bw.write((String)lines.elementAt(i));
                bw.newLine();
                ++i;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            IOUtil.close(bw);
            throw throwable;
        }
        IOUtil.close(bw);
    }

    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Reader in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Writer out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

