require "X11/Display"

$d = X11::Display.new
$s = $d.screens[0]
$dp = $s.depths.find {|dp| dp.depth > 1 }

$attribs = X11::WindowAttributes.new(
	:background_pixel => $s.white_pixel,
	:bit_gravity => :Static,
	:event_mask =>
		X11::EventMask.lookup(
			:Exposure, :KeyPress,
			:ButtonPress, :StructureNotify)
	)

$ws = (0...3).map {
	w = X11::Window.new($d)
	w.create_window(
		$dp.depth,
		$s.root,
		X11::Rectangle[X11::Point[0,0],X11::Size[320,240]],
		4, :InputOutput, :CopyFromParent, $attribs)
	w.map
	w
}

while true; $d.xreceive_many; sleep .1; end
