=begin
	Ruby X11 Client Library
	Copyright 2001 by Mathieu Bouchard

	tests/test03.rb: Test for all requests

	$Id: test_all.rb,v 1.3 2001/07/07 21:27:24 matju Exp $

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=end

require "X11/Display"

$d = X11::Display.new

def test(qlass,sym,&proc)
	(($tests||={})[qlass]||={})[sym] = proc
end

test(X11::Display, :list_fonts) {
	fonts, = $d.list_fonts(0xffff,"*")
	fonts.each {|x| p x}
}

$tests[X11::Display][:list_fonts][]

__END__

Requests left to test:

  1 [X11::Window, :create]
  2 [X11::Window, :change_attributes]
  3 [X11::Window, :get_attributes]
  4 [X11::Window, :close]
  5 [X11::Window, :close_subwindows]
  6 [X11::Window, :change_save_set]
  7 [X11::Window, :reparent]
  8 [X11::Window, :map]
  9 [X11::Window, :map_subwindows]
 10 [X11::Window, :unmap]
 11 [X11::Window, :unmap_subwindows]
 12 [X11::Window, :configure]
 13 [X11::Window, :circulate]
 14 [X11::Drawable, :get_geometry]
 15 [X11::Window, :query_tree]
 16 [X11::Display, :intern_atom]
 17 [X11::Display, :get_atom_name]
 18 [X11::Window, :change_property]
 19 [X11::Window, :delete_property]
 20 [X11::Window, :get_property]
 21 [X11::Window, :list_properties]
 22 [X11::Display, :set_selection_owner]
 23 [X11::Display, :get_selection_owner]
 24 [X11::Display, :convert_selection]
 25 [X11::Window, :send_event]
 26 [X11::Window, :grab_pointer]
 27 [X11::Display, :ungrab_pointer]
 28 [X11::Window, :grab_button]
 29 [X11::Display, :ungrab_button]
 30 [X11::Display, :change_active_pointer_grab]
 31 [X11::Window, :grab_keyboard]
 32 [X11::Display, :ungrab_keyboard]
 33 [X11::Window, :grab_key]
 34 [X11::Window, :ungrab_key]
 35 [X11::Display, :allow_events]
 36 [X11::Display, :grab_server]
 37 [X11::Display, :ungrab_server]
 38 [X11::Window, :query_pointer]
 39 [X11::Window, :get_motion_events]
 40 [X11::Window, :translate_coordinates]
 41 [X11::Window, :warp_pointer]
 42 [X11::Window, :set_input_focus]
 43 [X11::Display, :get_input_focus]
 44 [X11::Display, :query_keymap]
 45 [X11::Font, :open]
 46 [X11::Font, :close]
 47 [X11::Font, :query]
 48 [X11::Font, :query_text_extents_16]
 49 [X11::Display, :list_fonts]
 50 [X11::Display, :list_fonts_with_info]
 51 [X11::Display, :set_font_path]
 52 [X11::Display, :get_font_path]
 53 [X11::Pixmap, :create]
 54 [X11::Pixmap, :free]
 55 [X11::Graphics, :create]
 56 [X11::Graphics, :change]
 57 [X11::Graphics, :copy]
 58 [X11::Graphics, :set_dashes]
 59 [X11::Graphics, :set_clip_rectangles]
 60 [X11::Graphics, :free]
 61 [X11::Window, :clear_area]
 62 [X11::Drawable, :copy_area]
 63 [X11::Drawable, :copy_plane]
 64 [X11::GraphicsOnDrawable, :draw_points]
 65 [X11::GraphicsOnDrawable, :draw_lines]
 66 [X11::GraphicsOnDrawable, :draw_segments]
 67 [X11::GraphicsOnDrawable, :draw_rectangles]
 68 [X11::GraphicsOnDrawable, :draw_arcs]
 69 [X11::GraphicsOnDrawable, :fill_polygon]
 70 [X11::GraphicsOnDrawable, :fill_rectangles]
 71 [X11::GraphicsOnDrawable, :fill_arcs]
 72 [X11::GraphicsOnDrawable, :put_image]
 73 [X11::Drawable, :get_image]
 74 [X11::GraphicsOnDrawable, :draw_strings]
 75 [X11::GraphicsOnDrawable, :draw_strings_16]
 76 [X11::GraphicsOnDrawable, :draw_image_string]
 77 [X11::GraphicsOnDrawable, :draw_image_string_16]
 78 [X11::Colormap, :create]
 79 [X11::Colormap, :free]
 80 [X11::Colormap, :copy_and_free]
 81 [X11::Colormap, :install]
 82 [X11::Colormap, :uninstall]
 83 [X11::Window, :list_installed_colormaps]
 84 [X11::Colormap, :alloc_color]
 85 [X11::Colormap, :alloc_named_color]
 86 [X11::Colormap, :alloc_color_cells]
 87 [X11::Colormap, :alloc_color_planes]
 88 [X11::Colormap, :free_colors]
 89 [X11::Colormap, :store_colors]
 90 [X11::Colormap, :store_named_color]
 91 [X11::Colormap, :query_colors]
 92 [X11::Colormap, :lookup_color]
 93 [X11::Cursor, :create]
 94 [X11::Cursor, :create_from_glyph]
 95 [X11::Cursor, :free]
 96 [X11::Cursor, :recolor]
 97 [X11::Drawable, :query_best_size]
 98 [X11::Display, :query_extension]
 99 [X11::Display, :list_extensions]
100 [X11::Display, :change_keyboard_mapping]
101 [X11::Display, :get_keyboard_mapping]
102 [X11::Display, :change_keyboard_control]
103 [X11::Display, :get_keyboard_control]
104 [X11::Display, :bell]
105 [X11::Display, :change_pointer_control]
106 [X11::Display, :get_pointer_control]
107 [X11::Display, :set_screen_saver]
108 [X11::Display, :get_screen_saver]
109 [X11::Display, :change_hosts]
110 [X11::Display, :list_hosts]
111 [X11::Display, :set_access_control]
112 [X11::Display, :set_close_down_mode]
113 [X11::Display, :kill_client]
114 [X11::Window, :rotate_properties]
115 [X11::Display, :force_screen_saver]
116 [X11::Display, :set_pointer_mapping]
117 [X11::Display, :get_pointer_mapping]
118 [X11::Display, :set_modifier_mapping]
119 [X11::Display, :get_modifier_mapping]
127 [X11::Display, :no_operation]

Events left to test:

  2 X11::KeyPressEvent
  3 X11::KeyReleaseEvent
  4 X11::ButtonPressEvent
  5 X11::ButtonReleaseEvent
  6 X11::MotionNotifyEvent
  7 X11::EnterNotifyEvent
  8 X11::LeaveNotifyEvent
  9 X11::FocusInEvent
 10 X11::FocusOutEvent
 11 X11::KeymapNotifyEvent
 12 X11::ExposeEvent
 13 X11::GraphicsExposureEvent
 14 X11::NoExposureEvent
 15 X11::VisibilityNotifyEvent
 16 X11::CreateNotifyEvent
 17 X11::DestroyNotifyEvent
 18 X11::UnmapNotifyEvent
 19 X11::MapNotifyEvent
 20 X11::MapRequestEvent
 21 X11::ReparentNotifyEvent
 22 X11::ConfigureNotifyEvent
 23 X11::ConfigureRequestEvent
 24 X11::GravityNotifyEvent
 25 X11::ResizeRequestEvent
 26 X11::CirculateNotifyEvent
 27 X11::CirculateRequestEvent
 28 X11::PropertyNotifyEvent
 29 X11::SelectionClearEvent
 30 X11::SelectionRequestEvent
 31 X11::SelectionNotifyEvent
 32 X11::ColormapNotifyEvent
 33 X11::ClientMessageEvent
 34 X11::MappingNotifyEvent

Note that there may be other things to test, though the above should
be a mostly sufficient list. (?)

Note: ok, remember to test DisplayInfo, ScreenInfo, etc.

