=begin
	Ruby X11 Client Library
	Copyright 2001 by Mathieu Bouchard

	This file generates a list of all the relevant constants from
	<X11/keysymdef.h> and <X11/cursorfont.h>
	and builds X11/Keysyms.rb with it.

	$Id: Keysyms_lister.rb,v 1.4 2001/06/27 05:16:25 matju Exp $
=end

# By using this filter, my list goes down to 836 keysyms.
# in the ruby-xlib (moriq's) keysym list, there were ~750 of them.
$filter_out = /^(3270|Arabic_|Cyrillic|Hangul|Thai|hebrew|kana)/

def find_int_defines(h,f)
	pattern = /#define\s+(\w+)\s+((0x)?[0-9A-Fa-f]+)/
	while l=f.gets
		m = pattern.match l
		next unless m
		name,value = m[1], eval(m[2])
		name.sub! /^X(K|C)_/, ""
		next if name =~ $filter_out
		h[value]=name if m
	end
end

def dump_list_by_one(prefix,h)
	ks = h.keys.sort {|a,b| h[a] <=> h[b] }
	ks.each {|k|
		puts "#{prefix}[\"#{h[k]}\"]=#{k}"
	}
end

def dump_list(prefix,h)
	ks = h.keys.sort {|a,b| b <=> a }
#	p ks.inspect
	while ks.length>0
		seq1 = [ks.pop]
		seq2 = h[seq1[-1]].to_s
		while ks.length>0 and ks[-1]==seq1[-1]+1
			t = " #{h[ks[-1]]}"
			break if seq2.length + t.length > 60
			seq1 << ks.pop
			seq2 << t
		end
		r = seq1[0]..seq1[-1]
		r = seq1[0] if seq1[0]==seq1[-1]
		puts "#{prefix}[*%w| #{seq2} |]=#{r.inspect}"
	end
end

#----------------------------------------------------------------#

puts <<-ZZ
=begin
	This file was automatically generated by tools/Keysyms_lister.rb
	for the Ruby X11 Client Library

	Original lists are Copyright 1987-1998 by DEC / OpenGroup.
=end

require "X11/Type"

module X11
 k = Keysymdef = {}
 c = Cursorfont = {}
 [k,c].each {|x| x.extend X11::MAssignForHash }
ZZ

File.open("/usr/include/X11/keysymdef.h") {|f|
	h = {}
	find_int_defines(h,f)
	dump_list(" k",h)
}

File.open("/usr/include/X11/cursorfont.h") {|f|
	h = {}
	find_int_defines(h,f)
	h2 = {}; h.each{|k,v| h2[k/2]=v }
	dump_list(" c",h2)
}

puts <<-ZZ
 Cursorfont.each {|k,v| Cursorfont[k] *= 2 }
 KeysymdefReverse  =  Keysymdef.invert
 CursorfontReverse = Cursorfont.invert
end
ZZ
