/*
Copyright (C) 2002-2003 Victor Luchits

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// cg_local.h -- local definitions for client game module

#include "../game/q_shared.h"
#include "../gameshared/gs_public.h"
#include "ref.h"

#include "cg_public.h"
#include "cg_syscalls.h"

#define ITEM_RESPAWN_TIME	1000

#define FLAG_TRAIL_DROP_DELAY 300
#define HEADICON_TIMEOUT 8000

enum {
	LOCALEFFECT_EV_PLAYER_TELEPORT_IN
	, LOCALEFFECT_EV_PLAYER_TELEPORT_OUT
#ifdef VSAYS
	, LOCALEFFECT_VSAY_HEADICON
	, LOCALEFFECT_VSAY_HEADICON_TIMEOUT
#endif
	, LOCALEFFECT_TRAIL_LAST_DROP
	, MAX_LOCALEFFECTS = 128
};

typedef struct
{
	entity_state_t	current;
	entity_state_t	prev;			// will always be valid, but might just be a copy of current

	int			serverFrame;		// if not current, this ent isn't in the frame
	unsigned int	fly_stoptime;

	int			respawnTime;
// LERPEDCGAME
	entity_t		ent;				// interpolated, to be added to render list
	unsigned int	type;
	unsigned int	renderfx;
	unsigned int	effects;

	gitem_t			*item;

	//effects
	vec3_t			trailOrigin;	// for particle trails

	// local effects from events timers
	unsigned int	localEffects[MAX_LOCALEFFECTS];	

	vec3_t			teleportedFrom;
	byte_vec4_t		outlineColor;
	byte_vec4_t		color;

// LERPEDCGAME
} centity_t;

#include "cg_pmodels.h"//splitmodels

typedef struct cgs_media_handle_s
{
	char *name;
	void *data;
	struct cgs_media_handle_s *next;
} cgs_media_handle_t;

//wsw
#define NUM_CROSSHAIRS	5
#define MAX_MEATY_GIBS	6

#define STAT_MINUS		10	// num frame for '-' stats digit

typedef struct
{
	// sounds
	cgs_media_handle_t		*sfxChat;

	// timers
	cgs_media_handle_t		*sfxTimerBipBip;
	cgs_media_handle_t		*sfxTimerPloink;

	cgs_media_handle_t		*sfxRic[3];

	cgs_media_handle_t		*sfxWeaponUp;
	cgs_media_handle_t		*sfxWeaponUpNoAmmo;	//[end]
	
	//wsw
	//--------------------------------------

	cgs_media_handle_t		*sfxWeaponHit[5];

	cgs_media_handle_t		*sfxItemRespawn;
	cgs_media_handle_t		*sfxItemQuadRespawn;
	cgs_media_handle_t		*sfxTeleportIn;
	cgs_media_handle_t		*sfxTeleportOut;
//	cgs_media_handle_t		*sfxJumpPad;

	// Gunblade sounds :
	cgs_media_handle_t		*sfxGunbladeWeakShot[3];
	cgs_media_handle_t		*sfxGunbladeStrongShot;
	cgs_media_handle_t		*sfxBladeFleshHit[3];
	cgs_media_handle_t		*sfxBladeWallHit[2];
	cgs_media_handle_t		*sfxGunbladeStrongHit[3];
//	cgs_media_handle_t		*sfxBulletHit[2];

	// Riotgun sounds :
	cgs_media_handle_t		*sfxRiotgunWeakShot;
	cgs_media_handle_t		*sfxRiotgunStrongShot;
	cgs_media_handle_t		*sfxRiotgunWeakHit;
	cgs_media_handle_t		*sfxRiotgunStrongHit;

	// Grenade launcher sounds :
	cgs_media_handle_t		*sfxGrenadeLauncherWeakShot;
	cgs_media_handle_t		*sfxGrenadeLauncherStrongShot;
	cgs_media_handle_t		*sfxGrenadeWeakBounce[2];
	cgs_media_handle_t		*sfxGrenadeStrongBounce[2];
	cgs_media_handle_t		*sfxGrenadeWeakExplosion;
	cgs_media_handle_t		*sfxGrenadeStrongExplosion;

	// Rocket launcher sounds :
	cgs_media_handle_t		*sfxRocketLauncherWeakShot;
	cgs_media_handle_t		*sfxRocketLauncherStrongShot;
	cgs_media_handle_t		*sfxRocketLauncherWeakHit;
	cgs_media_handle_t		*sfxRocketLauncherStrongHit;

	// Plasmagun sounds
	cgs_media_handle_t		*sfxPlasmagunWeakShot;
	cgs_media_handle_t		*sfxPlasmagunStrongShot[3];
	cgs_media_handle_t		*sfxPlasmaWeakHit;
	cgs_media_handle_t		*sfxPlasmaStrongHit;

	// Electrobolt sounds
	cgs_media_handle_t		*sfxElectroboltWeakShot;
	cgs_media_handle_t		*sfxElectroboltStrongShot;

	// Lasergun sounds
	cgs_media_handle_t		*sfxLasergunStrongShot;
	cgs_media_handle_t		*sfxLasergunWeakShot;

	// VSAY sounds
#ifdef VSAYS
	cgs_media_handle_t		*sfxVSaySounds[VSAY_TOTAL];
#endif

	//no wsw

	// models
	cgs_media_handle_t		*modFlash;
	cgs_media_handle_t		*modParasiteSegment;
	cgs_media_handle_t		*modGrappleCable;
	cgs_media_handle_t		*modParasiteTip;
	cgs_media_handle_t		*modBfgExplo;
	cgs_media_handle_t		*modBfgBigExplo;
	cgs_media_handle_t		*modPowerScreen;
	cgs_media_handle_t		*modLightning;
	cgs_media_handle_t		*modMeatyGib;
	cgs_media_handle_t		*modTeleportEffect;
	cgs_media_handle_t		*modRocketFlare;

	// wsw : jal : gib models
	cgs_media_handle_t		*modMeatyGibs[MAX_MEATY_GIBS];

	//wsw weapon sfx
	cgs_media_handle_t		*modRocketExplosion;
	cgs_media_handle_t		*modGrenadeExplosion;
	cgs_media_handle_t		*modPlasmaExplosion;
	cgs_media_handle_t		*modBoltExplosion;

	cgs_media_handle_t		*modBulletExplode;
	cgs_media_handle_t		*modBladeWallHit;
	cgs_media_handle_t		*modBladeWallExplo;

	//no wsw

	//splitmodels[start] //eject brass-debris
	cgs_media_handle_t		*modEjectBrassMachinegun;
	cgs_media_handle_t		*modEjectBrassShotgun;	//[end]

	cgs_media_handle_t		*shaderParticle;
	cgs_media_handle_t		*shaderGrenadeExplosion;
	cgs_media_handle_t		*shaderRocketExplosion;
	cgs_media_handle_t		*shaderRocketExplosionRing;
	cgs_media_handle_t		*shaderBulletExplosion;
	cgs_media_handle_t		*shaderPowerupQuad;
	cgs_media_handle_t		*shaderQuadWeapon;
	cgs_media_handle_t		*shaderShellEffect;
	cgs_media_handle_t		*shaderWaterBubble;
	cgs_media_handle_t		*shaderTeleportEffect;
	cgs_media_handle_t		*shaderSmokePuff;
	cgs_media_handle_t		*shaderGrenadeTrailSmokePuff;
	cgs_media_handle_t		*shaderBloodTrailPuff;
	cgs_media_handle_t		*shaderBloodTrailLiquidPuff;
	cgs_media_handle_t		*shaderBloodImpactPuff;
	cgs_media_handle_t		*shaderTeleporterSmokePuff;
	cgs_media_handle_t		*shaderBulletMark;
	cgs_media_handle_t		*shaderExplosionMark;
	cgs_media_handle_t		*shaderEnergyMark;
	cgs_media_handle_t		*shaderLaser;
	cgs_media_handle_t		*shaderNet;
	cgs_media_handle_t		*shaderBackTile;
	cgs_media_handle_t		*shaderSelect;
	cgs_media_handle_t		*shaderChatBalloon;

	//wsw
	//----------------------------------------------
	//wsw weapon sfx
	cgs_media_handle_t		*shaderPlasmaMark;
	cgs_media_handle_t		*shaderElectroBeam;
	cgs_media_handle_t		*shaderLaserGunBeam;

	//wsw
	cgs_media_handle_t		*shaderPlayerShadow;
	cgs_media_handle_t		*shaderFlagFlare;

	// generic black outline used for not LOD stuff
	cgs_media_handle_t		*shaderBlackOutline;
	// outline LODs
	cgs_media_handle_t		*shaderColoredModelOutlinex1;
	cgs_media_handle_t		*shaderColoredModelOutlinex2;
	cgs_media_handle_t		*shaderColoredModelOutlinex3;
	cgs_media_handle_t		*shaderColoredModelOutlinex4;
	cgs_media_handle_t		*shaderColoredModelOutlinex5;

	// hud icons
	cgs_media_handle_t		*shaderWeaponIcon[WEAP_TOTAL]; 
	cgs_media_handle_t		*shaderNoGunWeaponIcon[WEAP_TOTAL];
	//no wsw

	cgs_media_handle_t		*sbNums[11];
	cgs_media_handle_t		*shaderCrosshair[NUM_CROSSHAIRS];

	// VSAY icons
#ifdef VSAYS
	cgs_media_handle_t		*shaderVSayIcon[VSAY_TOTAL];
#endif
} cgs_media_t;

// skelmod[start]
typedef struct cg_tagmask_s
{
	char	tagname[64];
	char	bonename[64];
	int		bonenum;
	struct cg_tagmask_s *next;
	vec3_t	offset;
}cg_tagmask_t;

typedef struct
{
	char					name[MAX_QPATH];
	int						flags;
	int						parent;
} cgs_bone_t;

typedef struct cgs_skeleton_s
{
	struct model_s			*model;

	int						numBones;
	cgs_bone_t				*bones;

	int						numFrames;
	bonepose_t				**bonePoses;

	struct cgs_skeleton_s	*next;

	// store the tagmasks as part of the skeleton (they are only used by player models, tho)
	struct cg_tagmask_s		*tagmasks;
} cgs_skeleton_t;

#include "cg_boneposes.h"
// skelmod[end]

typedef struct cg_sexedSfx_s
{
	char *name;
	struct sfx_s *sfx;
	struct cg_sexedSfx_s *next;
} cg_sexedSfx_t;

// SPLITMODELS[start]
typedef struct
{
	char	name[MAX_QPATH];
	char	cinfo[MAX_QPATH];
	int		hand;
	byte_vec4_t color;

	struct	shader_s	*icon;
} cg_clientInfo_t;

// SPLITMODELS[end]

// wsw : jal : client-side kickangles and colorblends effects
#define MAX_ANGLES_KICKS 3

typedef struct 
{
	unsigned int	timestamp;
	unsigned int	kicktime;
	float	v_roll, v_pitch;

}cg_kickangles_t;

#define MAX_COLORBLENDS 3

typedef struct 
{
	unsigned int	timestamp;
	unsigned int	blendtime;
	float	blend[4];

}cg_viewblend_t;

typedef struct {
	qboolean	has_challengers;
	int			maxteams;
}cg_serverrules_t;

// wsw : jal : stairs smoothing predicted time
#define PREDICTED_STEP_TIME 150


typedef struct {
	player_state_t	*oldps;
	player_state_t	*curps;

	// interpolated between old and current
	vec3_t	origin;
	vec3_t	viewangles;
	vec3_t	viewoffset;
	float	fov;

	// other information
	qboolean	isOnGround; // can not have groundentity, but look like it does (stairs).
	int			viewContents;
}cg_playerstate_t;

// this is not exactly "static" but still...
typedef struct
{
	int					playerNum;

	// shaders
	struct shader_s		*shaderWhite;
	struct shader_s		*shaderLevelshot;
	struct shader_s		*shaderLevelshotDetail;

	// fonts
	struct mufont_s		*fontSystemSmall;
	struct mufont_s		*fontSystemMedium;
	struct mufont_s		*fontSystemBig;

	cgs_media_t			media;

	int					vidWidth, vidHeight;
	int					gametype;	//splitmodels

	//
	// locally derived information from server state
	//
	char				configStrings[MAX_CONFIGSTRINGS][MAX_CONFIGSTRING_CHARS];

	char				weaponModels[WEAP_TOTAL][MAX_QPATH];
	int					numWeaponModels;

	orientation_t		weaponItemTag;

	cg_clientInfo_t		clientInfo[MAX_CLIENTS];

	struct model_s		*modelDraw[MAX_MODELS];
	struct model_s		*inlineModelDraw[MAX_MODELS];

	struct pmodelinfo_s	*pModelsIndex[MAX_MODELS];
	struct pmodelinfo_s	*basePModelInfo;	//fall back replacements
	struct skinfile_s	*baseSkin;

	// force models
/*	struct pmodelinfo_s	*enemyPModelInfo;	// user defined
	struct skinfile_s	*enemySkins[GS_MAX_TEAMS]; // full skin set for the enemy model
	struct skinfile_s	*enemyCustomSkin;	// user defined
	byte_vec4_t			enemyColor;

	struct pmodelinfo_s	*teamPModelInfo;	// user defined
	struct skinfile_s	*teamSkins[GS_MAX_TEAMS]; // full skin set for the team model
	struct skinfile_s	*teamCustomSkin; // user defined
	byte_vec4_t			teamColor;
*/
	// force models
	struct pmodelinfo_s	*teamPLAYERSModelInfo;
	struct skinfile_s	*teamPLAYERSCustomSkin; // user defined
	int					teamPLAYERSColor;

	struct pmodelinfo_s	*teamREDModelInfo;
	struct skinfile_s	*teamREDCustomSkin; // user defined
	int					teamREDColor;

	struct pmodelinfo_s	*teamBLUEModelInfo;
	struct skinfile_s	*teamBLUECustomSkin; // user defined
	int					teamBLUEColor;

	struct pmodelinfo_s	*teamGREENModelInfo;
	struct skinfile_s	*teamGREENCustomSkin; // user defined
	int					teamGREENColor;

	struct pmodelinfo_s	*teamYELLOWModelInfo;
	struct skinfile_s	*teamYELLOWCustomSkin; // user defined
	int					teamYELLOWColor;

	struct sfx_s		*soundPrecache[MAX_SOUNDS];
	struct shader_s		*imagePrecache[MAX_IMAGES];
	struct skinfile_s	*skinPrecache[MAX_SKINFILES];

	cg_serverrules_t	serverRules;

} cg_static_t;

typedef struct
{
	unsigned int		time;

	int					realTime;
	float				frameTime;
	int					frameCount;

	frame_t				frame, oldFrame;
	qboolean			frameSequenceRunning;

 	int					predictedOrigins[CMD_BACKUP][3];	// for debug comparing against server

	int					groundEntity;
	float				predictedStep;		// for stair up smoothing
	unsigned			predictedStepTime;

	vec3_t				predictedVelocity;
	vec3_t				predictedOrigin;	// generated by CG_PredictMovement
	vec3_t				predictedAngles;
	vec3_t				predictionError;

	vec3_t				autorotateAxis[3];

	float				lerpfrac;			// between oldframe and frame

	refdef_t			refdef;
	float				view_fracDistFOV; // used for outline LOD computations

	vec3_t				v_forward, v_right, v_up;	// set when refdef.angles is set

	int					effects;
	qboolean			thirdPerson;
	qboolean			demoPlaying;
	qboolean			demoShowScoreboard;

	int					chasedNum;		//CHASEHACKv2 & splitmodels
	int					pointedNum;

	qboolean			changing_weapon;	// for demos / chasecam to fix noammo sounds
	int					latched_weapon;		// weapon we think we are changing to

	//
	// all cyclic walking effects
	//
	float				xyspeed;

	float				oldBobTime;
	int					bobCycle;		// odd cycles are right foot going forward
	float				bobFracSin;		// sin(bobfrac*M_PI)

	//
	// kick angles and color blend effects
	//
	
	cg_kickangles_t		kickangles[MAX_ANGLES_KICKS];
	cg_viewblend_t		colorblends[MAX_COLORBLENDS];

	//
	// transient data from server
	//
	char				layout[MAX_STRING_CHARS];	// general 2D overlay
	int					inventory[MAX_ITEMS];

	char				checkname[MAX_QPATH];
	char				loadingstring[MAX_QPATH];
	char				matchmessage[MAX_STRING_CHARS];
	char				teaminfo[MAX_STRING_CHARS];

	// statusbar program
	struct cg_layoutnode_s *statusBar;

	// interpolated player state info
	cg_playerstate_t	player;

} cg_state_t;

extern	cg_static_t	cgs;
extern	cg_state_t	cg;

extern	centity_t	cg_entities[MAX_EDICTS];

extern cvar_t	*developer;

//
// cg_ents.c
//
extern	cvar_t	*cg_gun;
extern	cvar_t	*cg_timedemo;
extern	cvar_t	*cg_damage_kick;

void CG_NewFrameSnap( frame_t *frame, frame_t *deltaframe );
void CG_AddEntities( void );
void CG_GlobalSound( vec3_t origin, int entNum, int entChannel, int soundNum, float fvol, float attenuation );
void CG_GetEntitySoundOrigin( int entNum, vec3_t org );
void CG_FirePlayerStateEvents( void );	// wsw : jal
void CG_LerpEntities( void );			// wsw : jal

void CG_SetOutlineColor( byte_vec4_t outlineColor, vec4_t itemcolor );
void CG_AddColoredOutLineEffect( entity_t *ent, int effects, qbyte r, qbyte g, qbyte b, qbyte a );
void CG_AddCentityOutLineEffect( centity_t *cent );

//
// cg_draw.c
//
int CG_HorizontalAlignForWidth( const int x, int align, int width );
int CG_VerticalAlignForHeight( const int y, int align, int height );

void CG_FillRect( int x, int y, int w, int h, vec4_t color );
void CG_DrawHUDField( int x, int y, int align, float *color, int size, int width, int value );
void CG_DrawModel( int x, int y, int align, int w, int h, struct model_s *model, struct shader_s *shader, vec3_t origin, vec3_t angles );
void CG_DrawHUDModel( int x, int y, int align, int w, int h, struct model_s *model, struct shader_s *shader, float yawspeed );
void CG_DrawHUDRect( int x, int y, int align, int w, int h, int val, int maxval, vec4_t color );

//
// cg_media.c
//
void CG_RegisterMediaSounds( void );
void CG_RegisterMediaModels( void );
void CG_RegisterMediaShaders( void );
void CG_RegisterLevelShot( void );

struct sfx_s *CG_MediaSfx( cgs_media_handle_t *mediasfx );
struct model_s *CG_MediaModel( cgs_media_handle_t *mediamodel );
struct shader_s *CG_MediaShader( cgs_media_handle_t *mediashader );

//
// cg_players.c
//
extern	cvar_t	*cg_noSkins;
extern	cvar_t	*cg_vwep;

extern	cvar_t	*model;// wsw : jal
extern	cvar_t	*skin;
extern	cvar_t	*hand;

void CG_LoadClientInfo( cg_clientInfo_t *ci, char *s, int client );
void CG_UpdateSexedSoundsRegistration( pmodelinfo_t *pmodelinfo );
void CG_SexedSound( int entnum, int entchannel, char *name, float fvol );

//
// cg_predict.c
//
extern	cvar_t	*cg_predict;
extern	cvar_t	*cg_showMiss;

void CG_PredictMovement( void );
void CG_CheckPredictionError( void );
void CG_BuildSolidList( void );
void CG_Trace( trace_t *t, vec3_t start, vec3_t mins, vec3_t maxs, vec3_t end, int ignore, int contentmask );
int	CG_PointContents( vec3_t point );

//
// cg_screen.c
//
typedef struct
{
	int		x, y, width, height;
} vrect_t;

extern vrect_t scr_vrect;

void SCR_Init( void );
void SCR_Shutdown( void );
void SCR_Draw2D( void );
void SCR_CalcVrect( void );
void SCR_TileClear( void );
void SCR_DrawLoading( void );
void SCR_CenterPrint( char *str );
void SCR_CenterPrintToUpper( char *str );

void CG_InGameMenu( void );
void CG_LoadLayout( char *s );
void CG_LoadStatusBar( void );

void CG_LoadingString( char *str );
void CG_LoadingFilename( char *str );

void SCR_DrawCrosshair( int x, int y, int align );

//
// cg_hud.c
//
void Cmd_CG_PrintHudHelp_f( void );
void CG_ExecuteLayoutProgram( struct cg_layoutnode_s *rootnode );
void SCR_DrawWeaponList( int x, int y, int ix, int iy, int wx, int wy, int sx, int sy );


//
// cg_scoreboard
//
void SCR_DemoToggleScores_f( void );
qboolean SCR_ExecuteScoreboardTemplateLayout( char *s );


//
// cg_main.c
//
// wsw
extern cvar_t   *cg_volume_hitsound;	// hit sound volume
extern cvar_t   *cg_autoaction; // auto record and auto screenshot
extern cvar_t   *cg_simpleItems; // simple items
extern cvar_t   *cg_simpleItemsSize; // simple items
extern cvar_t   *cg_volume_players;	// players sound volume
extern cvar_t   *cg_volume_effects;	// world sound volume
extern cvar_t   *cg_volume_announcer; // announcer sounds volume
#ifdef VSAYS
extern cvar_t	*cg_volume_voicechats; //vsays volume
#endif
extern cvar_t	*cg_rocketTrail;
extern cvar_t	*cg_grenadeTrail;
extern cvar_t	*cg_bloodTrail;
extern cvar_t	*cg_showBloodTrail;
extern cvar_t	*cg_rocketTrailAlpha;
extern cvar_t	*cg_grenadeTrailAlpha;
extern cvar_t	*cg_bloodTrailAlpha;
extern cvar_t	*cg_explosionsAlpha;
extern cvar_t	*cg_explosionsRingAlpha;
extern cvar_t	*cg_gibs;
extern cvar_t	*cg_outlineModels;
extern cvar_t	*cg_outlineItemsBlack;
extern cvar_t	*cg_outlinePlayersBlack;
extern cvar_t	*cg_demo_truePOV; // use client side fov, hand, etc on demos
extern cvar_t	*cg_fov;
extern cvar_t	*cg_particles;
extern cvar_t	*cg_showhelp;
extern cvar_t	*cg_predictLaserBeam;
extern cvar_t	*cg_voiceChats;
#ifdef CGAMEGETLIGHTORIGIN
extern cvar_t	*cg_shadows;
#endif
extern cvar_t	*cg_showPlayerTrails;
extern cvar_t	*cg_laserBeamSubdivisions;
//force models
extern cvar_t			*cg_teamPLAYERSmodel;
extern cvar_t	        *cg_teamREDmodel;
extern cvar_t	        *cg_teamBLUEmodel;
extern cvar_t	        *cg_teamGREENmodel;
extern cvar_t	        *cg_teamYELLOWmodel;

extern cvar_t			*cg_teamPLAYERSskin;
extern cvar_t	        *cg_teamREDskin;
extern cvar_t	        *cg_teamBLUEskin;
extern cvar_t	        *cg_teamGREENskin;
extern cvar_t	        *cg_teamYELLOWskin;

extern cvar_t			*cg_teamPLAYERScolor;
extern cvar_t	        *cg_teamREDcolor;
extern cvar_t	        *cg_teamBLUEcolor;
extern cvar_t	        *cg_teamGREENcolor;
extern cvar_t	        *cg_teamYELLOWcolor;

extern cvar_t	        *cg_forceEnemyTeam;
extern cvar_t	        *cg_forceMyTeam;

extern struct mempool_s *cgamepool;

#define CG_MemAlloc(pool,size) trap_MemAlloc(pool, size, __FILE__, __LINE__)
#define CG_MemFree(mem) trap_MemFree(mem, __FILE__, __LINE__)
#define CG_MemAllocPool(name) trap_MemAllocPool(name, __FILE__, __LINE__)
#define CG_MemFreePool(pool) trap_MemFreePool(pool, __FILE__, __LINE__)
#define CG_MemEmptyPool(pool) trap_MemEmptyPool(pool, __FILE__, __LINE__)

#define CG_Malloc(size) CG_MemAlloc(cgamepool,size)
#define CG_Free(data) CG_MemFree(data)

int CG_API( void );
void CG_Init( int playerNum, int vidWidth, int vidHeight );
void CG_Shutdown( void );
void CG_ValidateItemDef( int tag, char *name );
void CG_Printf( char *fmt, ... );
void CG_Error( char *fmt, ... );
char *CG_CopyString( char *in );

void CG_RegisterGameCommands( void );
void CG_UnregisterGameCommands( void );
void CG_RegisterDemoCommands( void );
void CG_UnregisterDemoCommands( void );
void CG_UpdateServerSettings( void );
void CG_RegisterForceModels( void );

//
// cg_svcmds.c
//
void CG_ServerCommand( void );

//
// cg_view.c
//
extern	cvar_t	*cg_thirdPerson;
extern	cvar_t	*cg_thirdPersonAngle;
extern	cvar_t	*cg_thirdPersonRange;

void CG_RenderView( float frameTime, int realTime, unsigned int serverTime, float stereo_separation, qboolean demoplaying );

//
// cg_lents.c
//
void CG_ClearLocalEntities( void );
void CG_AddBeams( void );
void CG_AddLocalEntities( void );

void CG_AddLaser( vec3_t start, vec3_t end, float radius, int colors, struct shader_s *shader );
void CG_BulletExplosion( vec3_t origin, vec3_t dir );
void CG_AddBeam( int ent, vec3_t start, vec3_t end, vec3_t offset, struct model_s *model, struct shader_s *shader ); // wsw : jal : allow custom shaders
void CG_AddLightning( int srcEnt, int destEnt, vec3_t start, vec3_t end, struct model_s *model );
void CG_BubbleTrail( vec3_t start, vec3_t end, int dist );
void CG_Explosion1( vec3_t pos );
void CG_Explosion2( vec3_t pos );
void CG_NewRocketTrail( centity_t *cent );
void CG_NewGrenadeTrail( centity_t *cent );
void CG_NewBloodTrail( centity_t *cent );
void CG_BloodDamageEffect( vec3_t origin, vec3_t dir, int damage );
void CG_NewElectroBeamPuff( centity_t *cent, vec3_t origin, vec3_t dir );
void CG_FlagTrail( vec3_t origin, vec3_t start, vec3_t end, float r, float g, float b );
void CG_TeleportEffect( vec3_t org );
void CG_GreenLaser( vec3_t start, vec3_t end );
void CG_SmallPileOfGibs( vec3_t origin, int	count, vec3_t velocity );//splitmodels (debrisbounce)
void CG_EjectBrass( vec3_t origin, int	count, struct model_s *model );//splitmodels //eject brass-debris

#ifdef THIS_IS_DISABLED
void CG_BlasterExplosion( vec3_t pos, vec3_t dir );
void CG_BFGExplosion( vec3_t pos );
void CG_BFGBigExplosion( vec3_t pos );
#endif
//
// cg_decals.c
//
extern	cvar_t	*cg_addDecals;

void CG_ClearDecals( void );
void CG_SpawnDecal( vec3_t origin, vec3_t dir, float orient, float radius,
				 float r, float g, float b, float a, float die, float fadetime, qboolean fadealpha, struct shader_s *shader );
void CG_AddDecals( void );

//
// cg_polys.c	-	wsw	: jal
//
//extern	cvar_t	*cg_addPolyss;

void CG_ClearPolys( void );
void CG_AddPolys( void );
void CG_QuickPolyBeam( vec3_t start, vec3_t end, int width, struct shader_s *shader );
void CG_LaserGunPolyBeam( vec3_t start, vec3_t end );
void CG_ElectroPolyBeam( vec3_t start, vec3_t end );

//
// cg_effects.c
//
void CG_ClearEffects( void );

void CG_AddLightToScene( vec3_t org, float intensity, float r, float g, float b, struct shader_s *shader );
void CG_AddDlights( void );
#ifdef CGAMEGETLIGHTORIGIN
void CG_AllocShadeBox( int entNum, const vec3_t origin, const vec3_t mins, const vec3_t maxs, struct shader_s *shader );
void CG_AddShadeBoxes( void );
#endif
void CG_RunLightStyles( void );
void CG_SetLightStyle( int i );
void CG_AddLightStyles( void );

void CG_AddParticles( void );
void CG_ParticleEffect( vec3_t org, vec3_t dir, float r, float g, float b, int count );
void CG_ParticleEffect2( vec3_t org, vec3_t dir, float r, float g, float b, int count );
void CG_BlasterParticles( vec3_t org, vec3_t dir );
void CG_BlasterTrail( vec3_t start, vec3_t end );
void CG_FlyEffect( centity_t *ent, vec3_t origin );

// wsw
void CG_ElectroWeakTrail( vec3_t start, vec3_t end );
void CG_ImpactPufParticles( vec3_t org, vec3_t dir, int count, float scale, float r, float g, float b, float a, struct shader_s *shader );

#ifdef THIS_IS_DISABLED
void CG_BfgParticles( vec3_t origin );
void CG_BigTeleportParticles( vec3_t org );
void CG_BFGExplosionParticles( vec3_t org );
void CG_RailTrail( vec3_t start, vec3_t end );
#endif

//
// cg_test.c - debug only
//
#ifdef _DEBUG
void CG_DrawTestLine( vec3_t start, vec3_t end );
void CG_DrawTestBox( vec3_t origin, vec3_t mins, vec3_t maxs );
void CG_AddTest( void );
#endif

//
//	cg_vweap.c - client weapon
//
void CG_WeapPrev_f( void );
void CG_WeapNext_f( void );
void CG_Cmd_Use_f( void );
void CG_NoAmmoWeaponChange( void );
void CG_CheckWeaponState( void );


//
// cg_events.c
//
extern	cvar_t	*cg_footSteps;
extern	cvar_t	*cg_damage_blend;
extern	cvar_t	*cg_pickup_flash;

void CG_EntityEvent( entity_state_t *ent );


void CG_ReleaseAnnouncerEvents( void );
void CG_ClearAnnouncerEvents( void );

//=================================================

