/*
Copyright (C) 2002-2003 Victor Luchits

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifdef _DEBUG
#include "cg_local.h"

// cg_test.c -- test crap

cvar_t			*cg_testEntities;
cvar_t			*cg_testLights;
cvar_t			*cg_testBlend;

void CG_DrawTestLine( vec3_t start, vec3_t end )
{
	CG_QuickPolyBeam( start, end, 6, CG_MediaShader (cgs.media.shaderLaser) );
}

void CG_DrawTestBox( vec3_t origin, vec3_t mins, vec3_t maxs )
{
	static vec3_t start, end;
	//horizontal projection
	start[0] = origin[0] + mins[0];
	start[1] = origin[1] + mins[1];
	start[2] = origin[2] + mins[2];

	end[0] = origin[0] + mins[0];
	end[1] = origin[1] + mins[1];
	end[2] = origin[2] + maxs[2];

	CG_QuickPolyBeam( start, end, 6, CG_MediaShader (cgs.media.shaderLaser) );

	start[0] = origin[0] + mins[0];
	start[1] = origin[1] + maxs[1];
	start[2] = origin[2] + mins[2];

	end[0] = origin[0] + mins[0];
	end[1] = origin[1] + maxs[1];
	end[2] = origin[2] + maxs[2];

	CG_QuickPolyBeam( start, end, 6, CG_MediaShader (cgs.media.shaderLaser) );

	start[0] = origin[0] + maxs[0];
	start[1] = origin[1] + mins[1];
	start[2] = origin[2] + mins[2];

	end[0] = origin[0] + maxs[0];
	end[1] = origin[1] + mins[1];
	end[2] = origin[2] + maxs[2];

	CG_QuickPolyBeam( start, end, 6, CG_MediaShader (cgs.media.shaderLaser) );

	start[0] = origin[0] + maxs[0];
	start[1] = origin[1] + maxs[1];
	start[2] = origin[2] + mins[2];

	end[0] = origin[0] + maxs[0];
	end[1] = origin[1] + maxs[1];
	end[2] = origin[2] + maxs[2];

	CG_QuickPolyBeam( start, end, 6, CG_MediaShader (cgs.media.shaderLaser) );

	//x projection
	start[0] = origin[0] + mins[0];
	start[1] = origin[1] + mins[1];
	start[2] = origin[2] + mins[2];

	end[0] = origin[0] + maxs[0];
	end[1] = origin[1] + mins[1];
	end[2] = origin[2] + mins[2];

	CG_QuickPolyBeam( start, end, 6, CG_MediaShader (cgs.media.shaderLaser) );

	start[0] = origin[0] + mins[0];
	start[1] = origin[1] + maxs[1];
	start[2] = origin[2] + maxs[2];

	end[0] = origin[0] + maxs[0];
	end[1] = origin[1] + maxs[1];
	end[2] = origin[2] + maxs[2];

	CG_QuickPolyBeam( start, end, 6, CG_MediaShader (cgs.media.shaderLaser) );

	start[0] = origin[0] + mins[0];
	start[1] = origin[1] + maxs[1];
	start[2] = origin[2] + mins[2];

	end[0] = origin[0] + maxs[0];
	end[1] = origin[1] + maxs[1];
	end[2] = origin[2] + mins[2];

	CG_QuickPolyBeam( start, end, 6, CG_MediaShader (cgs.media.shaderLaser) );

	start[0] = origin[0] + mins[0];
	start[1] = origin[1] + mins[1];
	start[2] = origin[2] + maxs[2];

	end[0] = origin[0] + maxs[0];
	end[1] = origin[1] + mins[1];
	end[2] = origin[2] + maxs[2];

	CG_QuickPolyBeam( start, end, 6, CG_MediaShader (cgs.media.shaderLaser) );

	//z projection
	start[0] = origin[0] + mins[0];
	start[1] = origin[1] + mins[1];
	start[2] = origin[2] + mins[2];

	end[0] = origin[0] + mins[0];
	end[1] = origin[1] + maxs[1];
	end[2] = origin[2] + mins[2];

	CG_QuickPolyBeam( start, end, 6, CG_MediaShader (cgs.media.shaderLaser) );

	start[0] = origin[0] + maxs[0];
	start[1] = origin[1] + mins[1];
	start[2] = origin[2] + maxs[2];

	end[0] = origin[0] + maxs[0];
	end[1] = origin[1] + maxs[1];
	end[2] = origin[2] + maxs[2];

	CG_QuickPolyBeam( start, end, 6, CG_MediaShader (cgs.media.shaderLaser) );

	start[0] = origin[0] + maxs[0];
	start[1] = origin[1] + mins[1];
	start[2] = origin[2] + mins[2];

	end[0] = origin[0] + maxs[0];
	end[1] = origin[1] + maxs[1];
	end[2] = origin[2] + mins[2];

	CG_QuickPolyBeam( start, end, 6, CG_MediaShader (cgs.media.shaderLaser) );

	start[0] = origin[0] + mins[0];
	start[1] = origin[1] + mins[1];
	start[2] = origin[2] + maxs[2];

	end[0] = origin[0] + mins[0];
	end[1] = origin[1] + maxs[1];
	end[2] = origin[2] + maxs[2];

	CG_QuickPolyBeam( start, end, 6, CG_MediaShader (cgs.media.shaderLaser) );
}

//================
//CG_TestEntities
//
//If cg_testEntities is set, create 32 player models
//================
void CG_TestEntities( void )
{
	int			i, j;
	float		f, r;
	entity_t	ent;

	memset( &ent, 0, sizeof( ent ) );

	trap_R_ClearScene ();

	for( i = 0; i < 100; i++ ) {
		r = 64 * ( (i%4) - 1.5 );
		f = 64 * (i/4) + 128;

		for ( j = 0; j < 3; j++ )
			ent.origin[j] = ent.lightingOrigin[j] = cg.refdef.vieworg[j] + cg.v_forward[j]*f + cg.v_right[j]*r;

		Matrix_Copy( cg.autorotateAxis, ent.axis );

		ent.scale = 1.0f;
		ent.rtype = RT_MODEL;
		// skelmod splitmodels
		ent.model = cgs.basePModelInfo->model;
		if( cgs.baseSkin )
			ent.customSkin = cgs.baseSkin;
		else
			ent.customSkin = NULL;

		CG_AddEntityToScene( &ent ); // skelmod
	}
}

//================
//CG_TestLights
//
//If cg_testLights is set, create 32 lights models
//================
void CG_TestLights( void )
{
	int			i, j;
	float		f, r;
	vec3_t		origin;

	for( i = 0; i < min( cg_testLights->integer, 32 ); i++ ) {
		r = 64 * ((i%4) - 1.5);
		f = 64 * (i/4) + 128;

		for ( j = 0; j < 3; j++ )
			origin[j] = cg.refdef.vieworg[j]/* + cg.v_forward[j]*f + cg.v_right[j]*r*/;
		CG_AddLightToScene( origin, 200, ((i%6)+1) & 1, (((i%6)+1) & 2)>>1, (((i%6)+1) & 4)>>2, NULL );
	}
}

//================
//CG_TestBlend
//
//If cg_testBlend is set, create a debug blend
//================
void CG_TestBlend( void )
{
	cg.refdef.blend[0] = 1;
	cg.refdef.blend[1] = 0.5;
	cg.refdef.blend[2] = 0.25;
	cg.refdef.blend[3] = 0.5;
}

//================
//CG_TestBlend
//================
void CG_AddTest( void )
{
	if( !cg_testEntities || !cg_testLights || !cg_testBlend ) {
		cg_testBlend =			trap_Cvar_Get( "cg_testBlend", "0", CVAR_CHEAT );
		cg_testEntities =		trap_Cvar_Get( "cg_testEntities", "0", CVAR_CHEAT );
		cg_testLights =			trap_Cvar_Get( "cg_testLights", "0", CVAR_CHEAT );
	}

	if( cg_testEntities->integer )
		CG_TestEntities();
	if( cg_testLights->integer )
		CG_TestLights();
	if( cg_testBlend->integer )
		CG_TestBlend();
}

#endif // _DEBUG
