/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "g_local.h"
#include "g_gametypes.h"

//==================
//G_Gametype_MIDAIR_ScoreboardMessage
//==================
char *G_Gametype_MIDAIR_ScoreboardMessage( edict_t *ent, edict_t *killer )
{
	char			entry[MAX_TOKEN_CHARS];
	unsigned int	len;
	int				i;
	edict_t			*e;

	//fixed layout scheme id
	Q_snprintfz(scoreboardString, sizeof(scoreboardString), "scb \"&dms " ); 
	len = strlen(scoreboardString);
	
	//players
	for( i = 0; teamlist[TEAM_PLAYERS].playerIndices[i] != -1; i++ )
	{
		e = game.edicts + teamlist[TEAM_PLAYERS].playerIndices[i];
		//player tab entry
		*entry = 0;
		Q_snprintfz(entry, sizeof(entry), "&p %i %i %i %i ",
			PLAYERNUM(e),
			match.scores[PLAYERNUM(e)].score,
			e->r.client->r.ping > 999 ? 999 : e->r.client->r.ping,
			match.ready[PLAYERNUM(e)]
			);
		
		if (SCOREBOARD_MSG_MAXSIZE - len > strlen(entry)) {
			Q_strncatz(scoreboardString, entry, sizeof(scoreboardString));
			len = strlen(scoreboardString);
		}
	}

	G_ScoreboardMessage_AddSpectators();

	// add player stats (all weapon weak/strong 0..99) to scoreboard message
	G_ScoreboardMessage_AddPlayerStats( ent );

	// add closing quote
	if( SCOREBOARD_MSG_MAXSIZE - len > strlen(entry) ) {
		Q_strncatz( scoreboardString, "\"", sizeof(scoreboardString) );
		len = strlen(scoreboardString);
	}
	return scoreboardString;
}

int G_Gametype_MIDAIR_ClientRespawn( edict_t *self )
{
	if ( !game.gametype )
		return qfalse;

	self->r.svflags &= ~SVF_NOCLIENT;
	PutClientInServer (self);
	G_AddEvent (self, EV_TELEPORT, 0, qtrue);

	// add a teleportation effect
	G_SpawnTeleportEffect( self );
	
	// hold in place briefly
	self->r.client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
	self->r.client->ps.pmove.pm_time = 14;

	G_FakeClientRespawn (self);	//MbotGame

	// midair max health
	self->max_health = 250;
	self->health = 100;

	// give items
	memset( self->r.client->inventory, 0, sizeof( self->r.client->inventory ));
	self->r.client->inventory[WEAP_ROCKETLAUNCHER] = 1;
	self->r.client->inventory[AMMO_ROCKETS] = 10;
	self->r.client->latched_weapon = WEAP_ROCKETLAUNCHER;
	ChangeWeapon(self);
	self->r.client->weaponstate = WEAPON_ACTIVATING;
	self->r.client->weapon_nexttime = level.timemsec + 200;

	return qtrue;
}

//=================
//G_Gametype_MIDAIR_ClientHealthRule
//=================
void G_Gametype_MIDAIR_ClientHealthRule( void )
{
	edict_t		*e;
	
	// if player has more than 300 health he gets a quad and the life resets to 300
	for( e = game.edicts+1; PLAYERNUM(e) < game.maxclients; e++ )
	{
		if (!e->r.inuse)
			continue;
		
		if( e->health > 250 ) {
			e->health -= 1.0 * game.framemsec;
			if( e->health < 250 )
				e->health = 250;
		}

		if( e->health < 200 && (e->r.client->quad_timeout > level.timemsec) )
		{
			//e->r.client->quad_timeout = level.timemsec;
		} 
		else if( e->health >= 200 && (e->r.client->quad_timeout < level.timemsec) ) 
		{
			//give a quad
			if( game.items[POWERUP_QUAD] != NULL ) 
			{
				e->r.client->inventory[POWERUP_QUAD]++;
				G_UseItem( e, game.items[POWERUP_QUAD] );
				G_PrintMsg( NULL, "%s %sgot a QUAD bonus!%s\n", e->r.client->pers.netname, S_COLOR_RED, S_COLOR_WHITE );
			}

			// reset health to 100
			e->health = 100;
		}
	}
}

//=================
//G_Gametype_MIDAIR_CheckRules
//=================
void G_Gametype_MIDAIR_CheckRules( void )
{
	if( match.state >= MATCH_STATE_POSTMATCH )
		return;

	if( game.gametype != GAMETYPE_MIDAIR )
		return;

	G_Gametype_MIDAIR_ClientHealthRule();
	
	if( G_Match_GenericCountDownAnnounces() ) { // true once a second
	}
}

