/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "g_local.h"
#include "g_gametypes.h"


void G_Gametype_RACE_Init( void ) {}
void G_Gametype_RACE_NewMap( void ) {}

char *G_Gametype_RACE_ScoreboardMessage( edict_t *ent, edict_t *killer )
{
	char			entry[MAX_TOKEN_CHARS];
	unsigned int	len;
	int				i;
	edict_t			*e;
	float time;
	unsigned int min,sec,msec;

	//fixed layout scheme id
	Q_snprintfz( scoreboardString, sizeof(scoreboardString), "scb \"&races " ); 
	len = strlen( scoreboardString );

	//players
	for( i = 0; teamlist[TEAM_PLAYERS].playerIndices[i] != -1; i++ )
	{
		e = game.edicts + teamlist[TEAM_PLAYERS].playerIndices[i];
		//player tab entry
		*entry = 0;

		// player best time
		time=e->r.client->teamchange.race_best_lap_time;
		msec=time/100.0f;
		min=msec/600;
		msec-=min*600;
		sec=msec/10;
		msec-=sec*10; // only one digit

		Q_snprintfz( entry, sizeof(entry), "&p %i %2i %2i %1i %i %i ",
			PLAYERNUM(e),
			min,sec,msec, 
			e->r.client->r.ping > 999 ? 999 : e->r.client->r.ping,
			e->r.client->resp.race_in_race == qtrue ? 1 : 0
			);

			if( SCOREBOARD_MSG_MAXSIZE - len > strlen(entry) ) {
				Q_strncatz(scoreboardString, entry, sizeof(scoreboardString));
				len = strlen(scoreboardString);
			}
	}

	G_ScoreboardMessage_AddSpectators();

	// add closing quote
	if( SCOREBOARD_MSG_MAXSIZE - len > strlen(entry) ) {
		Q_strncatz( scoreboardString, "\"", sizeof(scoreboardString) );
		len = strlen(scoreboardString);
	}
	return scoreboardString;
}

void G_Gametype_RACE_ClientBegin( edict_t *ent )
{
	ClientBeginMultiplayerGame(ent);

	ent->r.clipmask = MASK_SOLID;

//	memset( &ent->r.client->pers.race, 0, sizeof(racescoring_t) );
}

//=================
//G_Gametype_RACE_CheckRules
//=================
void G_Gametype_RACE_CheckRules( void )
{
	if( match.state >= MATCH_STATE_POSTMATCH )
		return;

	if( game.gametype != GAMETYPE_RACE )
		return;

	if( G_Match_GenericCountDownAnnounces() ) { // true once a second
	}
}

//=================
//G_Gametype_RACE_SetUpMatch
//=================
void G_Gametype_RACE_SetUpMatch( void )
{
	//clear stats and scores
	game.besttime=0;

	G_Match_RespawnAllItems();
	G_Match_RespawnAllClients();
	G_Match_FreeBodyQueue();
	match.pickableItemsMask = GS_Gametype_SpawnableItemMask( game.gametype )|GS_Gametype_DropableItemMask( game.gametype );
	if( g_instagib->integer ) {
		match.pickableItemsMask &= ~G_INSTAGIB_NEGATE_ITEMMASK;
	}
	match.endtime = 0;
}

//=================
//G_Gametype_RACE_SetUpWarmup
//=================
void G_Gametype_RACE_SetUpWarmup( void )
{
	match.state = MATCH_STATE_PLAYTIME-1;
	G_Match_SetUpNextState();
	match.endtime = 0;
}

//=================
//G_Gametype_RACE_ClientRespawn
//=================
int G_Gametype_RACE_ClientRespawn( edict_t *self )
{
	// little hack to not autokill a player that leave the race at the end using F5/F3 (chase+join)
	self->deathtimestamp=level.timemsec;

	return ClientRespawn( self );
}
