/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/* gs_items.c	-	game shared items definitions */

#include "../game/q_shared.h"
#include "gs_public.h"

//============================================================================

// item box
vec3_t	item_box_mins = { -16.0f, -16.0f, -16.0f };
vec3_t	item_box_maxs = { 16.0f, 16.0f, 48.0f };

//===========================
//
//	ITEM DEFS
//
//===========================

gitem_t	itemdefs[] = 
{
	{
		NULL
	},	// leave index 0 alone


	//-----------------------------------------------------------
	// WEAPONS ITEMS
	//-----------------------------------------------------------

	// WEAP_GUNBLADE = 1

	//QUAKED weapon_gunblade 
	//always owned, never in the world
	{
		"weapon_gunblade",					// entity name
		WEAP_GUNBLADE,						// item tag, weapon model for weapons
		IT_WEAPON,							// item type
		ITFLAG_USABLE|ITFLAG_STAY_COOP,		// game flags

		{ PATH_GUNBLADE_MODEL, 0 },			// models 1 and 2
		PATH_GUNBLADE_ICON,					// icon
		S_PICKUP_WEAPON,					// pickup sound
		0,									// effects
		0,									// renderfx
		
		"Gunblade",							// pickup name
		"GB",								// short name
		S_COLOR_WHITE,						// message color  // TODO: add color
		1,									// count of items given at pickup
		AMMO_CELLS,							// strong ammo tag
		AMMO_NONE,							// weak ammo tag
		NULL,								// miscelanea info pointer
		"weapon_gauntlet",					// q3 entity name
		PATH_GUNBLADEBLAST_STRONG_MODEL, NULL, NULL
	},

	//QUAKED shockwave
	//always owned, never in the world
	{
		"weapon_shockwave",
		WEAP_SHOCKWAVE,
		IT_WEAPON,
		ITFLAG_PICKABLE|ITFLAG_USABLE|ITFLAG_DROPABLE|ITFLAG_STAY_COOP,

		{PATH_SHOCKWAVE_MODEL, 0 },
		PATH_SHOCKWAVE_ICON,
		S_PICKUP_WEAPON,
		EF_ROTATE_AND_BOB|EF_OUTLINE,
		0,
		
		"Shockwave", "SW", S_COLOR_BLUE,
		1,
		AMMO_WAVES,
		AMMO_WEAK_WAVES,
		NULL,
		"weapon_bfg",
		NULL, NULL, NULL
	},

	//QUAKED riotgun
	{
		"weapon_riotgun",
		WEAP_RIOTGUN,
		IT_WEAPON,
		ITFLAG_PICKABLE|ITFLAG_USABLE|ITFLAG_DROPABLE|ITFLAG_STAY_COOP,

		{PATH_RIOTGUN_MODEL, 0 }, 
		PATH_RIOTGUN_ICON,
		S_PICKUP_WEAPON,
		EF_ROTATE_AND_BOB|EF_OUTLINE,
		0,
		
		"Riotgun", "RG", S_COLOR_ORANGE,
		1,							
		AMMO_SHELLS,
		AMMO_WEAK_SHELLS,
		NULL,
		"weapon_shotgun",
		NULL, NULL, NULL
	},

	//QUAKED weapon_grenadelauncher (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"weapon_grenadelauncher",
		WEAP_GRENADELAUNCHER,
		IT_WEAPON,
		ITFLAG_PICKABLE|ITFLAG_USABLE|ITFLAG_DROPABLE|ITFLAG_STAY_COOP,

		{ PATH_GRENADELAUNCHER_MODEL, 0 },
		PATH_GRENADELAUNCHER_ICON,
		S_PICKUP_WEAPON,
		EF_ROTATE_AND_BOB|EF_OUTLINE,
		0,
		
		"Grenade Launcher", "GL", S_COLOR_BLUE,
		1,
		AMMO_GRENADES,
		AMMO_WEAK_GRENADES,
		NULL,
		"weapon_grenadelauncher",
		"models/objects/projectile/glauncher/grenadestrong.md3 models/objects/projectile/glauncher/grenadeweak.md3",
		// PATH_GRENADE_WEAK_MODEL PATH_GRENADE_STRONG_MODEL
		NULL, NULL
	},

	//QUAKED weapon_rocketlauncher (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"weapon_rocketlauncher",
		WEAP_ROCKETLAUNCHER,
		IT_WEAPON,
		ITFLAG_PICKABLE|ITFLAG_USABLE|ITFLAG_DROPABLE|ITFLAG_STAY_COOP,

		{ PATH_ROCKETLAUNCHER_MODEL, 0 },
		PATH_ROCKETLAUNCHER_ICON,
		S_PICKUP_WEAPON,
		EF_ROTATE_AND_BOB|EF_OUTLINE,
		0,
		
		"Rocket Launcher", "RL", S_COLOR_RED,
		1,
		AMMO_ROCKETS,
		AMMO_WEAK_ROCKETS,
		NULL,
		"weapon_rocketlauncher",
		"models/objects/projectile/rlauncher/rocket_weak.md3 models/objects/projectile/rlauncher/rocket_strong.md3",
		// PATH_ROCKET_WEAK_MODEL PATH_ROCKET_STRONG_MODEL
		"sounds/weapons/rocket_fly_weak sounds/weapons/rocket_fly_strong",
		// S_WEAPON_ROCKET_W_FLY S_WEAPON_ROCKET_S_FLY
		NULL
	},

	//QUAKED weapon_plasmagun (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"weapon_plasmagun",
		WEAP_PLASMAGUN,
		IT_WEAPON,
		ITFLAG_PICKABLE|ITFLAG_USABLE|ITFLAG_DROPABLE|ITFLAG_STAY_COOP,

		{ PATH_PLASMAGUN_MODEL, 0 }, 
		PATH_PLASMAGUN_ICON,
		S_PICKUP_WEAPON,
		EF_ROTATE_AND_BOB|EF_OUTLINE,
		0,
		
		"Plasmagun", "PG", S_COLOR_GREEN,
		1,
		AMMO_PLASMA,
		AMMO_WEAK_PLASMA,
		NULL,
		"weapon_plasmagun", 
		"models/objects/projectile/plasmagun/proj_plasmagun.md3 models/objects/projectile/plasmagun/proj_plasmagun.md3",
		// PATH_PLASMA_WEAK_MODEL PATH_PLASMA_STRONG_MODEL
		"sounds/weapons/plasmagun_weak_fly sounds/weapons/plasmagun_strong_fly",
		NULL
		// S_WEAPON_PLASMAGUN_W_FLY S_WEAPON_PLASMAGUN_S_FLY
	},

	//QUAKED lasergun
	{
		"weapon_lasergun", 
		WEAP_LASERGUN,
		IT_WEAPON,
		ITFLAG_PICKABLE|ITFLAG_USABLE|ITFLAG_DROPABLE|ITFLAG_STAY_COOP,

		{ PATH_LASERGUN_MODEL, 0 },
		PATH_LASERGUN_ICON,
		S_PICKUP_WEAPON,
		EF_ROTATE_AND_BOB|EF_OUTLINE,
		0,

		"Lasergun", "LG", S_COLOR_YELLOW,
		1,
		AMMO_LASERS,
		AMMO_WEAK_LASERS,
		NULL,
		"weapon_lightning", 
		NULL, "sounds/weapons/laser_strong_hum sounds/weapons/laser_weak_hum", NULL
		// S_WEAPON_LASERGUN_S_HUM, S_WEAPON_LASERGUN_W_HUM
	},

	//QUAKED electrobolt
	{
		"weapon_electrobolt", 
		WEAP_ELECTROBOLT,
		IT_WEAPON,
		ITFLAG_PICKABLE|ITFLAG_USABLE|ITFLAG_DROPABLE|ITFLAG_STAY_COOP,
		
		{ PATH_ELECTROBOLT_MODEL, 0 },
		PATH_ELECTROBOLT_ICON,
		S_PICKUP_WEAPON,
		EF_ROTATE_AND_BOB|EF_OUTLINE,
		0,
		
		"Electrobolt", "EB", S_COLOR_CYAN,
		1,
		AMMO_BOLTS,
		AMMO_WEAK_BOLTS,
		NULL,
		"weapon_railgun", 
		PATH_ELECTROBOLT_WEAK_MODEL, NULL, NULL
	},
	

	//-----------------------------------------------------------
	// AMMO ITEMS
	//-----------------------------------------------------------

	// AMMO_BULLETS = WEAP_TOTAL

	//QUAKED ammo_gunblade (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_gunblade",
		AMMO_CELLS,
		IT_AMMO,
		ITFLAG_PICKABLE|ITFLAG_DROPABLE,
		
		{ PATH_AMMO_BOX_MODEL, PATH_AMMO_BOX_MODEL2 },
		PATH_GUNBLADE_AMMO_ICON,
		S_PICKUP_AMMO,
		EF_ROTATE_AND_BOB|EF_OUTLINE|EF_AMMOBOX,
		0,
		
		"Cells", "cells", S_COLOR_YELLOW,
		0,		// actual value comes from weapondefs instead
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"ammo_bullets",
		NULL, NULL, NULL
	},

	//QUAKED ammo_shockwave (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_shockwave",
		AMMO_WAVES,
		IT_AMMO,
		ITFLAG_PICKABLE|ITFLAG_DROPABLE,

		{ PATH_AMMO_BOX_MODEL, PATH_AMMO_BOX_MODEL2 },
		PATH_SHOCKWAVE_AMMO_ICON,
		S_PICKUP_AMMO,
		EF_ROTATE_AND_BOB|EF_OUTLINE|EF_AMMOBOX,
		0,
		
		"Waves", "waves", S_COLOR_BLUE,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"ammo_bfg",
		NULL, NULL, NULL
	},

	//QUAKED ammo_riotgun (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_riotgun",
		AMMO_SHELLS,
		IT_AMMO,
		ITFLAG_PICKABLE|ITFLAG_DROPABLE,

		{ PATH_AMMO_BOX_MODEL, PATH_AMMO_BOX_MODEL2 },
		PATH_RIOTGUN_AMMO_ICON,
		S_PICKUP_AMMO,
		EF_ROTATE_AND_BOB|EF_OUTLINE|EF_AMMOBOX,
		0,
		
		"Shells", "shells", S_COLOR_ORANGE,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"ammo_shells",
		NULL, NULL, NULL
	},

	//QUAKED ammo_grenadelauncher (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_grenadelauncher",
		AMMO_GRENADES,
		IT_AMMO,
		ITFLAG_PICKABLE|ITFLAG_DROPABLE,

		{ PATH_AMMO_BOX_MODEL, PATH_AMMO_BOX_MODEL2 },
		PATH_GRENADELAUNCHER_AMMO_ICON,
		S_PICKUP_AMMO,
		EF_ROTATE_AND_BOB|EF_OUTLINE|EF_AMMOBOX,
		0,
		
		"Grenades", "grens", S_COLOR_BLUE,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"ammo_grenades",
		NULL, NULL, NULL
	},

	//QUAKED ammo_rocketlauncher (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_rocketlauncher",
		AMMO_ROCKETS,
		IT_AMMO,
		ITFLAG_PICKABLE|ITFLAG_DROPABLE,
		
		{ PATH_AMMO_BOX_MODEL, PATH_AMMO_BOX_MODEL2 },
		PATH_ROCKETLAUNCHER_AMMO_ICON,
		S_PICKUP_AMMO,
		EF_ROTATE_AND_BOB|EF_OUTLINE|EF_AMMOBOX,
		0,
		
		"Rockets", "rox", S_COLOR_RED,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"ammo_rockets",
		NULL, NULL, NULL
	},

	//QUAKED ammo_plasmagun (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_plasmagun",
		AMMO_PLASMA,
		IT_AMMO,
		ITFLAG_PICKABLE|ITFLAG_DROPABLE,

		{ PATH_AMMO_BOX_MODEL, PATH_AMMO_BOX_MODEL2 }, 
		PATH_PLASMAGUN_AMMO_ICON,
		S_PICKUP_AMMO,
		EF_ROTATE_AND_BOB|EF_OUTLINE|EF_AMMOBOX,
		0,
		
		"Plasma", "plasma", S_COLOR_GREEN,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"ammo_cells",
		NULL, NULL, NULL
	},

	//QUAKED ammo_lasergun (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_lasergun",
		AMMO_LASERS,
		IT_AMMO,
		ITFLAG_PICKABLE|ITFLAG_DROPABLE,

		{ PATH_AMMO_BOX_MODEL, PATH_AMMO_BOX_MODEL2 },
		PATH_LASERGUN_AMMO_ICON,
		S_PICKUP_AMMO,
		EF_ROTATE_AND_BOB|EF_OUTLINE|EF_AMMOBOX,
		0,

		"Lasers", "lasers", S_COLOR_YELLOW,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"ammo_lightning",
		NULL, NULL, NULL
	},

	//QUAKED ammo_electrobolt (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_electrobolt",
		AMMO_BOLTS,
		IT_AMMO,
		ITFLAG_PICKABLE|ITFLAG_DROPABLE,
		
		{ PATH_AMMO_BOX_MODEL, PATH_AMMO_BOX_MODEL2 },
		PATH_ELECTROBOLT_AMMO_ICON,
		S_PICKUP_AMMO,
		EF_ROTATE_AND_BOB|EF_OUTLINE|EF_AMMOBOX,
		0,
		
		"Bolts", "bolts", S_COLOR_CYAN,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"ammo_slugs",
		NULL, NULL, NULL
	},

	//------------------------
	// WEAK AMMOS
	// Never in world. They are given at picking the weapons
	//------------------------
	//QUAKED ammo_gunblade_weak (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_gunblade_weak",
		AMMO_WEAK_GUNBLADE,
		IT_AMMO,
		0,
		
		{ 0, 0 },
		PATH_GUNBLADE_ICON,
		NULL,
		0,
		0,

		"Blades", "weak blades", NULL,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		NULL,
		NULL, NULL, NULL
	},

	//QUAKED ammo_shockwave_weak (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_shockwave_weak",
		AMMO_WEAK_WAVES,
		IT_AMMO,
		0,

		{ 0, 0 },
		PATH_SHOCKWAVE_ICON,
		NULL,
		0,
		0,
		"Weak Waves", "weak waves", NULL,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		NULL,
		NULL, NULL, NULL
	},

	//QUAKED ammo_riotgun_weak (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_riotgun_weak",
		AMMO_WEAK_SHELLS,
		IT_AMMO,
		0,

		{ 0, 0 },
		PATH_RIOTGUN_ICON,
		NULL,
		0,
		0,
		"Weak Shells", "weak shells", NULL,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		NULL,
		NULL
	},

	//QUAKED ammo_grenadelauncher_weak (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_grenadelauncher_weak",
		AMMO_WEAK_GRENADES,
		IT_AMMO,
		0,

		{ 0, 0 },
		PATH_GRENADELAUNCHER_ICON,
		NULL,
		0,
		0,
		"Weak Grenades", "weak grens", NULL,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		NULL,
		NULL, NULL, NULL
	},

	//QUAKED ammo_rocketlauncher_weak (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_rocketlauncher_weak",
		AMMO_WEAK_ROCKETS,
		IT_AMMO,
		0,

		{ 0, 0 },
		PATH_ROCKETLAUNCHER_ICON,
		NULL,
		0,
		0,
		"Weak Rockets", "weak rox", NULL,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		NULL,
		NULL, NULL, NULL
	},

	//QUAKED ammo_plasmagun_weak (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_plasmagun_weak",
		AMMO_WEAK_PLASMA,
		IT_AMMO,
		0,

		{ 0, 0 }, 
		PATH_PLASMAGUN_ICON,
		NULL,
		0,
		0,
		"Weak Plasma", "weak plasma", NULL,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		NULL,
		NULL, NULL, NULL
	},

	//QUAKED ammo_lasergun_weak (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_lasergun_weak",
		AMMO_WEAK_LASERS,
		IT_AMMO,
		0,

		{ 0, 0 },
		PATH_LASERGUN_ICON,
		NULL,
		0,
		0,
		"Weak Lasers", "weak lasers", NULL,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		NULL,
		NULL, NULL, NULL
	},

	//QUAKED ammo_electrobolt_weak (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"ammo_electrobolt_weak",
		AMMO_WEAK_BOLTS,
		IT_AMMO,
		0,

		{ 0, 0 },
		PATH_ELECTROBOLT_ICON,
		NULL,
		0,
		0,
		"Weak Bolts", "weak bolts", NULL,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		NULL,
		NULL, NULL, NULL
	},


	//------------------------
	// ARMOR
	//------------------------
	//QUAKED item_armor_ga (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"item_armor_ga",
		ARMOR_GA,
		IT_ARMOR,
		ITFLAG_PICKABLE,

		{ PATH_GA_MODEL, 0 }, 
		PATH_GA_ICON,
		S_PICKUP_ARMOR_GA,
		EF_ROTATE_AND_BOB|EF_OUTLINE,
		0,

		"Green Armor", "GA", S_COLOR_GREEN,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"item_armor_jacket",
		NULL, NULL, NULL
	},

	//QUAKED item_armor_ya (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"item_armor_ya", 
		ARMOR_YA,
		IT_ARMOR,
		ITFLAG_PICKABLE,

		{ PATH_YA_MODEL, 0 }, 
		PATH_YA_ICON,
		S_PICKUP_ARMOR_YA,
		EF_ROTATE_AND_BOB|EF_OUTLINE,
		0,

		"Yellow Armor", "YA", S_COLOR_YELLOW,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"item_armor_combat",
		NULL, NULL, NULL
	},

	//QUAKED item_armor_ra (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"item_armor_ra", 
		ARMOR_RA,
		IT_ARMOR,
		ITFLAG_PICKABLE,

		{ PATH_RA_MODEL, 0 }, 
		PATH_RA_ICON,
		S_PICKUP_ARMOR_RA,
		EF_ROTATE_AND_BOB|EF_OUTLINE,
		0,

		"Red Armor", "RA", S_COLOR_RED,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"item_armor_body",
		NULL, NULL, NULL
	},

	//QUAKED item_armor_shard (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"item_armor_shard",
		ARMOR_SHARD,
		IT_ARMOR,
		ITFLAG_PICKABLE,

		{ PATH_SHARD_MODEL, 0 },
		PATH_SHARD_ICON,
		S_PICKUP_ARMOR_SHARD,
		EF_ROTATE_AND_BOB|EF_OUTLINE,
		0,

		"Armor Shard", "shard", S_COLOR_GREEN,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"item_armor_shard", 
		NULL, NULL, NULL
	},

	//------------------------
	// HEALTH ITEMS
	//------------------------

	//QUAKED item_health_small (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"item_health_small",
		HEALTH_SMALL,
		IT_HEALTH,
		ITFLAG_PICKABLE,

		{ PATH_SMALL_HEALTH_MODEL, 0 },
		PATH_HEALTH_5_ICON,
		S_PICKUP_HEALTH_SMALL,
		EF_ROTATE_AND_BOB,
		RF_NOSHADOW,

		"5 Health", "5H", S_COLOR_GREEN,
		5,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"item_health_small",
		NULL, NULL, NULL
	},

	//QUAKED item_health_medium (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"item_health_medium",
		HEALTH_MEDIUM,
		IT_HEALTH,
		ITFLAG_PICKABLE,

		{ PATH_MEDIUM_HEALTH_MODEL, 0 },
		PATH_HEALTH_25_ICON,
		S_PICKUP_HEALTH_MEDIUM,
		EF_ROTATE_AND_BOB,
		RF_NOSHADOW,

		"25 Health", "25H", S_COLOR_YELLOW,
		25,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"item_health",
		NULL, NULL, NULL
	},

	//QUAKED item_health_large (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"item_health_large",
		HEALTH_LARGE,
		IT_HEALTH,
		ITFLAG_PICKABLE,

		{ PATH_LARGE_HEALTH_MODEL, 0 }, 
		PATH_HEALTH_50_ICON,
		S_PICKUP_HEALTH_LARGE,
		EF_ROTATE_AND_BOB,
		RF_NOSHADOW,

		"50 Health", "50H", S_COLOR_ORANGE,
		50,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"item_health_large",
		NULL, NULL, NULL
	},

	//QUAKED item_health_mega (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"item_health_mega",
		HEALTH_MEGA,
		IT_HEALTH,
		ITFLAG_PICKABLE,

		{ PATH_MEGA_HEALTH_MODEL, 0 }, 
		PATH_HEALTH_100_ICON,
		S_PICKUP_HEALTH_MEGA,
		EF_ROTATE_AND_BOB,
		RF_NOSHADOW,

		"Mega Health", "MH", S_COLOR_MAGENTA,
		100,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"item_health_mega",
		NULL, NULL, NULL
	},


	//------------------------
	// POWERUP ITEMS
	//------------------------
	//QUAKED item_quad (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"item_quad",
		POWERUP_QUAD,
		IT_POWERUP,
		ITFLAG_PICKABLE|ITFLAG_USABLE|ITFLAG_DROPABLE,

		{ "models/powerups/instant/quad.md3", 
		"models/powerups/instant/quad_ring.md3" },
		PATH_QUAD_ICON,
		S_PICKUP_QUAD,
		EF_ROTATE_AND_BOB,
		RF_NOSHADOW,

		"Quad Damage", "QUAD", NULL,
		60,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"item_quad",
		NULL,
		"sounds/items/quad_use sounds/items/quad_fire",
		// S_QUAD_USE S_QUAD_FIRE
		NULL
	},

	//QUAKED item_ammopack (.3 .3 1) (-16 -16 -16) (16 16 16)
	{
		"item_ammopack",
		AMMO_PACK,
		IT_AMMO,
		ITFLAG_PICKABLE,
		
		{ PATH_AMMO_PACK_MODEL, 0 },
		PATH_AMMOPACK_ICON,
		S_PICKUP_AMMO,
		EF_ROTATE_AND_BOB|EF_OUTLINE,
		0,

		"Ammo Pack", "ammo pack", NULL,
		1,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		NULL,
		NULL, NULL, NULL
	},

	//
	//	FLAGS
	//
	//QUAKED team_CTF_redflag (1 0.2 0) (-16 -16 -24) (16 16 32)
	{
		"team_CTF_redflag",
		FLAG_RED,
		IT_FLAG,
		ITFLAG_PICKABLE|ITFLAG_DROPABLE,

		{ PATH_FLAG_BASE_MODEL, 0 }, 
		PATH_REDFLAG_ICON,
		NULL,
		EF_OUTLINE,
		0,

		"Red Flag", "red flag", S_COLOR_RED,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"team_CTF_redflag",
		PATH_FLAG_MODEL, "sounds/ctf/flagcap", NULL
	},

	//QUAKED team_CTF_blueflag (1 0.2 0) (-16 -16 -24) (16 16 32)
	{
		"team_CTF_blueflag",
		FLAG_BLUE,
		IT_FLAG,
		ITFLAG_PICKABLE|ITFLAG_DROPABLE,

		{ PATH_FLAG_BASE_MODEL, 0 },
		PATH_BLUEFLAG_ICON,
		NULL,
		EF_OUTLINE,
		0,

		"Blue Flag", "blue flag", S_COLOR_BLUE,
		0,
		AMMO_NONE,
		AMMO_NONE,
		NULL,
		"team_CTF_blueflag",
		PATH_FLAG_MODEL, "sounds/ctf/flagcap", NULL
	},

	//newgametypes[start]
	//QUAKED team_CTF_greenflag (1 0.2 0) (-16 -16 -24) (16 16 32)
	{
		"team_CTF_greenflag",
		FLAG_GREEN,
		IT_FLAG,
		ITFLAG_PICKABLE|ITFLAG_DROPABLE,

		{ PATH_FLAG_BASE_MODEL },
		PATH_GREENFLAG_ICON,
		NULL,
		EF_OUTLINE,
		0,

		"Green Flag", "green flag", S_COLOR_GREEN,
		0,
		AMMO_NONE,
		AMMO_NONE,
		PATH_FLAG_MODEL,
		NULL,
		NULL, "sounds/ctf/flagcap", NULL
	},

	//QUAKED team_CTF_yellowflag (1 0.2 0) (-16 -16 -24) (16 16 32)
	{
		"team_CTF_yellowflag",
		FLAG_YELLOW,
		IT_FLAG,
		ITFLAG_PICKABLE|ITFLAG_DROPABLE,

		{ PATH_FLAG_BASE_MODEL, 0 },
		PATH_YELLOWFLAG_ICON,
		NULL,
		EF_OUTLINE,
		0,

		"Yellow Flag", "yellow flag", S_COLOR_YELLOW,
		0,
		AMMO_NONE,
		AMMO_NONE,
		PATH_FLAG_MODEL,
		NULL,
		NULL, "sounds/ctf/flagcap", NULL
	},

	// end of list marker
	{NULL}
};

//====================================================================

//===============
//GS_FindItemByTag
//===============
gitem_t	*GS_FindItemByTag( int tag )
{
	gitem_t	*it;

	if( tag <= 0 || tag >= GS_MAX_ITEM_TAGS )
		return NULL;

	for( it = &itemdefs[1]; it->classname; it++ ) {
		if( tag == it->tag )
			return it;
	}

	return NULL;
}

//===============
//GS_FindItemByClassname
//===============
gitem_t	*GS_FindItemByClassname( char *classname )
{
	gitem_t	*it;

	if( !classname )
		return NULL;

	for( it = &itemdefs[1]; it->classname; it++ ) {
		if( !Q_stricmp(classname, it->classname) )
			return it;
	}

	return NULL;
}

//===============
//GS_FindItemByName
//===============
gitem_t	*GS_FindItemByName( char *name )
{
	gitem_t	*it;

	if( !name )
		return NULL;

	for( it = &itemdefs[1]; it->classname; it++ ) {
		if( !Q_stricmp(name, it->pickup_name) || !Q_stricmp(name, it->short_name) )
			return it;
	}

	return NULL;
}
