/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "../game/q_shared.h"
#include "gs_public.h"


//============================================================================

/*
================
GS_Obituary

Can be called by either the server or the client
================
*/
void GS_Obituary( void *victim, int gender, void *attacker, int mod, char *message, char *message2 )
{
    message [0] = 0;
    message2[0] = 0;

    if( !attacker || attacker == victim )
    {
        switch( mod )
        {
            case MOD_SUICIDE:
                strcpy( message, "suicides" );
                break;
            case MOD_FALLING:
                strcpy( message, "cratered" );
                break;
            case MOD_CRUSH:
                strcpy( message, "was squished" );
                break;
            case MOD_WATER:
                strcpy( message, "sank like a rock" );
                break;
            case MOD_SLIME:
                strcpy( message, "melted" );
                break;
            case MOD_LAVA:
                strcpy( message, "sacrificed to the lava god" ); // wsw : pb : some killed messages
                break;
            case MOD_EXPLOSIVE:
            case MOD_BARREL:
                strcpy( message, "blew up" );
                break;
            case MOD_EXIT:
                strcpy( message, "found a way out" );
                break;
            case MOD_TARGET_LASER:
                strcpy( message, "saw the light" );
                break;
            case MOD_TARGET_BLASTER:
                strcpy( message, "got blasted" );
                break;
            case MOD_BOMB:
            case MOD_SPLASH:
            case MOD_TRIGGER_HURT:
                strcpy( message, "was in the wrong place" );
                break;
            default:
                if( gender == GENDER_FEMALE )
                    strcpy( message, "killed herself" );
                else if( gender == GENDER_MALE )
                    strcpy( message, "killed himself" );
                else
                    strcpy( message, "killed itself" );
                break;
        }
        return;
    }

    switch (mod)
    {
        /* TODO: Missing messages
        case MOD_SUICIDE:
            break;
        case MOD_FALLING:
            break;
        case MOD_CRUSH:
            break;
        case MOD_WATER:
            break;
        case MOD_SLIME:
            break;
        case MOD_LAVA:
            break;
        case MOD_EXPLOSIVE:
        case MOD_BARREL:
            break;
        case MOD_EXIT:
            break;
        case MOD_TARGET_LASER:
            break;
        case MOD_TARGET_BLASTER:
            break;
        case MOD_BOMB:
        case MOD_SPLASH:
        case MOD_TRIGGER_HURT:
            break; */
        case MOD_TELEFRAG:
            strcpy( message, "tried to invade" );
            strcpy( message2, "'s personal space" );
            break;
            // wsw : pb : some killed messages
        case MOD_GUNBLADE_W:
            strcpy( message, "was impaled by" );
            strcpy( message2, "'s gunblade" );
            break;
        case MOD_GUNBLADE_S:
            strcpy( message, "was killed by" );
            strcpy( message2, "'s almighty gunblade" ); // TODO
            break;
        case MOD_RIOTGUN_W:
        case MOD_RIOTGUN_S:
            strcpy( message, "was killed by" );
            strcpy( message2, "'s riotgun" );
            break;
        case MOD_GRENADE_W:
        case MOD_GRENADE_S:
            strcpy( message, "was popped by" );
            strcpy( message2, "'s grenade" );
            break;
        case MOD_ROCKET_W:
        case MOD_ROCKET_S:
            strcpy( message, "ate" );
            strcpy( message2, "'s rocket" );
            break;
        case MOD_PLASMA_W:
        case MOD_PLASMA_S:
            strcpy( message, "was melted by" );
            strcpy( message2, "'s plasmagun" );
            break;
        case MOD_ELECTROBOLT_W:
        case MOD_ELECTROBOLT_S:
            strcpy( message, "was bolted by" );
            strcpy( message2, "'s electrobolt" );
            break;
        case MOD_LASERGUN_W:
        case MOD_LASERGUN_S:
            strcpy( message, "was cut by" );
            strcpy( message2, "'s lasergun" );
            break;
        case MOD_GRENADE_SPLASH_W:
        case MOD_GRENADE_SPLASH_S:
            strcpy( message, "didn't see" );
            strcpy( message2, "'s grenade" );
            break;
        case MOD_ROCKET_SPLASH_W:
        case MOD_ROCKET_SPLASH_S:
            strcpy( message, "almost dodged" );
            strcpy( message2, "'s rocket" );
            break;

        case MOD_PLASMA_SPLASH_W:
        case MOD_PLASMA_SPLASH_S:
            strcpy( message, "was melted by" );
            strcpy( message2,"'s plasmagun" );
            break;

        default:
            strcpy( message, "was killed by" );
            break;
    }
}
