/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "ui_local.h"
void M_Menu_Setup_f( void );
void M_Menu_Quit_f( void );

/*
=======================================================================

MAIN MENU

=======================================================================
*/
static menuframework_s	s_game_menu;

static void M_Game_MenuMainFunc( menucommon_t *menuitem )
{
	trap_Cmd_ExecuteText( EXEC_APPEND, "menu_main" );
}

static void M_Game_DisconnectFunc( menucommon_t *menuitem )
{
	trap_Cmd_ExecuteText( EXEC_APPEND, "disconnect" );
}

static void M_Game_JoinFunc( menucommon_t *menuitem )
{
	trap_Cmd_ExecuteText( EXEC_APPEND, "cmd join" );
	M_PopMenu();
}

static void M_Game_SpecFunc( menucommon_t *menuitem )
{
	trap_Cmd_ExecuteText( EXEC_APPEND, "cmd spec" );
	M_PopMenu();
}

static void M_Game_LeaveQueueFunc( menucommon_t *menuitem )
{
	trap_Cmd_ExecuteText( EXEC_APPEND, "cmd leavequeue" );
	M_PopMenu();
}

static void M_Game_JoinQueueFunc( menucommon_t *menuitem )
{
	trap_Cmd_ExecuteText( EXEC_APPEND, "cmd enterqueue" );
	M_PopMenu();
}

static void M_Game_ReadyFunc( menucommon_t *menuitem )
{
	trap_Cmd_ExecuteText( EXEC_APPEND, "cmd ready" );
	M_PopMenu();
}


void M_Game_Init( void )
{
	int y = 0;
	int yoffset = 0;
	int m_gametype, m_teambased = 0, m_clientteam = TEAM_SPECTATOR, m_is_challenger = 0, m_needs_ready = 0;
	static char tittlename[64];
	menucommon_t *menuitem;

	s_game_menu.x = uis.vidWidth / 2;
	s_game_menu.y = uis.vidHeight / 2 - 138;
	s_game_menu.nitems = 0;

	Q_strncpyz( tittlename, "WARSOW", sizeof(tittlename) ); 

	// first arg is gametype
	if( trap_Cmd_Argc() > 1 ) {
		m_gametype = atoi( trap_Cmd_Argv(1) );
	}
	if( m_gametype < GAMETYPE_DM || m_gametype >= GAMETYPE_TOTAL )
		m_gametype = GAMETYPE_DM;

	// second is teambased
	if( trap_Cmd_Argc() > 2 ) {
		m_teambased = atoi( trap_Cmd_Argv(2) );
	}

	// 3rd is team
	if( trap_Cmd_Argc() > 3 ) {
		m_clientteam = atoi( trap_Cmd_Argv(3) );
		if( m_clientteam < TEAM_SPECTATOR || m_clientteam > GS_MAX_TEAMS )
			m_clientteam = TEAM_SPECTATOR;

	}
	//4th is challengers queue ( 0 = gametype has no queue, 1 = is not in queue, 2 = is in queue
	if( trap_Cmd_Argc() > 4 ) {
		m_is_challenger = atoi( trap_Cmd_Argv(4) );
	}

	//5th is needs_ready
	if( trap_Cmd_Argc() > 5 ) {
		m_needs_ready = atoi( trap_Cmd_Argv(5) );
	}

	// 5th tittle
	if( trap_Cmd_Argc() > 6 ) {
		Q_snprintfz( tittlename, sizeof(tittlename), "%s ", trap_Cmd_Argv(6) );
	}

	menuitem = UI_InitMenuItem( "m_game_tittle1", tittlename, 0, y+yoffset, MTYPE_SEPARATOR, ALIGN_CENTER_TOP, uis.fontSystemBig, NULL );
	Menu_AddItem( &s_game_menu, menuitem );
	yoffset += 2 * trap_SCR_strHeight( menuitem->font );

	if( m_is_challenger ) {
		if( m_is_challenger == 1 ) {
			menuitem = UI_InitMenuItem( "m_game_join_challengers", "join challengers queue", 0, y+yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_Game_JoinQueueFunc );
			Menu_AddItem( &s_game_menu, menuitem );
		} else {
			menuitem = UI_InitMenuItem( "m_game_spec_challengers", "leave challengers queue", 0, y+yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_Game_LeaveQueueFunc );
			Menu_AddItem( &s_game_menu, menuitem );
		}
	} 
	else {
		if( m_clientteam == TEAM_SPECTATOR ) {
			menuitem = UI_InitMenuItem( "m_game_join", "join", 0, y+yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_Game_JoinFunc );
			Menu_AddItem( &s_game_menu, menuitem );
		} else {
			menuitem = UI_InitMenuItem( "m_game_spec", "spectate", 0, y+yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_Game_SpecFunc );
			Menu_AddItem( &s_game_menu, menuitem );
		}
	}

	yoffset += trap_SCR_strHeight( menuitem->font );

	if( m_needs_ready ) {
		
		menuitem = UI_InitMenuItem( "m_game_ready", "ready", 0, y+yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_Game_ReadyFunc );
		Menu_AddItem( &s_game_menu, menuitem );
		yoffset += trap_SCR_strHeight( menuitem->font );
	}

	yoffset += 0.5 * trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_game_setup", "main menu", 0, y+yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_Game_MenuMainFunc );
	Menu_AddItem( &s_game_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_game_disconnect", "disconnect", 0, y+yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_Game_DisconnectFunc );
	Menu_AddItem( &s_game_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_ingame_back", "back", 0, y+yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_genericBackFunc );
	Menu_AddItem( &s_game_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	Menu_Init( &s_game_menu );

	Menu_SetStatusBar( &s_game_menu, NULL );
}

void M_Game_Draw( void )
{
	Menu_AdjustCursor( &s_game_menu, 1 );
	Menu_Draw( &s_game_menu );
}

const char *M_Game_Key( int key )
{
	return Default_MenuKey( &s_game_menu, key );
}

const char *M_Game_CharEvent( int key )
{
	return Default_MenuCharEvent( &s_game_menu, key );
}

void M_Menu_Game_f( void )
{
	M_Game_Init();
	M_PushMenu( &s_game_menu, M_Game_Draw, M_Game_Key, M_Game_CharEvent );
}
