/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "ui_local.h"

/*
=======================================================================

GFX MENU

=======================================================================
*/

static menuframework_s	s_gfx_menu;

static void UpdateMaxFPSFunc( menucommon_t *menuitem )
{
	char *buf;
	buf = UI_GetMenuitemFieldBuffer( menuitem );
	if( buf )trap_Cvar_Set( "cl_maxfps", buf );
}

static void UpdateFOVFunc( menucommon_t *menuitem )
{
	char *buf;

	buf = UI_GetMenuitemFieldBuffer( menuitem );
	if( buf ) {
		int	newfov = atoi( buf );
		clamp( newfov, 1, 160 );
		trap_Cvar_SetValue( "fov", newfov );
	}
}

static void UpdateSkyQualityFunc( menucommon_t *menuitem )
{
	trap_Cvar_SetValue( "r_fastsky", !menuitem->curvalue );
}

static void UpdateDynamicLightsFunc( menucommon_t *menuitem )
{
	trap_Cvar_SetValue( "r_dynamiclight", menuitem->curvalue );
}

static void UpdateLightFlaresFunc( menucommon_t *menuitem )
{
	trap_Cvar_SetValue( "r_flares", menuitem->curvalue );
}

static void UpdateSimpleItemsFunc( menucommon_t *menuitem )
{
	trap_Cvar_SetValue( "cg_simpleItems", menuitem->curvalue );
}
static void UpdateShowFPSFunc( menucommon_t *menuitem )
{
	trap_Cvar_SetValue( "cg_showFPS", menuitem->curvalue );
}

static void UpdateSpeedMeterFunc( menucommon_t *menuitem )
{
	trap_Cvar_SetValue( "cg_showspeedmeter", menuitem->curvalue );
}

static void UpdateWeaponlistFunc( menucommon_t *menuitem )
{
	trap_Cvar_SetValue( "cg_weaponlist", menuitem->curvalue );
}

static void UpdateMarksFunc( menucommon_t *menuitem )
{
	trap_Cvar_SetValue( "cg_decals", menuitem->curvalue );
}

static void UpdateHelpFunc( menucommon_t *menuitem )
{
	trap_Cvar_SetValue( "cg_showhelp", menuitem->curvalue );
}

static void UpdateColorItemOutlines( menucommon_t *menuitem )
{
	trap_Cvar_SetValue( "cg_outlineItemsBlack", menuitem->curvalue == 0 );
}

static void UpdateColorPlayerOutlines( menucommon_t *menuitem )
{
	trap_Cvar_SetValue( "cg_outlinePlayersBlack", menuitem->curvalue == 0 );
}

static void ApplyChanges( menucommon_t *unused )
{
	menucommon_t *menuitem;

	// cl_maxfps
	menuitem = UI_MenuItemByName( "m_gfx_maxfps" );
	UpdateMaxFPSFunc(menuitem);

	// fov
	menuitem = UI_MenuItemByName( "m_gfx_fov" );
	UpdateFOVFunc(menuitem);

	// r_fastsky
	menuitem = UI_MenuItemByName( "m_gfx_sky" );
	UpdateSkyQualityFunc(menuitem);

	// r_dynamiclight
	menuitem = UI_MenuItemByName( "m_gfx_dlights" );
	UpdateDynamicLightsFunc(menuitem);

	// r_flares
	menuitem = UI_MenuItemByName( "m_gfx_flares" );
	UpdateLightFlaresFunc(menuitem);

	// cg_simpleItems
	menuitem = UI_MenuItemByName( "m_gfx_simpleitems" );
	UpdateSimpleItemsFunc(menuitem);

	// cg_showFPS
	menuitem = UI_MenuItemByName( "m_gfx_showfps" );
	UpdateShowFPSFunc(menuitem);

	// cg_showspeedmeter
	menuitem = UI_MenuItemByName( "m_gfx_showspeed" );
	UpdateSpeedMeterFunc(menuitem);

	// cg_weaponlist
	menuitem = UI_MenuItemByName( "m_gfx_weaponlist" );
	UpdateWeaponlistFunc(menuitem);

	// cg_decals
	menuitem = UI_MenuItemByName( "m_gfx_decals" );
	UpdateMarksFunc(menuitem);

	// cg_outlineItemsBlack
	menuitem = UI_MenuItemByName( "m_gfx_itemoutlines" );
	UpdateColorItemOutlines(menuitem);

	// cg_outlinePlayersBlack
	menuitem = UI_MenuItemByName( "m_gfx_playeroutlines" );
	UpdateColorPlayerOutlines(menuitem);

	// cg_showhelp
	menuitem = UI_MenuItemByName( "m_gfx_showhelp" );
	UpdateHelpFunc(menuitem);
}
static void BackFunc(menucommon_t  *menuitem)
{
	ApplyChanges( menuitem);
	M_genericBackFunc( menuitem);
}

void Gfx_MenuInit( void )
{
	menucommon_t *menuitem;
	int w, h;
	int y = 0;
	int yoffset = 0;

	static char *sky_quality_items[] =
	{
		"fast", "good", 0
	};

	/*
	** configure controls menu and menu items
	*/
	w = uis.vidWidth;
	h = uis.vidHeight;

	s_gfx_menu.x = w / 2;
	s_gfx_menu.nitems = 0;

	menuitem = UI_InitMenuItem( "m_gfx_tittle1", "Graphics Options", 0, y+yoffset, MTYPE_SEPARATOR, ALIGN_CENTER_TOP, uis.fontSystemBig, NULL );
	Menu_AddItem( &s_gfx_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font ) + 16;

	// cl_maxfps
	menuitem = UI_InitMenuItem( "m_gfx_maxfps", "Client max fps", 0, y+yoffset, MTYPE_FIELD, ALIGN_RIGHT_TOP, uis.fontSystemSmall, UpdateMaxFPSFunc );
	Menu_AddItem( &s_gfx_menu, menuitem );
	UI_SetupField( menuitem, trap_Cvar_VariableString("cl_maxfps"), 4, -1 );
	yoffset += trap_SCR_strHeight( menuitem->font );

	// fov
	menuitem = UI_InitMenuItem( "m_gfx_fov", "Client FOV", 0, y+yoffset, MTYPE_FIELD, ALIGN_RIGHT_TOP, uis.fontSystemSmall, UpdateFOVFunc );
	Menu_AddItem( &s_gfx_menu, menuitem );
	UI_SetupField( menuitem, trap_Cvar_VariableString("fov")?trap_Cvar_VariableString("fov"):"90", 4, -1 );
	yoffset += trap_SCR_strHeight( menuitem->font );

	// r_fastsky
	menuitem = UI_InitMenuItem( "m_gfx_sky", "Sky", 0, y+yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, UpdateSkyQualityFunc );
	Menu_AddItem( &s_gfx_menu, menuitem );
	UI_SetupSpinControl( menuitem, sky_quality_items, !(int)trap_Cvar_VariableValue( "r_fastsky" ) );
	yoffset += trap_SCR_strHeight( menuitem->font );

	// r_dynamiclight
	menuitem = UI_InitMenuItem( "m_gfx_dlights", "Dynamic lights", 0, y+yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, UpdateDynamicLightsFunc );
	Menu_AddItem( &s_gfx_menu, menuitem );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "r_dynamiclight" ) );
	yoffset += trap_SCR_strHeight( menuitem->font );

	// r_flares
	menuitem = UI_InitMenuItem( "m_gfx_flares", "Light flares", 0, y+yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, UpdateLightFlaresFunc );
	Menu_AddItem( &s_gfx_menu, menuitem );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "r_flares" ) );
	yoffset += trap_SCR_strHeight( menuitem->font );

	// cg_simpleItems
	menuitem = UI_InitMenuItem( "m_gfx_simpleitems", "Simple items", 0, y+yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, UpdateSimpleItemsFunc );
	Menu_AddItem( &s_gfx_menu, menuitem );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "cg_simpleItems" ) );
	yoffset += trap_SCR_strHeight( menuitem->font );

	// cg_showFPS
	menuitem = UI_InitMenuItem( "m_gfx_showfps", "Show fps", 0, y+yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, UpdateShowFPSFunc );
	Menu_AddItem( &s_gfx_menu, menuitem );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "cg_showFPS" ) );
	yoffset += trap_SCR_strHeight( menuitem->font );

	// cg_showspeedmeter
	menuitem = UI_InitMenuItem( "m_gfx_showspeed", "Show speed meter", 0, y+yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, UpdateSpeedMeterFunc );
	Menu_AddItem( &s_gfx_menu, menuitem );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "cg_showspeedmeter" ) );
	yoffset += trap_SCR_strHeight( menuitem->font );

	// cg_weaponlist
	menuitem = UI_InitMenuItem( "m_gfx_weaponlist", "HUD weapon list", 0, y+yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, UpdateWeaponlistFunc );
	Menu_AddItem( &s_gfx_menu, menuitem );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "cg_weaponlist" ) );
	yoffset += trap_SCR_strHeight( menuitem->font );

	// cg_decals
	menuitem = UI_InitMenuItem( "m_gfx_decals", "marks on walls", 0, y+yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, UpdateMarksFunc );
	Menu_AddItem( &s_gfx_menu, menuitem );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "cg_decals" ) );
	yoffset += trap_SCR_strHeight( menuitem->font );

	// cg_outlineItemsBlack
	menuitem = UI_InitMenuItem( "m_gfx_itemoutlines", "colored item outlines", 0, y+yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, UpdateColorItemOutlines );
	Menu_AddItem( &s_gfx_menu, menuitem );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "cg_outlineItemsBlack" ) == 0 );
	yoffset += trap_SCR_strHeight( menuitem->font );

	// cg_outlinePlayersBlack
	menuitem = UI_InitMenuItem( "m_gfx_playeroutlines", "colored player outlines", 0, y+yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, UpdateColorPlayerOutlines );
	Menu_AddItem( &s_gfx_menu, menuitem );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "cg_outlinePlayersBlack" ) == 0 );
	yoffset += trap_SCR_strHeight( menuitem->font );

	// cg_showhelp
	menuitem = UI_InitMenuItem( "m_gfx_showhelp", "show help messages", 0, y+yoffset, MTYPE_SPINCONTROL, ALIGN_RIGHT_TOP, uis.fontSystemSmall, UpdateHelpFunc );
	Menu_AddItem( &s_gfx_menu, menuitem );
	UI_SetupSpinControl( menuitem, offon_names, trap_Cvar_VariableValue( "cg_showhelp" ) );
	yoffset += trap_SCR_strHeight( menuitem->font );

	// back
	menuitem = UI_InitMenuItem( "m_gfx_back", "back", -16, y+yoffset, MTYPE_ACTION, ALIGN_RIGHT_TOP, uis.fontSystemBig, BackFunc );
	Menu_AddItem( &s_gfx_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	Menu_Center( &s_gfx_menu );
	Menu_Init( &s_gfx_menu );
}

void Gfx_MenuDraw( void )
{
	Menu_AdjustCursor( &s_gfx_menu, 1 );
	Menu_Draw( &s_gfx_menu );
}

const char *Gfx_MenuKey( int key )
{
	return Default_MenuKey( &s_gfx_menu, key );
}

const char *Gfx_MenuCharEvent( int key )
{
	return Default_MenuCharEvent( &s_gfx_menu, key );
}

void M_Menu_Gfx_f( void )
{
	Gfx_MenuInit();
	M_PushMenu( &s_gfx_menu, Gfx_MenuDraw, Gfx_MenuKey, Gfx_MenuCharEvent );
}
